/*
 * Decompiled with CFR 0.152.
 */
package oldcore.trash;

import oldcore.trash.RoleDefinitions;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.util.Numberable;

public class RoleDefinition
implements Numberable {
    private int id;
    private Role role;
    private Primary primary;
    private Role inversion;
    private Roles composition;
    private AlterAge alterAge;
    private Gender alterGender;
    private Gender egoGender;
    private String other;

    public RoleDefinition(int id) {
        this.id = id;
        this.alterGender = Gender.UNKNOWN;
        this.egoGender = Gender.UNKNOWN;
    }

    public RoleDefinition(int id, Role role, Primary primary, Role inversion, Roles composition, Gender alterGender, AlterAge alterAge, Gender egoGender) {
        this.id = id;
        this.role = role;
        this.primary = primary;
        this.inversion = inversion;
        if (composition != null && composition.size() > 0) {
            this.composition = composition;
        }
        this.alterGender = alterGender;
        this.alterAge = alterAge;
        this.egoGender = egoGender;
        if (this.composition != null && this.composition.size() == 2 && this.composition.get(1) == null) {
            System.err.println("Composition error: " + id + " " + role + " " + this.composition.get(0));
        }
    }

    public AlterAge alterAge() {
        return this.alterAge;
    }

    public String alterAgeAsString() {
        String result = this.alterAge == null ? "" : this.alterAge.toString();
        return result;
    }

    public Gender alterGender() {
        return this.alterGender;
    }

    public String alterGenderAsString() {
        String result = this.alterGender == null ? "" : this.alterGender.toString();
        return result;
    }

    public String alterGenderAsSymbol() {
        String result = this.alterGender == null || this.alterGender == Gender.UNKNOWN ? "" : String.valueOf(this.alterGender.toSymbol());
        return result;
    }

    public RoleDefinition clone() {
        Roles compositionClone = null;
        if (this.composition != null) {
            compositionClone = this.composition.clone();
        }
        RoleDefinition result = new RoleDefinition(this.id, this.role, this.primary, this.inversion, compositionClone, this.alterGender, this.alterAge, this.egoGender);
        return result;
    }

    public Roles composition() {
        return this.composition;
    }

    private String compositionAsString() {
        String result = RoleDefinitions.isNullOrHasNullFactor(this.composition) ? "" : String.valueOf(((Role)this.composition.get(0)).getName()) + " \u00b0 " + ((Role)this.composition.get(1)).getName();
        return result;
    }

    public Gender egoGender() {
        return this.egoGender;
    }

    String egoGenderAsSpeakerString() {
        String result = this.egoGender == null ? "" : this.egoGender.toSpeakerString();
        return result;
    }

    public String egoGenderAsString() {
        String result = this.egoGender == null ? "" : this.egoGender.toString();
        return result;
    }

    public boolean equals(Object obj) {
        RoleDefinition other = (RoleDefinition)obj;
        boolean result = !(!this.role.equals(other.role()) || this.alterGender != other.alterGender || this.egoGender != other.egoGender || this.alterAge != other.alterAge || this.primary != other.primary || this.inversion != null && !this.inversion.equals(other.inversion) || this.composition != null && !this.composition.equals(other.composition));
        return result;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getInversePrimaryAsString(RoleDefinitions roleDefinitions) {
        String result = "";
        for (RoleDefinition roleDefinition : roleDefinitions) {
            if (!this.inversion.equals(roleDefinition.role()) || roleDefinition.primary() != Primary.PARENT) continue;
            if (this.alterGender.isUnknown()) {
                result = "Ch";
                continue;
            }
            if (this.alterGender.isMale()) {
                result = "S";
                continue;
            }
            if (!this.alterGender.isFemale()) continue;
            result = "D";
        }
        return result;
    }

    public String getPrimaryAsString() {
        String result = "";
        if (this.primary != null) {
            switch (this.primary) {
                case PARENT: {
                    if (this.alterGender.isUnknown()) {
                        result = "Pa";
                        break;
                    }
                    if (this.alterGender.isMale()) {
                        result = "F";
                        break;
                    }
                    if (!this.alterGender.isFemale()) break;
                    result = "M";
                    break;
                }
                case SIBLING: {
                    if (this.alterGender.isUnknown()) {
                        result = "Sb";
                    } else if (this.alterGender.isMale()) {
                        result = "B";
                    } else if (this.alterGender.isFemale()) {
                        result = "Z";
                    }
                    if (this.alterAge == AlterAge.ELDER) {
                        result = "e" + result;
                        break;
                    }
                    if (this.alterAge != AlterAge.YOUNGER) break;
                    result = "y" + result;
                    break;
                }
                case SPOUSE: {
                    if (this.alterGender.isUnknown()) {
                        result = "Sp";
                        break;
                    }
                    if (this.alterGender.isMale()) {
                        result = "H";
                        break;
                    }
                    if (!this.alterGender.isFemale()) break;
                    result = "W";
                }
            }
        }
        return result;
    }

    @Override
    public String hashKey() {
        String result = "" + this.id;
        return result;
    }

    public Role inversion() {
        return this.inversion;
    }

    private String inversionAsString() {
        String result = this.inversion == null ? "" : "-" + this.inversion.getName();
        return result;
    }

    public Primary primary() {
        return this.primary;
    }

    public String primaryAsString() {
        String result = this.primary == null ? "" : this.primary.toString();
        return result;
    }

    public Role role() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setAlterAge(AlterAge alterAge) {
        this.alterAge = alterAge;
    }

    public void setAlterGender(Gender alterGender) {
        this.alterGender = alterGender;
    }

    public void setEgoGender(Gender egoGender) {
        this.egoGender = egoGender;
    }

    public void setPrimary(Primary primary) {
        this.primary = primary;
    }

    public void setInversion(Role inversion) {
        this.inversion = inversion;
    }

    public void setComposition() {
        this.composition = new Roles();
    }

    public String other() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        String alterGenderSymbol = "";
        if (!this.alterGender.isUnknown()) {
            alterGenderSymbol = " " + this.alterGender.toSymbol();
        }
        String result = String.valueOf(this.role.getName()) + "\t" + this.alterAgeAsString() + alterGenderSymbol + " " + this.primaryAsString() + " " + this.inversionAsString() + " " + this.compositionAsString() + " " + this.egoGenderAsSpeakerString();
        if (this.other != null) {
            result = String.valueOf(result) + "\t" + this.other;
        }
        return result;
    }

    public static enum AlterAge {
        ELDER,
        YOUNGER;


        public AlterAge invert() {
            AlterAge result = this == ELDER ? YOUNGER : (this == YOUNGER ? ELDER : null);
            return result;
        }
    }

    public static enum Primary {
        PARENT,
        SIBLING,
        SPOUSE;

    }
}

