/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.random.RandomGraphReporter;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.report.Report;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.RandomPermutationCriteria;

public class RandomPermutationInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(RandomPermutationInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private JPanel contentPane;
    private JSpinner spinnerRuns;
    private JCheckBox chckbxExtract;

    public RandomPermutationInputWindow(final GroupNetGUI groupNetGUI) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(RandomPermutationInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.setTitle("Random Permutation Input Window");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 365, 175);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomPermutationInputWindow.this.dispose();
            }
        });
        JButton btnRestoreDefaults = new JButton("Restore defaults");
        btnRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomPermutationInputWindow.this.setCriteria(new RandomPermutationCriteria());
            }
        });
        buttonPanel.add(btnRestoreDefaults);
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RandomPermutationCriteria criteria = RandomPermutationInputWindow.this.getCriteria();
                    PuckGUI.instance().getPreferences().setRandomPermutationCriteria(criteria);
                    MatrixStatistics sourceStats = new MatrixStatistics(groupNetGUI.getGroupNet());
                    MatrixStatistics randStats = RandomGraphReporter.createRandomGraphStatisticsByRandomPermutation(groupNetGUI.getGroupNet(), criteria.getNumberOfRuns());
                    Report report = RandomGraphReporter.reportRandomAllianceNetworkByRandomPermutation(criteria.getNumberOfRuns(), randStats, sourceStats);
                    if (criteria.isExtractRepresentative()) {
                        if (StringUtils.isBlank((CharSequence)randStats.getGraph().getLabel())) {
                            randStats.getGraph().setLabel("Random Group Network");
                        }
                        GroupNetGUI newGUI = PuckGUI.instance().createGroupNetGUI(randStats.getGraph());
                        newGUI.addReportTab(report);
                    } else {
                        groupNetGUI.addReportTab(report);
                    }
                    RandomPermutationInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(RandomPermutationInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "North");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblNrRuns = new JLabel("Number of runs:");
        lblNrRuns.setHorizontalAlignment(0);
        panel.add((Component)lblNrRuns, "2, 4, right, default");
        this.spinnerRuns = new JSpinner();
        this.spinnerRuns.setModel(new SpinnerNumberModel(new Integer(100), new Integer(0), null, new Integer(100)));
        panel.add((Component)this.spinnerRuns, "4, 4");
        this.chckbxExtract = new JCheckBox("Extract a representative network");
        panel.add((Component)this.chckbxExtract, "2, 6, 3, 1");
        this.setCriteria(PuckGUI.instance().getPreferences().getRandomPermutationCriteria());
    }

    public RandomPermutationCriteria getCriteria() throws PuckException {
        RandomPermutationCriteria result = new RandomPermutationCriteria();
        result.setNumberOfRuns((Integer)this.spinnerRuns.getValue());
        result.setExtractRepresentative(this.chckbxExtract.isSelected());
        return result;
    }

    public void setCriteria(RandomPermutationCriteria source) {
        if (source != null) {
            this.spinnerRuns.setValue(source.getNumberOfRuns());
            this.chckbxExtract.setSelected(source.isExtractRepresentative());
        }
    }
}

