/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.random.DistributionType;
import org.tip.puck.graphs.random.RandomCriteria;
import org.tip.puck.graphs.random.RandomGraphMaker;
import org.tip.puck.graphs.random.RandomGraphReporter;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.report.Report;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.WindowGUI;

public class RandomAllianceNetworkByAgentSimulationInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(RandomAllianceNetworkByAgentSimulationInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private JPanel contentPane;
    private JSpinner spinnerArcCount;
    private JSpinner spinnerNodeCount;
    private JSpinner spinnerRuns;
    private JSpinner spnrInertia0;
    private JSpinner spnrInertia1;
    private JSpinner spnrInertia2;
    private JSpinner spnrOutpreference;
    private JCheckBox chckbxExtract;
    private JCheckBox chckbxShowProbabilityEvolution;
    private JComboBox cbBoxDistribution;

    public RandomAllianceNetworkByAgentSimulationInputWindow(final WindowGUI gui) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(RandomAllianceNetworkByAgentSimulationInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.setTitle("Random Alliance Network");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 365, 400);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomAllianceNetworkByAgentSimulationInputWindow.this.dispose();
            }
        });
        JButton btnRestoreDefaults = new JButton("Restore defaults");
        btnRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomAllianceNetworkByAgentSimulationInputWindow.this.setCriteria(new RandomCriteria());
            }
        });
        buttonPanel.add(btnRestoreDefaults);
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RandomCriteria criteria = RandomAllianceNetworkByAgentSimulationInputWindow.this.getCriteria();
                    PuckGUI.instance().getPreferences().setAgentSimulationCriteria(criteria);
                    RandomGraphMaker randomGraphMaker = new RandomGraphMaker(criteria);
                    List graphs = randomGraphMaker.createRandomGraphsByAgentSimulation(criteria.getRunCount());
                    System.out.println("Graphs constructed");
                    double[][] probabilityEvolution = criteria.isShowProbabilityEvolution() ? randomGraphMaker.getProbaEvolution() : null;
                    MatrixStatistics matrixStatistics = GraphReporter.getMatrixStatistics(graphs);
                    Report report = RandomGraphReporter.reportRandomAllianceNetworkByAgentSimulation(criteria, matrixStatistics, probabilityEvolution);
                    if (criteria.isExtractRepresentative()) {
                        if (StringUtils.isBlank((CharSequence)matrixStatistics.getGraph().getLabel())) {
                            matrixStatistics.getGraph().setLabel("Random Group Network");
                        }
                        GroupNetGUI newGUI = PuckGUI.instance().createGroupNetGUI(matrixStatistics.getGraph());
                        newGUI.addReportTab(report);
                    } else {
                        gui.addReportTab(report);
                    }
                    RandomAllianceNetworkByAgentSimulationInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(RandomAllianceNetworkByAgentSimulationInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "North");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblNrNodes = new JLabel("Number of nodes:");
        lblNrNodes.setHorizontalAlignment(0);
        panel.add((Component)lblNrNodes, "2, 4, right, default");
        this.spinnerNodeCount = new JSpinner();
        this.spinnerNodeCount.setModel(new SpinnerNumberModel(new Integer(100), new Integer(0), null, new Integer(10)));
        panel.add((Component)this.spinnerNodeCount, "4, 4");
        JLabel lblNrArcs = new JLabel("Number of arcs:");
        lblNrArcs.setHorizontalAlignment(0);
        panel.add((Component)lblNrArcs, "2, 6, right, default");
        this.spinnerArcCount = new JSpinner();
        this.spinnerArcCount.setModel(new SpinnerNumberModel(new Integer(1000), new Integer(0), null, new Integer(100)));
        panel.add((Component)this.spinnerArcCount, "4, 6");
        JLabel lblNrRuns = new JLabel("Number of runs:");
        lblNrRuns.setHorizontalAlignment(0);
        panel.add((Component)lblNrRuns, "2, 8, right, default");
        this.spinnerRuns = new JSpinner();
        this.spinnerRuns.setModel(new SpinnerNumberModel(new Integer(100), new Integer(0), null, new Integer(100)));
        panel.add((Component)this.spinnerRuns, "4, 8");
        JLabel lbInertia0 = new JLabel("Inertia 0:");
        panel.add((Component)lbInertia0, "2, 10, right, default");
        this.spnrInertia0 = new JSpinner();
        this.spnrInertia0.setModel(new SpinnerNumberModel(new Double(1.0), new Double(0.0), null, new Double(0.1)));
        panel.add((Component)this.spnrInertia0, "4, 10");
        JLabel lblInertia1 = new JLabel("Inertia 1:");
        lblInertia1.setHorizontalAlignment(0);
        panel.add((Component)lblInertia1, "2, 12, right, default");
        this.spnrInertia1 = new JSpinner();
        this.spnrInertia1.setModel(new SpinnerNumberModel(new Double(1.0), new Double(0.0), null, new Double(0.1)));
        panel.add((Component)this.spnrInertia1, "4, 12");
        JLabel lblInertia2 = new JLabel("Inertia 2:");
        lblInertia2.setHorizontalAlignment(0);
        panel.add((Component)lblInertia2, "2, 14, right, default");
        this.spnrInertia2 = new JSpinner();
        this.spnrInertia2.setModel(new SpinnerNumberModel(new Double(1.0), new Double(0.0), null, new Double(0.1)));
        panel.add((Component)this.spnrInertia2, "4, 14");
        JLabel lblOutPref = new JLabel("Out preference:");
        lblOutPref.setHorizontalAlignment(0);
        panel.add((Component)lblOutPref, "2, 16, right, default");
        this.spnrOutpreference = new JSpinner();
        this.spnrOutpreference.setModel(new SpinnerNumberModel(new Double(0.5), new Double(0.0), null, new Double(0.1)));
        ((JSpinner.NumberEditor)this.spnrOutpreference.getEditor()).getFormat().setMinimumFractionDigits(1);
        panel.add((Component)this.spnrOutpreference, "4, 16");
        JLabel lblEgoDistribution = new JLabel("Ego distribution:");
        lblEgoDistribution.setHorizontalAlignment(4);
        panel.add((Component)lblEgoDistribution, "2, 18, right, default");
        this.cbBoxDistribution = new JComboBox();
        this.cbBoxDistribution.setModel(new DefaultComboBoxModel<DistributionType>(DistributionType.values()));
        panel.add((Component)this.cbBoxDistribution, "4, 18, fill, default");
        this.chckbxExtract = new JCheckBox("Extract a representative network");
        panel.add((Component)this.chckbxExtract, "2, 20");
        this.chckbxShowProbabilityEvolution = new JCheckBox("Show probability evolution");
        panel.add((Component)this.chckbxShowProbabilityEvolution, "2, 22");
        this.setCriteria(PuckGUI.instance().getPreferences().getAgentSimulationCriteria());
    }

    public RandomCriteria getCriteria() throws PuckException {
        RandomCriteria result = new RandomCriteria();
        result.setNodeCount((Integer)this.spinnerNodeCount.getValue());
        result.setArcWeightSum((Integer)this.spinnerArcCount.getValue());
        result.setInertia0((Double)this.spnrInertia0.getValue());
        result.setInertia1((Double)this.spnrInertia1.getValue());
        result.setInertia2((Double)this.spnrInertia2.getValue());
        result.setOutPreference((Double)this.spnrOutpreference.getValue());
        result.setRunCount((Integer)this.spinnerRuns.getValue());
        result.setExtractRepresentative(this.chckbxExtract.isSelected());
        result.setShowProbabilityEvolution(this.chckbxShowProbabilityEvolution.isSelected());
        result.setDistributionType((DistributionType)((Object)this.cbBoxDistribution.getSelectedItem()));
        return result;
    }

    public void setCriteria(RandomCriteria source) {
        if (source != null) {
            this.spinnerNodeCount.setValue(source.getNodeCount());
            this.spinnerArcCount.setValue(source.getArcWeightSum());
            this.spnrInertia0.setValue(source.getInertia()[0]);
            this.spnrInertia1.setValue(source.getInertia()[1]);
            this.spnrInertia2.setValue(source.getInertia()[2]);
            this.spnrOutpreference.setValue(source.getOutPreference());
            this.spinnerRuns.setValue(source.getRunCount());
            this.chckbxExtract.setSelected(source.isExtractRepresentative());
            this.chckbxShowProbabilityEvolution.setSelected(source.isShowProbabilityEvolution());
            this.cbBoxDistribution.setSelectedItem((Object)source.getDistributionType());
        }
    }
}

