/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.GraphType;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.PajekExportCriteria;

public class PajekExportInputDialog
extends JDialog {
    private static final long serialVersionUID = 2212434892206449348L;
    private final JPanel contentPanel = new JPanel();
    private static PajekExportCriteria defaultCriteria = new PajekExportCriteria();
    private PajekExportCriteria inputedCriteria;
    private JTextField txtfldTargetFile;
    private final ButtonGroup buttonGroupGraphType = new ButtonGroup();
    private JRadioButton rdbtnPgraph;
    private JComboBox cmbbxLabel1;
    private JComboBox cmbbxLabel2;
    private JComboBox cmbbxLabel3;
    private JComboBox cmbbxLabel4;
    private JComboBox cmbbxLabel5;
    private JRadioButton rdbtnOregraph;
    private JRadioButton rdbtnTipgraph;
    private Object[] labels;
    private JDialog thisJDialog = this;
    private File file;
    private JPanel panelPartitionLabels;

    public PajekExportInputDialog(final File file, List<String> sourceLabels) {
        this.file = file;
        if (file != null) {
            defaultCriteria.setTargetFileName(ToolBox.setExtension(file.getAbsoluteFile(), ".paj").getAbsolutePath());
        }
        this.setMinimumSize(new Dimension(350, 0));
        this.setResizable(false);
        if (sourceLabels == null) {
            this.labels = new String[1];
            this.labels[0] = "";
        } else {
            sourceLabels.add(0, "");
            this.labels = sourceLabels.toArray();
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Export To Pajek Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PajekExportInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PajekExportInputDialog.this.inputedCriteria = null;
                PajekExportInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 387, 310);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, "Graph Type", 4, 2, null, null));
        this.contentPanel.add((Component)panel, "2, 2, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.rdbtnOregraph = new JRadioButton("Ore-Graph");
        this.rdbtnOregraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PajekExportInputDialog.this.setEnablePartitionlabels(true);
            }
        });
        this.rdbtnOregraph.setSelected(true);
        panel.add((Component)this.rdbtnOregraph, "2, 2");
        this.buttonGroupGraphType.add(this.rdbtnOregraph);
        this.rdbtnTipgraph = new JRadioButton("Tip-Graph");
        this.rdbtnTipgraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PajekExportInputDialog.this.setEnablePartitionlabels(true);
            }
        });
        panel.add((Component)this.rdbtnTipgraph, "2, 4");
        this.buttonGroupGraphType.add(this.rdbtnTipgraph);
        this.rdbtnPgraph = new JRadioButton("P-Graph");
        this.rdbtnPgraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PajekExportInputDialog.this.setEnablePartitionlabels(false);
            }
        });
        panel.add((Component)this.rdbtnPgraph, "2, 6");
        this.buttonGroupGraphType.add(this.rdbtnPgraph);
        this.panelPartitionLabels = new JPanel();
        this.panelPartitionLabels.setBorder(new TitledBorder(null, "Partition Labels", 4, 2, null, null));
        this.contentPanel.add((Component)this.panelPartitionLabels, "4, 2, fill, fill");
        this.panelPartitionLabels.setLayout(new BoxLayout(this.panelPartitionLabels, 1));
        this.cmbbxLabel1 = new JComboBox();
        this.panelPartitionLabels.add(this.cmbbxLabel1);
        this.cmbbxLabel2 = new JComboBox();
        this.panelPartitionLabels.add(this.cmbbxLabel2);
        this.cmbbxLabel3 = new JComboBox();
        this.panelPartitionLabels.add(this.cmbbxLabel3);
        this.cmbbxLabel4 = new JComboBox();
        this.panelPartitionLabels.add(this.cmbbxLabel4);
        this.cmbbxLabel5 = new JComboBox();
        this.panelPartitionLabels.add(this.cmbbxLabel5);
        panel = new JPanel();
        panel.setBorder(new TitledBorder(null, "Target File", 4, 2, null, null));
        this.contentPanel.add((Component)panel, "2, 4, 3, 1, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.txtfldTargetFile = new JTextField();
        panel.add((Component)this.txtfldTargetFile, "2, 2");
        this.txtfldTargetFile.setColumns(10);
        JButton buttonClear = new JButton("");
        buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PajekExportInputDialog.this.txtfldTargetFile.setText("");
            }
        });
        panel.add((Component)buttonClear, "4, 2");
        buttonClear.setIcon(new ImageIcon(PajekExportInputDialog.class.getResource("/org/tip/puckgui/images/edit-clear-16x16.png")));
        JButton buttonBrowse = new JButton("...");
        buttonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File targetFile = StringUtils.isBlank((CharSequence)PajekExportInputDialog.this.txtfldTargetFile.getText()) ? file : ToolBox.setExtension(new File(PajekExportInputDialog.this.txtfldTargetFile.getText()), ".paj");
                File selection = PajekExportInputDialog.selectFile(PajekExportInputDialog.this.thisJDialog, targetFile);
                if (selection != null) {
                    selection = ToolBox.setExtension(selection, ".paj");
                    PajekExportInputDialog.this.txtfldTargetFile.setText(selection.getAbsolutePath());
                }
            }
        });
        panel.add((Component)buttonBrowse, "6, 2");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PajekExportInputDialog.this.inputedCriteria = null;
                PajekExportInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton btnExport = new JButton("Export");
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isBlank((CharSequence)PajekExportInputDialog.this.txtfldTargetFile.getText())) {
                    String title = "Error computerum est";
                    String message = "Please, enter a valid file.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    String title;
                    String message;
                    int response;
                    File targetFile = ToolBox.setExtension(new File(PajekExportInputDialog.this.txtfldTargetFile.getText()), ".paj");
                    boolean doExport = targetFile.exists() ? (response = JOptionPane.showConfirmDialog(null, message = "A file already exists with name, erase?.", title = "Confirm", 0)) == 0 : true;
                    if (doExport) {
                        PajekExportInputDialog.this.inputedCriteria = new PajekExportCriteria();
                        if (PajekExportInputDialog.this.rdbtnOregraph.isSelected()) {
                            PajekExportInputDialog.this.inputedCriteria.setGraphType(GraphType.OreGraph);
                        }
                        if (PajekExportInputDialog.this.rdbtnTipgraph.isSelected()) {
                            PajekExportInputDialog.this.inputedCriteria.setGraphType(GraphType.TipGraph);
                        }
                        if (PajekExportInputDialog.this.rdbtnPgraph.isSelected()) {
                            PajekExportInputDialog.this.inputedCriteria.setGraphType(GraphType.PGraph);
                        }
                        PajekExportInputDialog.this.inputedCriteria.setTargetFileName(targetFile.getAbsolutePath());
                        PajekExportInputDialog.this.inputedCriteria.getPartitionLabels().clear();
                        PajekExportInputDialog.this.inputedCriteria.getPartitionLabels().add((String)PajekExportInputDialog.this.cmbbxLabel1.getSelectedItem());
                        PajekExportInputDialog.this.inputedCriteria.getPartitionLabels().add((String)PajekExportInputDialog.this.cmbbxLabel2.getSelectedItem());
                        PajekExportInputDialog.this.inputedCriteria.getPartitionLabels().add((String)PajekExportInputDialog.this.cmbbxLabel3.getSelectedItem());
                        PajekExportInputDialog.this.inputedCriteria.getPartitionLabels().add((String)PajekExportInputDialog.this.cmbbxLabel4.getSelectedItem());
                        PajekExportInputDialog.this.inputedCriteria.getPartitionLabels().add((String)PajekExportInputDialog.this.cmbbxLabel5.getSelectedItem());
                        defaultCriteria = PajekExportInputDialog.this.inputedCriteria;
                        PajekExportInputDialog.this.setVisible(false);
                    }
                }
            }
        });
        btnExport.setActionCommand("OK");
        buttonPane.add(btnExport);
        this.getRootPane().setDefaultButton(btnExport);
        this.setCriteria(defaultCriteria);
    }

    public PajekExportCriteria getCriteria() {
        PajekExportCriteria result = this.inputedCriteria;
        return result;
    }

    private void setCriteria(PajekExportCriteria source) {
        if (source != null) {
            this.rdbtnOregraph.setSelected(false);
            this.rdbtnPgraph.setSelected(false);
            this.rdbtnTipgraph.setSelected(false);
            switch (source.getGraphType()) {
                case OreGraph: {
                    this.rdbtnOregraph.setSelected(true);
                    this.setEnablePartitionlabels(true);
                    break;
                }
                case PGraph: {
                    this.rdbtnPgraph.setSelected(true);
                    this.setEnablePartitionlabels(false);
                    break;
                }
                case TipGraph: {
                    this.rdbtnTipgraph.setSelected(true);
                    this.setEnablePartitionlabels(true);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)source.getTargetFileName())) {
                this.txtfldTargetFile.setText(source.getTargetFileName());
            }
            this.cmbbxLabel1.setModel(new DefaultComboBoxModel<Object>(this.labels));
            this.cmbbxLabel2.setModel(new DefaultComboBoxModel<Object>(this.labels));
            this.cmbbxLabel3.setModel(new DefaultComboBoxModel<Object>(this.labels));
            this.cmbbxLabel4.setModel(new DefaultComboBoxModel<Object>(this.labels));
            this.cmbbxLabel5.setModel(new DefaultComboBoxModel<Object>(this.labels));
            int labelIndex = ArrayUtils.indexOf((Object[])this.labels, (Object)source.getPartitionLabels().get(0));
            if (labelIndex == -1) {
                labelIndex = 0;
            }
            this.cmbbxLabel1.setSelectedIndex(labelIndex);
            labelIndex = ArrayUtils.indexOf((Object[])this.labels, (Object)source.getPartitionLabels().get(1));
            if (labelIndex == -1) {
                labelIndex = 0;
            }
            if ((labelIndex = ArrayUtils.indexOf((Object[])this.labels, (Object)source.getPartitionLabels().get(2))) == -1) {
                labelIndex = 0;
            }
            this.cmbbxLabel3.setSelectedIndex(labelIndex);
            labelIndex = ArrayUtils.indexOf((Object[])this.labels, (Object)source.getPartitionLabels().get(3));
            if (labelIndex == -1) {
                labelIndex = 0;
            }
            this.cmbbxLabel4.setSelectedIndex(labelIndex);
            labelIndex = ArrayUtils.indexOf((Object[])this.labels, (Object)source.getPartitionLabels().get(4));
            if (labelIndex == -1) {
                labelIndex = 0;
            }
            this.cmbbxLabel5.setSelectedIndex(labelIndex);
        }
    }

    private void setEnablePartitionlabels(boolean value) {
        if (value) {
            this.cmbbxLabel1.setEnabled(true);
            this.cmbbxLabel2.setEnabled(true);
            this.cmbbxLabel3.setEnabled(true);
            this.cmbbxLabel4.setEnabled(true);
            this.cmbbxLabel5.setEnabled(true);
        } else {
            this.cmbbxLabel1.setEnabled(false);
            this.cmbbxLabel2.setEnabled(false);
            this.cmbbxLabel3.setEnabled(false);
            this.cmbbxLabel4.setEnabled(false);
            this.cmbbxLabel5.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("ALPHA");
        labels.add("BRAVO");
        labels.add("CHARLIE");
        PajekExportCriteria criteria = PajekExportInputDialog.showDialog(new File("."), labels);
        if (criteria == null) {
            System.out.println("null");
        } else {
            System.out.println("return=" + (Object)((Object)criteria.getGraphType()));
            System.out.println("return=" + criteria.getPartitionLabels());
            System.out.println("return=" + criteria.getTargetFileName());
        }
    }

    public static File selectFile(Component parentPanel, File targetFile) {
        File result;
        JFileChooser chooser = new JFileChooser();
        if (targetFile != null && StringUtils.isNotBlank((CharSequence)targetFile.getAbsolutePath())) {
            chooser.setSelectedFile(ToolBox.setExtension(targetFile, ".paj"));
        }
        chooser.setDialogTitle("Export to Pajek");
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Pajek Network (*.paj)", "paj");
        chooser.addChoosableFileFilter(defaultFileFilter);
        chooser.setFileFilter(defaultFileFilter);
        if (chooser.showSaveDialog(parentPanel) == 0) {
            System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
            System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
            result = chooser.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }

    public static PajekExportCriteria showDialog(File file, List<String> sourceLabels) {
        PajekExportInputDialog dialog = new PajekExportInputDialog(file, sourceLabels);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        PajekExportCriteria result = dialog.getCriteria();
        return result;
    }
}

