/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.chain;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Node;
import org.tip.puck.visualization.layouts.GraphSource;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.BorderContainer;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.containers.ChainContainer;

public class ChainCluster {
    private final GraphSource graphSource;
    private ChainContainer rootContainer;
    private Map<Integer, Set<BorderContainer>> levelBorderContainers = new HashMap<Integer, Set<BorderContainer>>();

    public static ChainCluster createCluster(GraphSource graphSource, Node root, int origin) {
        ChainCluster cc = new ChainCluster(graphSource);
        cc.init(root, origin);
        return cc;
    }

    private ChainCluster(GraphSource graphSource) {
        this.graphSource = graphSource;
    }

    private void init(Node root, int origin) {
        this.rootContainer = ChainContainer.getContainer(root, this.graphSource);
        this.rootContainer.setOrigin(origin);
        if (this.rootContainer instanceof BorderContainer) {
            this.addBorder((BorderContainer)this.rootContainer);
        }
        this.rootContainer.setRootCluster(this);
        this.rootContainer.populateChildren(this.graphSource);
    }

    public void addBorder(BorderContainer border) {
        this.addBorderAtLevel(border, border.getOrigin());
    }

    private void addBorderAtLevel(BorderContainer border, int level) {
        Set<Object> borderSet;
        if (!this.levelBorderContainers.containsKey(level)) {
            borderSet = new HashSet();
            this.levelBorderContainers.put(level, borderSet);
        }
        borderSet = this.levelBorderContainers.get(level);
        borderSet.add(border);
    }

    public Set<BorderContainer> getBordersAtLevel(int level) {
        return this.levelBorderContainers.get(level);
    }

    public int getBorderLevel(BorderContainer border) {
        int level = -1;
        Set<Map.Entry<Integer, Set<BorderContainer>>> entrySet = this.levelBorderContainers.entrySet();
        boolean canGo = true;
        Iterator<Map.Entry<Integer, Set<BorderContainer>>> it = entrySet.iterator();
        while (canGo && it.hasNext()) {
            Map.Entry<Integer, Set<BorderContainer>> entry = it.next();
            Set<BorderContainer> borderSet = entry.getValue();
            if (!borderSet.contains(border)) continue;
            level = entry.getKey();
            canGo = false;
        }
        return level;
    }

    public Set<Integer> getAllLevels() {
        return Collections.unmodifiableSet(this.levelBorderContainers.keySet());
    }

    public ChainContainer getCluster() {
        return this.rootContainer;
    }

    public int getOrigin() {
        return this.rootContainer.getOrigin();
    }

    public int getHeight() {
        return this.rootContainer.getHeight();
    }

    public int getWidth() {
        return this.rootContainer.getWidth();
    }

    public int getArea() {
        return this.rootContainer.getArea();
    }

    public int getSize() {
        return this.rootContainer.getSize();
    }

    public float getDensity() {
        return this.rootContainer.getDensity();
    }

    public GraphSource graphSource() {
        return this.graphSource;
    }
}

