/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.statistics;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteriaList;

public class StatisticsCriteria {
    private boolean genderBIASWeight = true;
    private boolean genderBIASNetWeight = true;
    private boolean components = true;
    private boolean differentialDensity = true;
    private boolean genealogicalCompleteness = true;
    private boolean sibsetDistribution = true;
    private boolean meanClusterValues = true;
    private boolean fourCousinMarriages = true;
    private boolean ancestorTypes = true;
    private boolean consanguineChains = true;
    private int ancestorTypesDegree = 3;
    private int consanguineDegree = 3;
    private PartitionCriteriaList partitionCriteriaList = new PartitionCriteriaList();
    private PartitionCriteria splitCriteria;

    public StatisticsCriteria() {
        this.partitionCriteriaList.add(PartitionCriteria.createRaw("GENDER"));
        this.partitionCriteriaList.add(PartitionCriteria.createRaw("PEDG", "2"));
        this.partitionCriteriaList.add(PartitionCriteria.createRaw("PEDG", "3"));
        this.splitCriteria = PartitionCriteria.createRaw("GENDER");
    }

    public int getAncestorTypesDegree() {
        return this.ancestorTypesDegree;
    }

    public int getConsanguineDegree() {
        return this.consanguineDegree;
    }

    public PartitionCriteriaList getPartitionCriteriaList() {
        return this.partitionCriteriaList;
    }

    public List<String> getPartitionLabels() {
        ArrayList<String> result = new ArrayList<String>();
        for (PartitionCriteria criteria : this.partitionCriteriaList) {
            result.add(criteria.getLabel());
        }
        return result;
    }

    public PartitionCriteria getSplitCriteria() {
        return this.splitCriteria;
    }

    public boolean isAncestorTypes() {
        return this.ancestorTypes;
    }

    public boolean isComponents() {
        return this.components;
    }

    public boolean isConsanguineChains() {
        return this.consanguineChains;
    }

    public boolean isDifferentialDensity() {
        return this.differentialDensity;
    }

    public boolean isFourCousinMarriages() {
        return this.fourCousinMarriages;
    }

    public boolean isSibsetDistribution() {
        return this.sibsetDistribution;
    }

    public boolean isGenderBIASNetWeight() {
        return this.genderBIASNetWeight;
    }

    public boolean isGenderBIASWeight() {
        return this.genderBIASWeight;
    }

    public boolean isGenealogicalCompleteness() {
        return this.genealogicalCompleteness;
    }

    public boolean isMeanClusterValues() {
        return this.meanClusterValues;
    }

    public void setAncestorTypes(boolean value) {
        this.ancestorTypes = value;
    }

    public void setAncestorTypesDegree(int value) {
        this.ancestorTypesDegree = value;
    }

    public void setComponents(boolean components) {
        this.components = components;
    }

    public void setConsanguineChains(boolean consanguineChains) {
        this.consanguineChains = consanguineChains;
    }

    public void setConsanguineDegree(int consanguineDegree) {
        this.consanguineDegree = consanguineDegree;
    }

    public void setDifferentialDensity(boolean differentialDensity) {
        this.differentialDensity = differentialDensity;
    }

    public void setFourCousinMarriages(boolean fourCousinRelations) {
        this.fourCousinMarriages = fourCousinRelations;
    }

    public void setSibsetDistribution(boolean sibsetDistribution) {
        this.sibsetDistribution = sibsetDistribution;
    }

    public void setGenderBIASNetWeight(boolean genderBIASNetWeight) {
        this.genderBIASNetWeight = genderBIASNetWeight;
    }

    public void setGenderBIASWeight(boolean genderBIASWeight) {
        this.genderBIASWeight = genderBIASWeight;
    }

    public void setGenealogicalCompleteness(boolean genealogicalCompleteness) {
        this.genealogicalCompleteness = genealogicalCompleteness;
    }

    public void setMeanClusterValues(boolean meanClusterValues) {
        this.meanClusterValues = meanClusterValues;
    }

    public void setSplitCriteria(PartitionCriteria splitPartitionCriteria) {
        this.splitCriteria = splitPartitionCriteria;
    }

    public static StatisticsCriteria getDefaultCriteria() {
        StatisticsCriteria result = new StatisticsCriteria();
        return result;
    }
}

