/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.net.Individualizable;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.sequences.Ordinal;
import org.tip.puck.sequences.Sequence;
import org.tip.puck.sequences.ValueSequence;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class PartitionSequence<E>
extends Sequence<Partition<E>> {
    List<Ordinal> times;
    String label;
    Boolean numeric;

    public PartitionSequence(String label, List<Ordinal> times) {
        this.times = times;
        this.label = label;
        for (Ordinal time : times) {
            this.put(time, new Partition(String.valueOf(label) + " " + time));
        }
    }

    public void put(Ordinal time, E item, Value value) {
        if (time != null && item != null && value != null) {
            ((Partition)this.getStation(time)).put(item, value);
        }
    }

    public Set<E> getItems() {
        HashSet result = new HashSet();
        for (Ordinal time : this.times) {
            result.addAll(((Partition)this.getStation(time)).getItems());
        }
        return result;
    }

    public List<E> getItemsAsList() {
        ArrayList<E> result = new ArrayList<E>(this.getItems());
        return result;
    }

    public Value getValue(Ordinal time, E item) {
        Value result = ((Partition)this.getStation(time)).getValue(item);
        return result;
    }

    public Map<Value, Double> getMeanValueFrequencies() {
        TreeMap<Value, Double> result = new TreeMap<Value, Double>();
        for (E sliceable : this.getItems()) {
            for (Ordinal time : this.times) {
                Value value = this.getValue(time, sliceable);
                if (value == null) continue;
                Double count = (Double)result.get(value);
                count = count == null ? Double.valueOf(1.0) : Double.valueOf(count + 1.0);
                result.put(value, count);
            }
        }
        for (Value value : result.keySet()) {
            if (result.get(value) != null) continue;
            result.put(value, (Double)result.get(value) / new Double(this.times.size()));
        }
        return result;
    }

    public <V> Partition<E> getValueSequencePartition() {
        Partition<E> result = new Partition<E>();
        for (E member : this.getItems()) {
            Sequence<Value> sequence = new Sequence<Value>();
            for (Ordinal time : this.times) {
                sequence.put(time, this.getValue(time, member));
            }
            result.put(member, new Value(sequence.toValueString()));
        }
        return result;
    }

    public ValueSequence getValueSequence(E item) throws PuckException {
        ValueSequence result;
        if (item instanceof Numberable) {
            result = new ValueSequence(this.label, ((Numberable)item).getId());
            for (Ordinal time : this.times) {
                result.put(time, this.getValue(time, item));
            }
        } else {
            throw PuckExceptions.INVALID_PARAMETER.create(item + "is not numberable.", new Object[0]);
        }
        result.setProfile();
        return result;
    }

    public Cluster<E> getCluster(Ordinal time, Value value) {
        Cluster result = ((Partition)this.getStation(time)).getCluster(value);
        return result;
    }

    public int getClusterSize(Ordinal time, Value value) {
        Cluster<E> cluster = this.getCluster(time, value);
        int result = cluster != null ? cluster.size() : 0;
        return result;
    }

    public double getClusterShare(Ordinal time, Value value) {
        Cluster<E> cluster = this.getCluster(time, value);
        double result = cluster != null ? ((Partition)this.getStation(time)).share(cluster) : 0.0;
        return result;
    }

    public String getClusterItemsAsString(Ordinal time, Value value) {
        Cluster<E> cluster = this.getCluster(time, value);
        String result = cluster != null ? cluster.getItemsAsString() : "";
        return result;
    }

    public Matrix getTransitionMatrix() {
        TreeMap transitionMap = new TreeMap();
        ArrayList<String> values = new ArrayList<String>();
        for (E sliceable : this.getItems()) {
            int i = 1;
            while (i < this.times.size()) {
                Value object1 = this.getValue(this.times.get(i - 1), sliceable);
                Value object2 = this.getValue(this.times.get(i), sliceable);
                if (object1 != null && object2 != null) {
                    Integer count;
                    TreeMap<String, Integer> targetMap;
                    String value1 = object1.toString();
                    String value2 = object2.toString();
                    if (!values.contains(value1)) {
                        values.add(value1);
                    }
                    if (!values.contains(value2)) {
                        values.add(value2);
                    }
                    if ((targetMap = (TreeMap<String, Integer>)transitionMap.get(value1)) == null) {
                        targetMap = new TreeMap<String, Integer>();
                        transitionMap.put(value1, targetMap);
                    }
                    count = (count = (Integer)targetMap.get(value2)) == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                    targetMap.put(value2, count);
                }
                ++i;
            }
        }
        Collections.sort(values);
        String[] labels = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            labels[i] = String.valueOf((String)values.get(i));
            ++i;
        }
        Matrix result = new Matrix(values.size(), values.size());
        result.setRowLabels(labels);
        result.setColLabels(labels);
        for (Object value1 : transitionMap.keySet()) {
            Map targetMap = (Map)transitionMap.get(value1);
            for (Object value2 : targetMap.keySet()) {
                result.augment(values.indexOf(value1), values.indexOf(value2), (Integer)targetMap.get(value2));
            }
        }
        return result;
    }

    public Set<Value> getValues() {
        HashSet<Value> result = new HashSet<Value>();
        for (Ordinal time : this.times) {
            result.addAll(((Partition)this.getStation(time)).getValues());
        }
        return result;
    }

    public List<Value> getValuesAsSortedList() {
        ArrayList<Value> result = new ArrayList<Value>(this.getValues());
        Collections.sort(result);
        return result;
    }

    public Boolean isNumeric() {
        if (this.numeric == null) {
            this.numeric = true;
            for (Value value : this.getValues()) {
                if (!value.isNotNumber()) continue;
                this.numeric = false;
                break;
            }
        }
        return this.numeric;
    }

    public List<?> getMapKeys() {
        ArrayList result = null;
        HashSet keySet = new HashSet();
        for (Value value : this.getValues()) {
            if (!value.isMap()) break;
            keySet.addAll(value.mapValue().keySet());
        }
        if (!keySet.isEmpty()) {
            result = new ArrayList(keySet);
        }
        return result;
    }

    public PartitionSequence<E> unpack(Partition.ValueCode mode) {
        PartitionSequence result = new PartitionSequence(this.label, this.times);
        for (Ordinal time : this.times) {
            for (Object item : ((Partition)this.getStation(time)).getItems()) {
                Value value = ((Partition)this.getStation(time)).getValue(item);
                if (value == null) continue;
                if (value.isPartition()) {
                    result.put(time, item, new Value(value.partitionValue().valueCode(mode)));
                    continue;
                }
                if (value.isMap()) {
                    result.put(time, item, new Value(ToolBox.toKeySetString(value.mapValue())));
                    continue;
                }
                return this;
            }
        }
        return result;
    }

    public PartitionSequence<E> revalue(Partition.ValueCode mode) throws PuckException {
        PartitionSequence result = new PartitionSequence(this.label, this.times);
        for (Ordinal time : this.times) {
            result.put(time, ((Partition)this.getStation(time)).revalue(mode));
        }
        return result;
    }

    public <V extends Numberable> PartitionSequence<V> aggregate(PartitionCriteria criteria) throws PuckException {
        PartitionSequence result = new PartitionSequence(this.label, this.times);
        for (Ordinal time : this.times) {
            result.put(time, ((Partition)this.getStation(time)).aggregate(criteria));
        }
        return result;
    }

    public boolean isMulti() {
        boolean result = false;
        for (Ordinal time : this.times) {
            if (this.getStation(time) == null || !((Partition)this.getStation(time)).isMulti()) continue;
            result = true;
            break;
        }
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasIndividualizableItems() {
        boolean result = false;
        for (E item : this.getItems()) {
            if (item == null) continue;
            if (!(item instanceof Individualizable)) break;
            result = true;
            break;
        }
        return result;
    }
}

