/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.iur;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo2.io.GEOFile;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;

public class IURTXTSplittedFile {
    private static final Logger logger = LoggerFactory.getLogger(IURTXTSplittedFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static Net doImport(File oneFile) throws PuckException {
        Net result;
        try {
            if (oneFile == null) {
                throw new IllegalArgumentException("NUll source parameter.");
            }
            if (!oneFile.isFile()) {
                throw new IllegalArgumentException("Source is not an existing file.");
            }
            String path = oneFile.getAbsolutePath();
            int index = path.lastIndexOf(45) - 3;
            String prefix = path.substring(0, index);
            logger.debug("prefix=[{}]", (Object)prefix);
            File[] files = oneFile.getParentFile().listFiles((FileFilter)FileFilterUtils.prefixFileFilter((String)new File(prefix).getName()));
            Arrays.sort(files, NameFileComparator.NAME_COMPARATOR);
            StringList lines = new StringList();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    lines.addAll((Collection)FileUtils.readLines((File)file, (String)DEFAULT_CHARSET_NAME));
                }
                ++n2;
            }
            String fileContent = lines.toStringSeparatedBy(System.getProperty("line.separator"));
            BufferedReader in = new BufferedReader(new InputStreamReader(IOUtils.toInputStream((String)fileContent)));
            result = IURTXTFile.read(in);
            result.setLabel(prefix);
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create("Importing IURTXTSplitted file.", new Object[0]);
        }
        return result;
    }

    public static void export(File targetDirectory, Net source) throws PuckException {
        if (source == null) {
            throw new IllegalArgumentException("NUll source parameter.");
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException("NUll target parameter.");
        }
        if (!targetDirectory.exists()) {
            throw new IllegalArgumentException("Target directory not found  [" + targetDirectory.getAbsolutePath() + "].");
        }
        String corpusName = FilenameUtils.getBaseName((String)source.getLabel());
        if (!source.attributes().isEmpty()) {
            File targetFile = new File(targetDirectory, String.format("%s-00-corpus.iurs.txt", corpusName));
            PrintWriter out = null;
            try {
                try {
                    out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), DEFAULT_CHARSET_NAME));
                    IURTXTFile.writeCorpusAttributes(out, source.attributes());
                }
                catch (UnsupportedEncodingException exception) {
                    throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + targetFile + "]", new Object[0]);
                }
                catch (FileNotFoundException exception) {
                    throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + targetFile + "]", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)out);
        }
        int fileIndex = 1;
        File targetFile = new File(targetDirectory, String.format("%s-%02d-individuals.iurs.txt", corpusName, fileIndex));
        ++fileIndex;
        Object out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), DEFAULT_CHARSET_NAME));
                IURTXTFile.writeIndividuals((PrintWriter)out, source.individuals());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + targetFile + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + targetFile + "]", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        targetFile = new File(targetDirectory, String.format("%s-%02d-families.iurs.txt", corpusName, fileIndex));
        ++fileIndex;
        out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), DEFAULT_CHARSET_NAME));
                IURTXTFile.writeFamilies((PrintWriter)out, source.families());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + targetFile + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + targetFile + "]", new Object[0]);
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
        for (RelationModel relationModel : source.relationModels()) {
            File targetFile2 = new File(targetDirectory, String.format("%s-%02d-%s.iurs.txt", corpusName, fileIndex, relationModel.getName()));
            ++fileIndex;
            PrintWriter out2 = null;
            try {
                try {
                    out2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile2), DEFAULT_CHARSET_NAME));
                    IURTXTFile.writeRelations(out2, relationModel, source.relations());
                }
                catch (UnsupportedEncodingException exception) {
                    throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + targetFile2 + "]", new Object[0]);
                }
                catch (FileNotFoundException exception) {
                    throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + targetFile2 + "]", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out2);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)out2);
        }
        if (source.getGeography2() != null) {
            targetFile = new File(targetDirectory, String.format("%s-%02d-geography.txt", corpusName, fileIndex));
            out = null;
            try {
                try {
                    out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), DEFAULT_CHARSET_NAME));
                    GEOFile.save(targetFile, source.getGeography2());
                }
                catch (UnsupportedEncodingException exception) {
                    throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + targetFile + "]", new Object[0]);
                }
                catch (FileNotFoundException exception) {
                    throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + targetFile + "]", new Object[0]);
                }
            }
            finally {
                IOUtils.closeQuietly((Writer)out);
            }
        }
    }
}

