/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.ProcessingTarget;
import org.gephi.preview.api.RenderTarget;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.tip.puck.graphs.Graph;
import org.tip.puck.visualization.GraphImporter;
import org.tip.puck.visualization.exporter.Exporter;
import org.tip.puck.visualization.style.Style;
import org.tip.puck.visualization.style.attributes.AttributeMap;
import org.tip.puckgui.views.visualization.VisualizationPanel;
import processing.core.PApplet;

public class VisualizationController {
    private final ProjectController projectController;
    private final List<Style> styles = new ArrayList<Style>();

    private VisualizationController() {
        this.projectController = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        this.projectController.newProject();
        Project currentProject = this.projectController.getCurrentProject();
    }

    public static VisualizationController getSharedInstance() {
        return VisualizationControllerHolder.INSTANCE;
    }

    protected Workspace createWorkspace() {
        Project currentProject = this.projectController.getCurrentProject();
        Workspace newWorkspace = this.projectController.newWorkspace(currentProject);
        return newWorkspace;
    }

    protected void deleteWorkspace(Workspace workspace) {
        this.projectController.deleteWorkspace(workspace);
    }

    private <D extends Style> D loadStyle(Class<D> styleClass) {
        D style = this.getStyle(styleClass);
        if (style != null) {
            return style;
        }
        boolean added = false;
        Style newInstance = null;
        try {
            newInstance = (Style)styleClass.newInstance();
            added = this.styles.add(newInstance);
        }
        catch (InstantiationException ex) {
            added = false;
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            added = false;
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.getStyle(styleClass);
    }

    protected <D extends Style> D getStyle(Class<D> styleClass) {
        for (Style style : this.styles) {
            if (!style.getClass().equals(styleClass)) continue;
            return (D)style;
        }
        return null;
    }

    public Exporter getExporter(Class<? extends Exporter> exporterClass) {
        Exporter exporter = null;
        try {
            exporter = exporterClass.newInstance();
        }
        catch (InstantiationException ex) {
            Logger.getLogger(VisualizationController.class.getName()).log(Level.SEVERE, null, ex);
            exporter = null;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(VisualizationController.class.getName()).log(Level.SEVERE, null, ex);
            exporter = null;
        }
        return exporter;
    }

    public <D extends Style> VisualizationPanel buildView(Graph<?> graph, Class<D> styleClass) {
        D style = this.loadStyle(styleClass);
        if (style == null) {
            System.out.println("style not loaded");
            return null;
        }
        Workspace newWorkspace = this.createWorkspace();
        this.projectController.openWorkspace(newWorkspace);
        AttributeMap styleMapping = style.styleMapping();
        GraphImporter importer = new GraphImporter(newWorkspace, style.graphStyle());
        try {
            importer.importGraph(graph, styleMapping);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        style.applyStyle(newWorkspace);
        PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        ProcessingTarget target = (ProcessingTarget)previewController.getRenderTarget("processing", newWorkspace);
        PApplet applet = target.getApplet();
        applet.init();
        previewController.render((RenderTarget)target);
        target.refresh();
        target.resetZoom();
        VisualizationPanel visualizationPanel = new VisualizationPanel(newWorkspace, (Component)applet);
        return visualizationPanel;
    }

    /* synthetic */ VisualizationController(VisualizationController visualizationController) {
        this();
    }

    private static class VisualizationControllerHolder {
        private static final VisualizationController INSTANCE = new VisualizationController(null);

        private VisualizationControllerHolder() {
        }
    }
}

