/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.tip.puck.partitions.Partition;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.Value;

public class NumberedValues
extends HashMap<Integer, Value>
implements Iterable<Value> {
    private static final long serialVersionUID = 7423770237304696469L;

    public NumberedValues() {
    }

    public NumberedValues(int initialCapacity) {
        super(initialCapacity);
    }

    public <E extends Numberable> NumberedValues(Partition<E> partition) {
        for (Numberable item : partition.getItems()) {
            this.put(item.getId(), partition.getValue(item));
        }
    }

    public void addValue(int number, Double value) {
        if (value == null) {
            this.put(number, null);
        } else {
            this.put(number, new Value(value));
        }
    }

    public void addValue(int number, Integer value) {
        if (value == null) {
            this.put(number, null);
        } else {
            this.put(number, new Value(value));
        }
    }

    public void addValue(int number, Object value) {
        if (value == null) {
            this.put(number, null);
        } else {
            this.put(number, new Value(value));
        }
    }

    public void addValue(int number, List<?> value) {
        if (value == null) {
            this.put(number, null);
        } else {
            this.put(number, new Value(value));
        }
    }

    public void addValue(int number, String value) {
        if (value == null) {
            this.put(number, null);
        } else {
            this.put(number, new Value(value));
        }
    }

    public double sum() {
        double result = 0.0;
        for (Value value : this) {
            if (value == null || !value.isNumber()) continue;
            result += value.doubleValue();
        }
        return result;
    }

    public double average() {
        double sum = 0.0;
        int count = 0;
        for (Value value : this) {
            if (value == null || !value.isNumber()) continue;
            sum += value.doubleValue();
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    public double averagePositives() {
        double sum = 0.0;
        int count = 0;
        for (Value value : this) {
            if (value == null || !value.isNumber() || !(value.doubleValue() > 0.0)) continue;
            sum += value.doubleValue();
            ++count;
        }
        double result = count == 0 ? 0.0 : sum * 1.0 / (double)count;
        return result;
    }

    @Override
    public Iterator<Value> iterator() {
        Iterator<Value> result = super.values().iterator();
        return result;
    }

    public double max() {
        Double maxValue = null;
        for (Value value : this) {
            if (value == null || !value.isNumber()) continue;
            if (maxValue == null) {
                maxValue = value.doubleValue();
                continue;
            }
            if (!(value.doubleValue() > maxValue)) continue;
            maxValue = value.doubleValue();
        }
        double result = maxValue == null ? 0.0 : maxValue;
        return result;
    }

    public double min() {
        Double minValue = null;
        for (Value value : this) {
            if (value == null || !value.isNumber()) continue;
            if (minValue == null) {
                minValue = value.doubleValue();
                continue;
            }
            if (!(value.doubleValue() < minValue)) continue;
            minValue = value.doubleValue();
        }
        double result = minValue == null ? 0.0 : minValue;
        return result;
    }

    public List<Value> toList() {
        ArrayList<Value> result = new ArrayList<Value>(this.values());
        return result;
    }

    public List<Value> toSortedList() {
        ArrayList<Value> result = new ArrayList<Value>();
        for (Value value : this) {
            if (value == null) continue;
            result.add(value);
        }
        Collections.sort(result);
        return result;
    }

    public int sizeNonNull() {
        int result = 0;
        for (Integer key : this.keySet()) {
            if (this.get(key) == null) continue;
            ++result;
        }
        return result;
    }

    public Value median() {
        Value result = null;
        int count = 0;
        int half = this.sizeNonNull() / 2;
        Iterator<Value> iterator = this.toSortedList().iterator();
        while (iterator.hasNext()) {
            Value value;
            result = value = iterator.next();
            if (count > half) break;
            ++count;
        }
        return result;
    }

    public String getValueAsString(String indicator) {
        String result = indicator.equals("SUM") ? String.valueOf(this.sum()) : (indicator.equals("AVERAGE") ? String.valueOf(this.average()) : (indicator.equals("MIN") ? String.valueOf(this.min()) : (indicator.equals("MAX") ? String.valueOf(this.min()) : (indicator.equals("MEDIAN") ? "" + this.median() : (indicator.equals("AVERAGE_POSITIVE") ? String.valueOf(this.averagePositives()) : null)))));
        return result;
    }
}

