/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Clusters;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;

public class Partition<E> {
    private static final Logger logger = LoggerFactory.getLogger(Partition.class);
    private String label;
    private PartitionCriteria criteria;
    private Clusters<E> clusters;
    private HashMap<E, Value> itemToValueShortcuts;
    private boolean pseudo;

    public boolean isPseudo() {
        return this.pseudo;
    }

    public void setPseudo(boolean pseudo) {
        this.pseudo = pseudo;
    }

    public int indexOf(Cluster<E> cluster) {
        int result = 0;
        for (Cluster<E> thisCluster : this.clusters) {
            if (thisCluster == cluster) break;
            ++result;
        }
        return result;
    }

    public Partition() {
        this.clusters = new Clusters();
        this.itemToValueShortcuts = new HashMap();
    }

    public Partition(String label) {
        this.label = label;
        this.clusters = new Clusters();
        this.itemToValueShortcuts = new HashMap();
    }

    public void add(Partition<E> partition) {
        for (Value value : partition.getValues()) {
            if (this.getCluster(value) == null) {
                this.putCluster(value);
            }
            for (E item : partition.getCluster(value).getItems()) {
                this.put(item, value);
            }
        }
    }

    public int clusteredItemsCount() {
        int result = 0;
        for (Cluster<E> cluster : this.getClusters()) {
            if (cluster.isNull()) continue;
            result += cluster.count();
        }
        return result;
    }

    public Map<Integer, Integer> clusterSizeDistribution() {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        for (Cluster<E> cluster : this.getClusters()) {
            if (cluster.getLabel() == null) continue;
            int size = cluster.size();
            Integer number = (Integer)result.get(size);
            if (number == null) {
                result.put(size, 1);
                continue;
            }
            result.put(size, number + 1);
        }
        return result;
    }

    public boolean containsValue(Value value) {
        boolean result = false;
        for (Cluster<E> cluster : this.getClusters()) {
            if (!cluster.getValue().equals(value)) continue;
            result = true;
        }
        return result;
    }

    public Cluster<E> getCluster(E item) {
        Cluster<E> result;
        if (this.itemToValueShortcuts.containsKey(item)) {
            Value value = this.getValue(item);
            result = this.getCluster(value);
        } else {
            result = null;
        }
        return result;
    }

    public Cluster<E> getCluster(Value value) {
        Cluster result = (Cluster)this.clusters.get(value);
        return result;
    }

    public Clusters<E> getClusters() {
        return this.clusters;
    }

    public PartitionCriteria getCriteria() {
        return this.criteria;
    }

    public String getCriteriaLabel() {
        String result = this.criteria == null ? null : this.criteria.getLabel();
        return result;
    }

    public Set<E> getItems() {
        Set<E> result = this.itemToValueShortcuts.keySet();
        return result;
    }

    public List<E> getItemsAsList() {
        ArrayList<E> result = new ArrayList<E>(this.itemToValueShortcuts.keySet());
        return result;
    }

    public List<E> getItemsAsSortedList(Comparator<E> comparator) {
        ArrayList<E> result = new ArrayList<E>(this.itemToValueShortcuts.keySet());
        Collections.sort(result, comparator);
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public Value getValue(E item) {
        Value result = this.itemToValueShortcuts.get(item);
        return result;
    }

    public int getValueFrequency(Value value) {
        Cluster cluster = (Cluster)this.clusters.get(value);
        int result = cluster == null ? 0 : cluster.size();
        return result;
    }

    public Value getValueNotNull(E item) {
        Value result = this.getValue(item);
        if (result == null) {
            result = new Value(0);
        }
        return result;
    }

    public Double valueSumByItems() {
        Double result;
        if (this.isNotNumeric()) {
            result = null;
        } else {
            result = 0.0;
            for (Cluster<E> cluster : this.clusters) {
                result = result + (double)cluster.size() * cluster.getValue().doubleValue();
            }
        }
        return result;
    }

    public Double valueMeanByItems() {
        Double result = this.isNotNumeric() ? null : Double.valueOf(this.valueSumByItems() / (double)this.itemsCount());
        return result;
    }

    public Double valueSumByClusters() {
        Double result;
        if (this.isNotNumeric()) {
            result = null;
        } else {
            result = 0.0;
            for (Cluster<E> cluster : this.clusters) {
                result = result + cluster.getValue().doubleValue();
            }
        }
        return result;
    }

    public Double valueMeanByClusters() {
        Double result = this.isNotNumeric() ? null : Double.valueOf(this.valueSumByClusters() / (double)this.size());
        return result;
    }

    public Collection<Value> getValues() {
        Collection<Value> result = this.getClusters().getValues();
        return result;
    }

    public List<Value> getValuesAsSortedList() {
        ArrayList<Value> result = new ArrayList<Value>(this.getValues());
        Collections.sort(result);
        return result;
    }

    public boolean isNotNumeric() {
        boolean result = !this.isNumeric();
        return result;
    }

    public boolean isNumeric() {
        boolean result = this.label.equals("ID") || this.label.equals("ORDER") ? false : this.clusters.isNumeric();
        return result;
    }

    public int itemsCount() {
        int result = this.getItems().size();
        return result;
    }

    public Cluster<E> maxCluster() {
        Cluster<E> result = null;
        for (Cluster<E> cluster : this.clusters) {
            if (result != null && cluster.size() <= result.size()) continue;
            result = cluster;
        }
        return result;
    }

    public int maxClusterSize() {
        Cluster<E> maxCluster = this.maxCluster();
        int result = maxCluster != null ? maxCluster.size() : 0;
        return result;
    }

    public List<Double> clusterSizes() {
        ArrayList<Double> result = new ArrayList<Double>();
        for (Cluster<E> cluster : this.clusters) {
            result.add(new Double(cluster.size()));
        }
        return result;
    }

    public double concentration() {
        double result = MathUtils.herfindahl(this.clusterSizes());
        return result;
    }

    public double maxShare() {
        return this.share(this.maxCluster());
    }

    public Value maxValue() {
        Value result = null;
        for (Value value : this.itemToValueShortcuts.values()) {
            if (value == null || value.compareTo(result) <= 0) continue;
            result = value;
        }
        return result;
    }

    public int nrSingletons() {
        int result = 0;
        for (Cluster<E> cluster : this.clusters) {
            if (cluster.size() != 1) continue;
            ++result;
        }
        return result;
    }

    public double singletonShare() {
        return MathUtils.percent(this.nrSingletons(), this.size());
    }

    public double meanShare() {
        return MathUtils.percent(1, this.size());
    }

    public double meanShare(int minSize) {
        double clustersCount = 0.0;
        for (Cluster<E> cluster : this.clusters) {
            if (cluster.size() < minSize) continue;
            clustersCount += 1.0;
        }
        double result = MathUtils.percent(1.0, clustersCount);
        return result;
    }

    public boolean put(E item, Value partitionValue) {
        Cluster<E> cluster = (Cluster<E>)this.clusters.get(partitionValue);
        if (cluster == null) {
            cluster = new Cluster<E>(partitionValue);
            this.clusters.put(cluster);
        }
        boolean result = cluster.put(item);
        this.itemToValueShortcuts.put(item, partitionValue);
        return result;
    }

    public void putAll(List<E> items, Value partitionValue) {
        if (items != null) {
            if (items.isEmpty()) {
                this.putCluster(partitionValue);
            } else {
                for (E item : items) {
                    this.put(item, partitionValue);
                }
            }
        }
    }

    public void putClusters() {
        this.putClusters(this.criteria.getValues());
    }

    public void putClusters(Values values) {
        if (values != null) {
            for (Value value : values) {
                this.putCluster(value);
            }
        }
    }

    public void putCluster(Value value) {
        Cluster cluster = new Cluster(value);
        this.clusters.put(cluster);
    }

    public Cluster<E> addCluster(Cluster<E> cluster) {
        Cluster<E> result = this.getCluster(cluster.getValue());
        if (result == null) {
            result = new Cluster(cluster.getValue());
            this.clusters.put(result);
        }
        for (E item : cluster.getItems()) {
            result.put(item);
        }
        return result;
    }

    public Cluster<E> removeCluster(Cluster<E> cluster) {
        Cluster result = (Cluster)this.clusters.remove(cluster.getValue());
        for (E item : cluster.getItems()) {
            this.itemToValueShortcuts.remove(item);
        }
        return result;
    }

    public Cluster<E> removeCluster(E item) {
        Cluster<Cluster<E>> result = this.removeCluster((E)this.getCluster(item));
        return result;
    }

    public void removeItem(E item) {
        this.getCluster(item).remove(item);
        this.itemToValueShortcuts.remove(item);
    }

    public void setCriteria(PartitionCriteria criteria) {
        this.criteria = criteria;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public double share(Cluster<E> cluster) {
        int itemsCount = this.itemsCount();
        double result = itemsCount == 0 ? 0.0 : MathUtils.percent(cluster.count(), itemsCount);
        return result;
    }

    public int size() {
        int result = this.clusters.size();
        return result;
    }

    public int nonNullClusterCount() {
        int result = 0;
        for (Cluster<E> cluster : this.clusters) {
            if (cluster.isNull()) continue;
            ++result;
        }
        return result;
    }

    public void swap(E item, Cluster<E> cluster1, Cluster<E> cluster2) {
        if (item != null && cluster1 != null && cluster1.getItems().contains(item)) {
            cluster1.remove(item);
            this.put(item, cluster2.getValue());
        }
    }

    public void swap(E item, Value value1, Value value2) {
        Cluster cluster = (Cluster)this.clusters.get(value2);
        if (item != null && cluster != null && cluster.getItems().contains(item)) {
            cluster.remove(item);
            this.put(item, value2);
        }
    }

    public void changeClusterValue(Cluster<E> cluster, Value value) {
        if (value != null && cluster != null) {
            Object[] objectArray = cluster.getItems().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                this.put(item, value);
                ++n2;
            }
            this.clusters.remove(cluster.getValue());
        }
    }

    public String toString() {
        String result = "";
        for (Cluster<E> cluster : this.clusters.toListSortedByValue()) {
            if (result.length() > 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + cluster.getValue() + " [" + cluster.getItemsAsString() + "]";
        }
        return result;
    }

    public boolean isMulti() {
        boolean result = false;
        for (Value value : this.getValues()) {
            if (value == null || !value.isPartition()) continue;
            result = true;
            break;
        }
        return result;
    }

    public <V extends Numberable> Partition<V> aggregate(PartitionCriteria criteria) throws PuckException {
        Partition result = new Partition();
        result.setLabel(this.label);
        for (Cluster<E> cluster : this.clusters) {
            Value value = cluster.getValue();
            if (value.isPartition()) {
                Partition partition = value.partitionValue();
                for (Cluster subCluster : partition.getClusters()) {
                    result.putAll(subCluster.getItems(), subCluster.getValue());
                }
                continue;
            }
            throw PuckExceptions.INVALID_PARAMETER.create(null, "value is not a partition: " + value, new Object[0]);
        }
        result = PartitionMaker.create(result, criteria);
        return result;
    }

    public String valueCode(ValueCode mode) {
        String result;
        if (mode == ValueCode.VALUES) {
            result = "";
            for (Cluster<E> cluster : this.getClusters().toListSortedByValue()) {
                result = String.valueOf(result) + cluster.getValue() + " ";
            }
        } else if (mode == ValueCode.ORDERED_VALUES) {
            result = "";
            for (Cluster<E> cluster : this.getClusters().toListSortedByDescendingSize()) {
                result = String.valueOf(result) + cluster.getValue() + " ";
            }
        } else {
            result = null;
        }
        return result;
    }

    public <V> Partition<E> revalue(ValueCode mode) throws PuckException {
        Partition<E> result = new Partition<E>();
        for (Cluster<E> cluster : this.clusters) {
            Value value = cluster.getValue();
            if (value.isPartition()) {
                Partition partition = value.partitionValue();
                result.putAll(cluster.getItems(), new Value(partition.valueCode(mode)));
                continue;
            }
            throw PuckExceptions.INVALID_PARAMETER.create(null, "value is not a partition: " + value, new Object[0]);
        }
        return result;
    }

    public static enum ValueCode {
        VALUES,
        ORDERED_VALUES;

    }
}

