/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringList;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.workers.AttributeDescriptor;
import org.tip.puck.net.workers.AttributeDescriptorComparator;

public class AttributeDescriptors
implements Iterable<AttributeDescriptor> {
    private ArrayList<AttributeDescriptor> attributeDescriptors;

    public AttributeDescriptors() {
        this.attributeDescriptors = new ArrayList();
    }

    public AttributeDescriptors(int initialCapacity) {
        this.attributeDescriptors = new ArrayList(initialCapacity);
    }

    public void add(AttributeDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException("source is null.");
        }
        this.attributeDescriptors.add(source);
    }

    public void addAll(AttributeDescriptors source) {
        if (source != null) {
            for (AttributeDescriptor descriptor : source) {
                this.attributeDescriptors.add(descriptor);
            }
        }
    }

    public void addAll(Collection<AttributeDescriptor> source) {
        if (source != null) {
            for (AttributeDescriptor descriptor : source) {
                this.attributeDescriptors.add(descriptor);
            }
        }
    }

    public void clear() {
        this.attributeDescriptors.clear();
    }

    public AttributeDescriptors copy() {
        AttributeDescriptors result = new AttributeDescriptors(this.attributeDescriptors.size());
        for (AttributeDescriptor comment : this.attributeDescriptors) {
            result.add(comment);
        }
        return result;
    }

    public AttributeDescriptors findByRelationModelName(String relationName) {
        AttributeDescriptors result = new AttributeDescriptors();
        if (StringUtils.isNotBlank((CharSequence)relationName)) {
            for (AttributeDescriptor descriptor : this.attributeDescriptors) {
                if (descriptor.getScope() != AttributeDescriptor.Scope.RELATION || !StringUtils.equals((CharSequence)descriptor.getOptionalRelationName(), (CharSequence)relationName)) continue;
                result.add(descriptor);
            }
        }
        return result;
    }

    public AttributeDescriptors findByScope(AttributeDescriptor.Scope scope) {
        AttributeDescriptors result = new AttributeDescriptors();
        for (AttributeDescriptor descriptor : this.attributeDescriptors) {
            if (descriptor.getScope() != scope) continue;
            result.add(descriptor);
        }
        return result;
    }

    public AttributeDescriptors first(int targetCount) {
        AttributeDescriptors result = new AttributeDescriptors(targetCount);
        boolean ended = false;
        Iterator<AttributeDescriptor> iterator = this.iterator();
        int count = 0;
        while (!ended) {
            if (count > targetCount || !iterator.hasNext()) {
                ended = true;
                continue;
            }
            result.add(iterator.next());
            ++count;
        }
        return result;
    }

    public AttributeDescriptor getByIndex(int index) {
        AttributeDescriptor result = this.attributeDescriptors.get(index);
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.attributeDescriptors.isEmpty();
        return result;
    }

    public boolean isNotEmpty() {
        boolean result = !this.isEmpty();
        return result;
    }

    @Override
    public Iterator<AttributeDescriptor> iterator() {
        Iterator<AttributeDescriptor> result = this.attributeDescriptors.iterator();
        return result;
    }

    public StringList labels() {
        HashSet<String> labels = new HashSet<String>();
        for (AttributeDescriptor descriptor : this.attributeDescriptors) {
            labels.add(descriptor.getLabel());
        }
        StringList result = new StringList(labels.size());
        for (String label : labels) {
            result.add((Object)label);
        }
        return result;
    }

    public StringList labelsSorted() {
        StringList result = this.labels();
        Collections.sort(result, Collator.getInstance());
        return result;
    }

    public AttributeDescriptor last() {
        AttributeDescriptor result = this.attributeDescriptors.isEmpty() ? null : this.attributeDescriptors.get(this.attributeDescriptors.size() - 1);
        return result;
    }

    public List<String> relationModelNames() {
        HashSet<String> names = new HashSet<String>();
        for (AttributeDescriptor descriptor : this.attributeDescriptors) {
            if (descriptor.getScope() != AttributeDescriptor.Scope.RELATION) continue;
            names.add(descriptor.getOptionalRelationName());
        }
        ArrayList<String> result = new ArrayList<String>(names.size());
        for (String name : names) {
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public synchronized void remove(AttributeDescriptor descriptor) {
        this.attributeDescriptors.remove(descriptor);
    }

    public AttributeDescriptors reverse() {
        Collections.reverse(this.attributeDescriptors);
        AttributeDescriptors result = this;
        return result;
    }

    public int size() {
        int result = this.attributeDescriptors.size();
        return result;
    }

    public AttributeDescriptors sort() {
        Collections.sort(this.attributeDescriptors, new AttributeDescriptorComparator(AttributeDescriptorComparator.Sorting.DEFAULT));
        AttributeDescriptors result = this;
        return result;
    }

    public long total() {
        long result = 0L;
        for (AttributeDescriptor descriptor : this.attributeDescriptors) {
            result += descriptor.getCountOfSet();
        }
        return result;
    }
}

