/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.kinoath.IndividualGroup;
import org.tip.puck.kinoath.IndividualGroups;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;

public class ComponentWorker {
    private static final Logger logger = LoggerFactory.getLogger(ComponentWorker.class);

    public static IndividualGroup searchComponent(Individual source) {
        IndividualGroup result = new IndividualGroup("Component");
        ArrayList<Individual> booked = new ArrayList<Individual>();
        booked.add(source);
        while (!booked.isEmpty()) {
            Individual current = (Individual)booked.remove(booked.size() - 1);
            if (result.contains(current)) continue;
            result.add(current);
            for (Individual parent : current.getParents()) {
                if (result.contains(parent)) continue;
                booked.add(parent);
            }
            for (Individual partner : current.getPartners()) {
                if (result.contains(partner)) continue;
                booked.add(partner);
            }
            for (Individual child : current.children()) {
                if (result.contains(child)) continue;
                booked.add(child);
            }
            for (Relation relation : current.relations()) {
                for (Individual relationship : relation.getIndividuals()) {
                    if (result.contains(relationship)) continue;
                    booked.add(relationship);
                }
            }
        }
        return result;
    }

    public static IndividualGroups searchComponents(Individuals source) {
        IndividualGroups result = new IndividualGroups();
        if (source != null) {
            Individuals booked = new Individuals(source.size());
            for (Individual current : source) {
                if (booked.contains(current)) continue;
                IndividualGroup component = ComponentWorker.searchComponent(current);
                for (Individual individual : component) {
                    booked.add(individual);
                }
                component.setId(result.size() + 1);
                result.add(component);
            }
        }
        return result;
    }

    public static IndividualGroup searchKinComponent(Individual source) {
        IndividualGroup result = new IndividualGroup("Component");
        ArrayList<Individual> booked = new ArrayList<Individual>();
        booked.add(source);
        while (!booked.isEmpty()) {
            Individual current = (Individual)booked.remove(booked.size() - 1);
            if (result.contains(current)) continue;
            result.add(current);
            for (Individual parent : current.getParents()) {
                if (result.contains(parent)) continue;
                booked.add(parent);
            }
            for (Individual partner : current.getPartners()) {
                if (result.contains(partner)) continue;
                booked.add(partner);
            }
            for (Individual child : current.children()) {
                if (result.contains(child)) continue;
                booked.add(child);
            }
        }
        return result;
    }

    public static IndividualGroups searchKinComponents(Individuals source) {
        IndividualGroups result = new IndividualGroups();
        if (source != null) {
            Individuals booked = new Individuals(source.size());
            for (Individual current : source) {
                if (booked.contains(current)) continue;
                IndividualGroup component = ComponentWorker.searchKinComponent(current);
                for (Individual individual : component) {
                    booked.add(individual);
                }
                component.setId(result.size() + 1);
                result.add(component);
            }
        }
        return result;
    }
}

