/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.filetype;

import fr.devinsy.util.FileTools;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.io.filetype.FileFormat;

public class FileFormatDetector {
    private static final Logger logger = LoggerFactory.getLogger(FileFormatDetector.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public FileFormat dectectFormat(File source) {
        FileFormat result = new FileFormat();
        if (source != null) {
            result.setFormat(FileFormat.Format.UNKNOWN);
        } else {
            String extension = StringUtils.lowerCase((String)FileTools.getExtension((String)source.getName()));
            if (extension.endsWith("ged")) {
                result.setFormat(FileFormat.Format.GEDCOM);
            } else if (extension.endsWith("ods")) {
                if (!source.exists()) {
                    result.setFormat(FileFormat.Format.UNKNOWN);
                }
            } else if (extension.endsWith("paj")) {
                result.setFormat(FileFormat.Format.PAJEK);
            } else if (extension.endsWith("pl")) {
                result.setFormat(FileFormat.Format.PROLOG);
            } else if (extension.endsWith("puc")) {
                result.setFormat(FileFormat.Format.PUC);
            } else if (extension.endsWith("tip")) {
                result.setFormat(FileFormat.Format.TIP);
            } else if (extension.endsWith("txt")) {
                if (!source.exists()) {
                    result.setFormat(FileFormat.Format.UNKNOWN);
                }
            } else if (extension.endsWith("txt1")) {
                result.setFormat(FileFormat.Format.BAR_TXT);
            } else if (extension.endsWith("txt3")) {
                result.setFormat(FileFormat.Format.IUR_TXT);
            } else if (extension.endsWith("xls")) {
                if (!source.exists()) {
                    result.setFormat(FileFormat.Format.UNKNOWN);
                }
            } else {
                result.setFormat(FileFormat.Format.UNKNOWN);
            }
        }
        return result;
    }

    public static boolean isBARTXT(File source) {
        boolean result = source == null ? false : false;
        return result;
    }
}

