/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.generators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.tip.puck.generators.PGraphLink;
import org.tip.puck.generators.PGraphNode;
import org.tip.puck.generators.SiblingMarriageDistribution;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.util.RandomGenerator;

public class PGraph {
    private Map<String, PGraphNode> nodes;
    private Map<Individual, Set<PGraphNode>> marriagesByIndividual;
    private Vector<PGraphLink> linksVector;
    private int totalLinks;
    private SiblingMarriageDistribution smDistrib;

    private int getProbableNumberOfSpouses(Gender gender, int k) {
        if (gender == Gender.UNKNOWN) {
            return 0;
        }
        return this.smDistrib.howManySpouses(gender, k);
    }

    public Net toNet2() {
        Net result = new Net();
        HashMap brotherhood = new HashMap();
        HashMap sisterhood = new HashMap();
        for (PGraphLink link : this.linksVector) {
            if (link.isWifeLink()) {
                if (!sisterhood.containsKey(link.getOrigin())) {
                    sisterhood.put(link.getOrigin(), new HashSet());
                }
                ((Set)sisterhood.get(link.getOrigin())).add(link.getTarget());
                continue;
            }
            if (!brotherhood.containsKey(link.getOrigin())) {
                brotherhood.put(link.getOrigin(), new HashSet());
            }
            ((Set)brotherhood.get(link.getOrigin())).add(link.getTarget());
        }
        return result;
    }

    public Net toNet() {
        Individual wife;
        Individual husband;
        HashMap<PGraphNode, Family> index = new HashMap<PGraphNode, Family>();
        Net result = new Net();
        int id = 1;
        for (PGraphNode node : this.nodes.values()) {
            husband = null;
            wife = null;
            Family family = null;
            if (node.getHusband() != null) {
                husband = node.getHusband().clone();
                node.setHusband(husband);
                result.individuals().add(husband);
                ++id;
            }
            if (node.getWife() != null) {
                wife = node.getWife().clone();
                node.setWife(wife);
                result.individuals().add(wife);
                ++id;
            }
            if (node.getFamily() == null) continue;
            family = new Family(node.getFamily().getId(), husband, wife);
            if (husband != null) {
                husband.addPersonalFamily(family);
            }
            if (wife != null) {
                wife.addPersonalFamily(family);
            }
            if (node.getFamily().hasMarried()) {
                family.setMarried(true);
            }
            result.families().add(family);
            index.put(node, family);
        }
        for (PGraphNode node : this.nodes.values()) {
            husband = node.getHusband();
            wife = node.getWife();
            Family husbandsParents = (Family)index.get(node.getHusbandLink());
            Family wifesParents = (Family)index.get(node.getWifeLink());
            if (husband != null && husbandsParents != null) {
                husband.setOriginFamily(husbandsParents);
                husbandsParents.getChildren().add(husband);
            }
            if (wife == null || wifesParents == null) continue;
            wife.setOriginFamily(wifesParents);
            wifesParents.getChildren().add(wife);
        }
        for (Individual individual : result.individuals()) {
            int additionalSpouses = this.getProbableNumberOfSpouses(individual.getGender(), PGraph.monogamousSameSexSiblings(individual).size());
            while (additionalSpouses > 1 && additionalSpouses > PGraph.monogamousSameSexSiblings(individual).size()) {
                Individual sibling = PGraph.randomDraw(PGraph.monogamousSameSexSiblings(individual));
                Family additionalFamily = (Family)sibling.getPersonalFamilies().toList().get(0);
                if (individual.isMale()) {
                    additionalFamily.setHusband(individual);
                } else if (individual.isFemale()) {
                    additionalFamily.setWife(individual);
                }
                individual.addPersonalFamily(additionalFamily);
                result.individuals().removeById(sibling.getId());
            }
        }
        return result;
    }

    private static Individual randomDraw(Individuals individuals) {
        int randomIndex = (int)(Math.random() * (double)individuals.size());
        return (Individual)individuals.toList().get(randomIndex);
    }

    public static Individuals monogamousSameSexSiblings(Individual individual) {
        Individuals result = new Individuals();
        Family family = individual.getOriginFamily();
        if (family != null) {
            for (Individual sibling : family.getChildren()) {
                if (sibling == individual || sibling.getGender() != individual.getGender() || sibling.spouses().size() != 1) continue;
                result.add(sibling);
            }
        }
        return result;
    }

    private PGraphNode getPGraphNode(Family family) {
        return this.nodes.get(new PGraphNode(family).hashKey());
    }

    public PGraph(Net net) {
        PGraphNode node;
        this.smDistrib = new SiblingMarriageDistribution(net);
        this.totalLinks = 0;
        this.nodes = new HashMap<String, PGraphNode>();
        for (Family family : net.families()) {
            node = new PGraphNode(family);
            this.nodes.put(node.hashKey(), node);
        }
        for (Individual individual : net.individuals()) {
            if (individual.getPersonalFamilies().size() != 0) continue;
            node = new PGraphNode(individual);
            this.nodes.put(node.hashKey(), node);
        }
        for (PGraphNode pGraphNode : this.nodes.values()) {
            Individual husband = pGraphNode.getHusband();
            Individual wife = pGraphNode.getWife();
            if (husband != null && husband.getOriginFamily() != null) {
                PGraphNode husbandsParents = this.getPGraphNode(husband.getOriginFamily());
                pGraphNode.setHusbandLink(husbandsParents);
                ++this.totalLinks;
            }
            if (wife == null || wife.getOriginFamily() == null) continue;
            PGraphNode wifesParents = this.getPGraphNode(wife.getOriginFamily());
            pGraphNode.setWifeLink(wifesParents);
            ++this.totalLinks;
        }
        this.linksVector = new Vector();
        for (Map.Entry entry : this.nodes.entrySet()) {
            PGraphLink link;
            PGraphNode marriage = (PGraphNode)entry.getValue();
            PGraphNode wifeLink = marriage.getWifeLink();
            PGraphNode husbandLink = marriage.getHusbandLink();
            if (wifeLink != null) {
                link = new PGraphLink(wifeLink, marriage, true);
                this.linksVector.add(link);
            }
            if (husbandLink == null) continue;
            link = new PGraphLink(husbandLink, marriage, false);
            this.linksVector.add(link);
        }
        this.computeOutDegrees();
        this.computeAncestors();
    }

    public PGraph(PGraph pg) {
        this.smDistrib = pg.smDistrib;
        this.totalLinks = pg.totalLinks;
        this.nodes = new HashMap<String, PGraphNode>();
        for (Map.Entry<String, PGraphNode> entry : pg.nodes.entrySet()) {
            String key = entry.getKey();
            PGraphNode node = new PGraphNode(entry.getValue());
            this.nodes.put(key, node);
        }
        this.linksVector = new Vector();
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            PGraphLink link;
            PGraphNode marriage = entry.getValue();
            PGraphNode wifeLink = marriage.getWifeLink();
            PGraphNode husbandLink = marriage.getHusbandLink();
            if (wifeLink != null) {
                link = new PGraphLink(wifeLink, marriage, true);
                this.linksVector.add(link);
            }
            if (husbandLink == null) continue;
            link = new PGraphLink(husbandLink, marriage, false);
            this.linksVector.add(link);
        }
        this.computeOutDegrees();
        this.computeAncestors();
    }

    private boolean addLink(PGraphLink link, int maxGenDist) {
        PGraphNode targ;
        PGraphNode orig = link.getOrigin();
        if (orig == (targ = link.getTarget())) {
            return false;
        }
        if (targ.hasDescendant(orig)) {
            return false;
        }
        int dist = orig.originalGenerationalDistance(targ);
        if (dist < 0 || dist > maxGenDist) {
            return false;
        }
        if (link.isWifeLink()) {
            link.getTarget().setWifeLink(link.getOrigin());
        } else {
            link.getTarget().setHusbandLink(link.getOrigin());
        }
        this.clearAncestors();
        this.computeAncestors();
        return true;
    }

    public float averageNumberOfDescendants() {
        float avg = 0.0f;
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            PGraphNode marriage = entry.getValue();
            avg += (float)marriage.numberOfDescendants();
        }
        return avg /= (float)this.numberOfMarriages();
    }

    public float maxNumberOfDescendants() {
        float max = 0.0f;
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            PGraphNode marriage = entry.getValue();
            float descs = marriage.numberOfDescendants();
            if (!(descs > max)) continue;
            max = descs;
        }
        return max;
    }

    private void clearAncestors() {
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            PGraphNode marriage = entry.getValue();
            marriage.clearDescendants();
        }
    }

    private void computeAncestors() {
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            PGraphNode marriage = entry.getValue();
            marriage.addDescendant(marriage, 0);
        }
    }

    private void computeOutDegrees() {
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            PGraphNode marriage = entry.getValue();
            PGraphNode wifeLink = marriage.getWifeLink();
            PGraphNode husbandLink = marriage.getHusbandLink();
            if (wifeLink != null) {
                wifeLink.incOutDegree();
                wifeLink.incOutDegreeF();
            }
            if (husbandLink == null) continue;
            husbandLink.incOutDegree();
            husbandLink.incOutDegreeM();
        }
    }

    public Map<String, PGraphNode> getMarriages() {
        return this.nodes;
    }

    public Map<Individual, Set<PGraphNode>> getMarriagesByIndividual() {
        return this.marriagesByIndividual;
    }

    public int getTotalLinks() {
        return this.totalLinks;
    }

    public int numberOfMarriages() {
        return this.nodes.size();
    }

    private void removeLink(PGraphLink link) {
        if (link.isWifeLink()) {
            link.getTarget().setWifeLink(null);
        } else {
            link.getTarget().setWifeLink(null);
        }
    }

    public void storeOriginalDescendants() {
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            PGraphNode marriage = entry.getValue();
            marriage.storeOriginalDescendants();
        }
    }

    public boolean switchLinks(int k, int maxGenDist) {
        HashSet<PGraphLink> linkSet = new HashSet<PGraphLink>();
        PGraphLink link = this.linksVector.get(RandomGenerator.instance().random.nextInt(this.linksVector.size()));
        linkSet.add(link);
        boolean gender = link.isWifeLink();
        while (linkSet.size() < k) {
            link = this.linksVector.get(RandomGenerator.instance().random.nextInt(this.linksVector.size()));
            if (link.isWifeLink() != gender) continue;
            linkSet.add(link);
        }
        ArrayList links = new ArrayList(linkSet);
        ArrayList links2 = new ArrayList(links);
        boolean perfectShuffle = false;
        while (!perfectShuffle) {
            perfectShuffle = true;
            int i = 0;
            while (i < k) {
                if (links.get(i) == links2.get(i)) {
                    perfectShuffle = false;
                }
                ++i;
            }
            Collections.shuffle(links2);
        }
        ArrayList<Object> newLinks = new ArrayList<Object>();
        int i = 0;
        while (i < k) {
            Object newLink = new PGraphLink(((PGraphLink)links.get(i)).getOrigin(), ((PGraphLink)links2.get(i)).getTarget(), ((PGraphLink)links.get(i)).isWifeLink());
            newLinks.add(newLink);
            ++i;
        }
        for (PGraphLink oldLink : links) {
            this.removeLink(oldLink);
        }
        this.clearAncestors();
        this.computeAncestors();
        boolean fail = false;
        for (Object newLink : newLinks) {
            if (this.addLink((PGraphLink)newLink, maxGenDist)) continue;
            fail = true;
            break;
        }
        if (fail) {
            for (Object newLink : newLinks) {
                this.removeLink((PGraphLink)newLink);
            }
            for (PGraphLink oldLink : links) {
                this.addLink(oldLink, maxGenDist);
            }
        } else {
            int i2 = 0;
            while (i2 < k) {
                ((PGraphLink)links.get(i2)).setTarget(((PGraphLink)links2.get(i2)).getTarget());
                ((PGraphLink)links.get(i2)).setShuffled(true);
                ++i2;
            }
        }
        return !fail;
    }

    public double distance(PGraph pg) {
        double dist = 0.0;
        double count = 0.0;
        for (Map.Entry<String, PGraphNode> entry : this.nodes.entrySet()) {
            String key = entry.getKey();
            PGraphNode m1 = entry.getValue();
            PGraphNode m2 = pg.getMarriages().get(key);
            dist += m1.distance(m2);
            count += 1.0;
        }
        return dist / count;
    }

    public double percentageShuffledLinks() {
        double shuffled = 0.0;
        double total = 0.0;
        for (PGraphLink link : this.linksVector) {
            if (link.isShuffled()) {
                shuffled += 1.0;
            }
            total += 1.0;
        }
        return shuffled / total * 100.0;
    }

    public String toString() {
        String str = "Number of marriages: " + this.numberOfMarriages() + "\n";
        str = String.valueOf(str) + "Number of links: " + this.getTotalLinks() + "\n";
        str = String.valueOf(str) + "Average number of descendants: " + this.averageNumberOfDescendants() + "\n";
        str = String.valueOf(str) + "Max number of descendants: " + this.maxNumberOfDescendants() + "\n";
        return str;
    }
}

