/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.bar.BARODSFile;
import org.tip.puck.io.bar.BARTXTFile;
import org.tip.puck.io.bar.BARXLSFile;
import org.tip.puck.io.ged.GEDFile;
import org.tip.puck.io.iur.IURODSFile;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.io.iur.IURXLSFile;
import org.tip.puck.io.ods.ODSFile;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.io.permutation.PermutationFile;
import org.tip.puck.io.permutation.PermutationTable;
import org.tip.puck.io.pl.PLFile;
import org.tip.puck.io.puc.PUCFile;
import org.tip.puck.io.tip.TIPFile;
import org.tip.puck.io.txt.TXTFile;
import org.tip.puck.io.xls.XLSFile;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.roles.RoleRelationRules;
import org.tip.puck.net.relations.roles.RoleRelationsTXTFile;
import org.tip.puck.net.relations.roles.RoleRelationsXLSFile;
import org.tip.puck.net.relations.roles.RoleRelationsXMLFile;
import org.tip.puck.net.relations.roles.io.EMICFile;
import org.tip.puck.net.relations.roles.io.ETICFile;
import org.tip.puck.net.relations.roles.io.TermGenealogyFile;
import org.tip.puck.net.relations.roles.io.TermStandardFile;
import org.tip.puck.net.workers.UpdateWorker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportTXTFile;
import org.tip.puck.report.ReportXLSFile;

public class PuckManager {
    private static final Logger logger = LoggerFactory.getLogger(PuckManager.class);
    public static String DEFAULT_CHARSET_NAME = "UTF-8";

    public static Net fuseNet(Net target, File sourceFile, File concordanceFile, Report errorReport) throws PuckException {
        if (target == null || sourceFile == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        Net source = PuckManager.loadNet(sourceFile);
        PermutationTable permutations = PermutationFile.load(concordanceFile);
        Net result = UpdateWorker.fuse(target, source, permutations, errorReport);
        return result;
    }

    public static Net loadNet(File file) throws PuckException {
        Net result = PuckManager.loadNet(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net loadNet(File file, String charsetName) throws PuckException {
        Net result;
        if (file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
        }
        if (!file.exists()) {
            throw PuckExceptions.FILE_NOT_FOUND.create("File=[" + file + "].", new Object[0]);
        }
        if (!file.isFile()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
        }
        String fileNameLowerCase = StringUtils.lowerCase((String)file.getName());
        if (fileNameLowerCase == null) {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
        if (fileNameLowerCase.endsWith(".ged")) {
            result = GEDFile.load(file, charsetName);
        } else if (fileNameLowerCase.endsWith(".iur.txt")) {
            result = IURTXTFile.load(file);
        } else if (fileNameLowerCase.endsWith(".iur.ods")) {
            result = IURODSFile.load(file);
        } else if (fileNameLowerCase.endsWith(".iur.xls")) {
            result = IURXLSFile.load(file);
        } else if (fileNameLowerCase.endsWith(".bar.txt")) {
            result = BARTXTFile.load(file);
        } else if (fileNameLowerCase.endsWith(".bar.ods")) {
            result = BARODSFile.load(file);
        } else if (fileNameLowerCase.endsWith(".bar.xls")) {
            result = BARXLSFile.load(file);
        } else if (fileNameLowerCase.endsWith(".ods")) {
            result = ODSFile.load(file);
        } else if (fileNameLowerCase.endsWith(".paj")) {
            result = PAJFile.load(file, charsetName);
        } else if (fileNameLowerCase.endsWith(".pl")) {
            result = PLFile.load(file, charsetName);
        } else if (fileNameLowerCase.endsWith(".puc")) {
            result = PUCFile.load(file);
        } else if (fileNameLowerCase.endsWith(".tip")) {
            result = TIPFile.load(file, charsetName);
        } else if (fileNameLowerCase.endsWith(".txt")) {
            result = TXTFile.load(file);
        } else if (fileNameLowerCase.endsWith(".txt3")) {
            result = IURTXTFile.load(file);
        } else if (fileNameLowerCase.endsWith(".xls")) {
            result = XLSFile.load(file);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
        return result;
    }

    public static RelationModel loadRelationModel(File file) throws PuckException {
        RelationModel result = PuckManager.loadRelationModel(file, new Report("/dev/null"), null);
        return result;
    }

    public static RelationModel loadRelationModel(File file, Report report, RoleRelationRules ruleConstraints) throws PuckException {
        RelationModel result;
        if (file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
        }
        if (!file.exists()) {
            throw PuckExceptions.FILE_NOT_FOUND.create("File=[" + file + "].", new Object[0]);
        }
        if (!file.isFile()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
        }
        String name = StringUtils.lowerCase((String)file.getName());
        if (name == null) {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
        if (name.matches("^.+\\.term\\.(ods|txt|xls)$")) {
            result = TermStandardFile.load(file, report, ruleConstraints);
            logger.debug("report [status={}][isEmpty={}]", (Object)report.status(), (Object)report.outputs().isEmpty());
            logger.debug("report output={}", (Object)report.outputs());
        } else if (name.matches("^.+\\.term\\.(puc|iur\\.ods|iur\\.txt|iur\\.xls)$")) {
            result = TermGenealogyFile.load(file, report);
            logger.debug("report [status={}][isEmpty={}]", (Object)report.status(), (Object)report.outputs().isEmpty());
            logger.debug("report output={}", (Object)report.outputs());
        } else if (name.matches("^.+\\.etic\\.(ods|txt|xls)$")) {
            result = ETICFile.load(file, report, ruleConstraints);
            logger.debug("report [status={}][isEmpty={}]", (Object)report.status(), (Object)report.outputs().isEmpty());
            logger.debug("report output={}", (Object)report.outputs());
        } else if (name.matches("^.+\\.emic\\.(ods|txt|xls)$")) {
            result = EMICFile.load(file, report, ruleConstraints);
            logger.debug("report [status={}][isEmpty={}]", (Object)report.status(), (Object)report.outputs().isEmpty());
            logger.debug("report output={}", (Object)report.outputs());
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
        return result;
    }

    public static Net newEmptyNet() {
        Net result = null;
        return result;
    }

    public static Net newRandomNet() {
        Net result = null;
        return result;
    }

    public static void saveNet(File targetFile, Net net) throws PuckException {
        block37: {
            try {
                boolean succeed;
                if (targetFile == null) {
                    throw PuckExceptions.INVALID_PARAMETER.create("File=[" + targetFile + "].", new Object[0]);
                }
                if (targetFile.isDirectory()) {
                    throw PuckExceptions.NOT_A_FILE.create("File=[" + targetFile + "].", new Object[0]);
                }
                File temporaryFile = new File(String.valueOf(targetFile.getAbsolutePath()) + "-tmp");
                temporaryFile.delete();
                String fileNameLowerCase = StringUtils.lowerCase((String)targetFile.getName());
                if (fileNameLowerCase == null) {
                    throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + targetFile + "].", new Object[0]);
                }
                if (fileNameLowerCase.endsWith(".ged")) {
                    GEDFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".iur.ods")) {
                    IURODSFile.save(temporaryFile, net);
                    temporaryFile = new File(String.valueOf(temporaryFile.getAbsolutePath()) + ".ods");
                } else if (fileNameLowerCase.endsWith(".iur.txt")) {
                    IURTXTFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".iur.xls")) {
                    IURXLSFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".bar.ods")) {
                    BARODSFile.save(temporaryFile, net);
                    temporaryFile = new File(String.valueOf(temporaryFile.getAbsolutePath()) + ".ods");
                } else if (fileNameLowerCase.endsWith(".bar.txt")) {
                    BARTXTFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".bar.xls")) {
                    IURXLSFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".ods")) {
                    IURODSFile.save(temporaryFile, net);
                    temporaryFile = new File(String.valueOf(temporaryFile.getAbsolutePath()) + ".ods");
                } else if (fileNameLowerCase.endsWith(".pl")) {
                    PLFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".puc")) {
                    PUCFile.save(temporaryFile, net, "PUCK");
                } else if (fileNameLowerCase.endsWith(".tip")) {
                    TIPFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".txt")) {
                    IURTXTFile.save(temporaryFile, net);
                } else if (fileNameLowerCase.endsWith(".xls")) {
                    IURXLSFile.save(temporaryFile, net);
                } else {
                    throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + targetFile + "].", new Object[0]);
                }
                File backupFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".bak");
                if (targetFile.exists()) {
                    backupFile.delete();
                    succeed = targetFile.renameTo(backupFile);
                    if (!succeed) {
                        logger.warn("Backup failed for [" + targetFile + "][" + backupFile + "]");
                    }
                }
                if (succeed = temporaryFile.renameTo(targetFile)) break block37;
                logger.error("Error renaming temporary file from [" + temporaryFile + "] to [" + targetFile + "]: ");
                logger.error("First, retry after delay.");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                succeed = temporaryFile.renameTo(targetFile);
                logger.error("Rename retry result=" + succeed);
                if (!succeed) {
                    logger.error("Second, try to restore bak file.");
                    boolean succeedRestore = backupFile.renameTo(targetFile);
                    logger.error("Bak file restore result=" + succeedRestore);
                    logger.error("Last, throwing.");
                    if (succeedRestore) {
                        throw PuckExceptions.IO_ERROR.create("Can't rename temporary file=[" + temporaryFile + "].", new Object[0]);
                    }
                    throw PuckExceptions.IO_ERROR.create("Several rename file failed. Please retry later.\nYour origninal file has now the following name=[" + backupFile + "].", new Object[0]);
                }
            }
            catch (SecurityException exception) {
                exception.printStackTrace();
                logger.error("Permissions denied: " + exception.getMessage());
                throw PuckExceptions.IO_ERROR.create("Permission denied: " + exception.getMessage(), exception);
            }
        }
    }

    public static Report saveRelationModel(File file, RelationModel model) throws PuckException, IOException {
        Report result;
        if (file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
        }
        if (file.isDirectory()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
        }
        if (file.getName().toLowerCase().endsWith(".txt")) {
            result = RoleRelationsTXTFile.save(file, model);
        } else if (file.getName().toLowerCase().endsWith(".xls")) {
            result = RoleRelationsXLSFile.save(file, model);
        } else if (file.getName().toLowerCase().endsWith(".xml")) {
            result = RoleRelationsXMLFile.save(file, model);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
        return result;
    }

    public static void saveReport(File file, Report net) throws PuckException {
        if (file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
        }
        if (file.isDirectory()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
        }
        if (file.getName().toLowerCase().endsWith(".txt")) {
            ReportTXTFile.save(file, net);
        } else if (file.getName().toLowerCase().endsWith(".xls")) {
            ReportXLSFile.save(file, net);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
    }

    public static Net updateNetAppending(Net target, File file, Report errorReport) throws PuckException {
        if (target == null || file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        Net source = PuckManager.loadNet(file);
        Net result = UpdateWorker.update(target, source, errorReport, UpdateWorker.UpdateMode.APPEND);
        return result;
    }

    public static Net updateNetOverwriting(Net target, File file, Report errorReport) throws PuckException {
        if (target == null || file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        Net source = PuckManager.loadNet(file);
        Net result = UpdateWorker.update(target, source, errorReport, UpdateWorker.UpdateMode.OVERWRITE);
        return result;
    }
}

