/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.csv.CSVFile;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.geo.Geocode;

public class ConfigGeocodingDialog
extends JDialog {
    private static final long serialVersionUID = -7468130858005234778L;
    private static final Logger logger = LoggerFactory.getLogger(CSVFile.class);
    private GroupNetGUI parentGui = null;
    private NetGUI netGUI = null;
    private Graph<?> graph = null;
    private File csvFile = null;
    private static final int GEONAMES_CSV = 0;
    private static final int PERSONNAL_CSV = 1;
    private static final int GEONAMES_WEB = 2;
    private static final int INTEGRATED = 3;
    private int geoSourceChooser = 2;
    private final JPanel contentPanel = new JPanel();
    private JTextField textGeonamesFile;
    private JTextField txtCsv;
    JButton btnOpenGeonamesFile;
    JButton btnOpenPersonnalSources;

    public ConfigGeocodingDialog(NetGUI gui, Graph<?> graph) {
        this.graph = graph;
        this.netGUI = gui;
        this.initialize();
    }

    public ConfigGeocodingDialog(GroupNetGUI gui) {
        this.parentGui = gui;
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Configure Geocoding");
        this.setBounds(100, 100, 450, 258);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JLabel lblGeocodingSources = new JLabel("Geocoding sources :");
        lblGeocodingSources.setBounds(12, 12, 151, 15);
        this.contentPanel.add(lblGeocodingSources);
        JCheckBox chckbxGeonames = new JCheckBox("Geonames");
        chckbxGeonames.setSelected(true);
        chckbxGeonames.setToolTipText("Web connection is needed");
        chckbxGeonames.setBounds(33, 35, 129, 23);
        this.contentPanel.add(chckbxGeonames);
        JCheckBox chckbxPersonnalSources = new JCheckBox("Personnal sources");
        chckbxPersonnalSources.setBounds(33, 86, 170, 23);
        this.contentPanel.add(chckbxPersonnalSources);
        chckbxPersonnalSources.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigGeocodingDialog.this.txtCsv.setEnabled(true);
                    ConfigGeocodingDialog.this.btnOpenPersonnalSources.setEnabled(true);
                } else {
                    ConfigGeocodingDialog.this.txtCsv.setEnabled(false);
                    ConfigGeocodingDialog.this.btnOpenPersonnalSources.setEnabled(false);
                }
            }
        });
        JCheckBox chckbxGeonamesFile = new JCheckBox("Geonames file");
        chckbxGeonamesFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigGeocodingDialog.this.textGeonamesFile.setEnabled(true);
                    ConfigGeocodingDialog.this.btnOpenGeonamesFile.setEnabled(true);
                    ConfigGeocodingDialog.this.geoSourceChooser = 2;
                } else {
                    ConfigGeocodingDialog.this.textGeonamesFile.setEnabled(false);
                    ConfigGeocodingDialog.this.btnOpenGeonamesFile.setEnabled(false);
                }
            }
        });
        chckbxGeonamesFile.setBounds(33, 59, 140, 23);
        this.contentPanel.add(chckbxGeonamesFile);
        final JProgressBar progressBar = new JProgressBar();
        progressBar.setBounds(12, 156, 424, 14);
        progressBar.setVisible(false);
        this.contentPanel.add(progressBar);
        this.textGeonamesFile = new JTextField();
        this.textGeonamesFile.setEnabled(false);
        this.textGeonamesFile.setText("Geonames CSV");
        this.textGeonamesFile.setBounds(206, 59, 114, 21);
        this.contentPanel.add(this.textGeonamesFile);
        this.textGeonamesFile.setColumns(10);
        this.btnOpenGeonamesFile = new JButton("Open");
        this.btnOpenGeonamesFile.setEnabled(false);
        this.btnOpenGeonamesFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(ConfigGeocodingDialog.this);
                if (returnVal == 0) {
                    ConfigGeocodingDialog.this.csvFile = fc.getSelectedFile();
                    ConfigGeocodingDialog.this.geoSourceChooser = 0;
                    logger.debug("Opening CSV file: " + ConfigGeocodingDialog.this.csvFile.getName() + ".");
                } else {
                    logger.debug("Open CSV command cancelled by user.");
                }
                ConfigGeocodingDialog.this.textGeonamesFile.setText(ConfigGeocodingDialog.this.csvFile.getAbsolutePath());
            }
        });
        this.btnOpenGeonamesFile.setBounds(332, 63, 72, 15);
        this.contentPanel.add(this.btnOpenGeonamesFile);
        this.txtCsv = new JTextField();
        this.txtCsv.setEnabled(false);
        this.txtCsv.setText("Your CSV file");
        this.txtCsv.setBounds(206, 88, 114, 21);
        this.contentPanel.add(this.txtCsv);
        this.txtCsv.setColumns(10);
        this.btnOpenPersonnalSources = new JButton("Open");
        this.btnOpenPersonnalSources.setEnabled(false);
        this.btnOpenPersonnalSources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(ConfigGeocodingDialog.this);
                if (returnVal == 0) {
                    ConfigGeocodingDialog.this.csvFile = fc.getSelectedFile();
                    ConfigGeocodingDialog.this.geoSourceChooser = 1;
                    logger.debug("Opening CSV file: " + ConfigGeocodingDialog.this.csvFile.getName() + ".");
                } else {
                    logger.debug("Open CSV command cancelled by user.");
                }
                ConfigGeocodingDialog.this.txtCsv.setText(ConfigGeocodingDialog.this.csvFile.getAbsolutePath());
            }
        });
        this.btnOpenPersonnalSources.setBounds(332, 90, 72, 15);
        this.contentPanel.add(this.btnOpenPersonnalSources);
        JPanel buttonPane = new JPanel();
        buttonPane.setBounds(12, 182, 424, 35);
        this.contentPanel.add(buttonPane);
        buttonPane.setLayout(new FlowLayout(2));
        JButton geocodeButton = new JButton("Geocode");
        geocodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                progressBar.setVisible(true);
                progressBar.setEnabled(true);
                Geocode geocodingTask = null;
                if (ConfigGeocodingDialog.this.parentGui != null & ConfigGeocodingDialog.this.geoSourceChooser == 2) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonames", ConfigGeocodingDialog.this.parentGui);
                }
                if (ConfigGeocodingDialog.this.graph != null & ConfigGeocodingDialog.this.geoSourceChooser == 2) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonames", ConfigGeocodingDialog.this.netGUI, ConfigGeocodingDialog.this.graph);
                }
                if (ConfigGeocodingDialog.this.csvFile != null & ConfigGeocodingDialog.this.geoSourceChooser == 0) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonamesFile", ConfigGeocodingDialog.this.netGUI, ConfigGeocodingDialog.this.csvFile, ConfigGeocodingDialog.this.graph);
                }
                if (ConfigGeocodingDialog.this.csvFile != null & ConfigGeocodingDialog.this.geoSourceChooser == 1) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "personnalSources", ConfigGeocodingDialog.this.netGUI, ConfigGeocodingDialog.this.csvFile, ConfigGeocodingDialog.this.graph);
                }
                if (ConfigGeocodingDialog.this.graph != null & ConfigGeocodingDialog.this.geoSourceChooser == 3) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "integrated", ConfigGeocodingDialog.this.netGUI, ConfigGeocodingDialog.this.graph);
                }
                geocodingTask.execute();
            }
        });
        geocodeButton.setActionCommand("OK");
        buttonPane.add(geocodeButton);
        this.getRootPane().setDefaultButton(geocodeButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConfigGeocodingDialog.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JCheckBox chckbxIntegratedGeography = new JCheckBox("Integrated geography");
        chckbxGeonamesFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigGeocodingDialog.this.geoSourceChooser = 3;
                }
            }
        });
        chckbxIntegratedGeography.setBounds(33, 112, 97, 23);
        this.contentPanel.add(chckbxIntegratedGeography);
    }
}

