/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.util.MathUtils;

public class PartitionCriteriaShortPanel
extends JPanel {
    private static final long serialVersionUID = 8629535949909082139L;
    private static final Logger logger = LoggerFactory.getLogger(PartitionCriteriaShortPanel.class);
    private List<String> targetLabels;
    private JTextField txtfldParameter;
    private JTextField txtfldPattern;
    private JTextField txtfldCountedStart;
    private JTextField txtfldCountedCount;
    private JTextField txtfldCountedEnd;
    private JTextField txtfldSteps;
    private JTextField txtfldSizedStart;
    private JTextField txtfldSizedSize;
    private JTextField txtfldSizedEnd;
    private JPanel panelRaw;
    private JPanel panelBinarization;
    private JPanel panelFreeGrouping;
    private JPanel panelCountedGrouping;
    private JPanel panelSizedGrouping;
    private JComboBox comboBoxLabel;
    private JComboBox comboBoxType;
    private JLabel lblnone;
    private JComboBox cmbbxCumulationType;
    private JButton buttonClear;
    private JComboBox cmbbxValueFilter;
    private JComboBox cmbbxSizeFilter;

    public PartitionCriteriaShortPanel(List<String> labels, PartitionCriteria defaultCriteria) {
        if (labels == null) {
            this.targetLabels = new ArrayList<String>();
            this.targetLabels.add("");
        } else {
            this.targetLabels = new ArrayList<String>(labels.size() + 1);
            this.targetLabels.add("");
            this.targetLabels.addAll(labels);
        }
        this.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel_1 = new JPanel();
        this.add(panel_1);
        panel_1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:30dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.comboBoxLabel = new JComboBox<Object>(this.targetLabels.toArray());
        this.comboBoxLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.equals((CharSequence)((String)PartitionCriteriaShortPanel.this.comboBoxLabel.getSelectedItem()), (CharSequence)"PEDG")) {
                    PartitionCriteriaShortPanel.this.cmbbxSizeFilter.setSelectedIndex(3);
                }
            }
        });
        panel_1.add((Component)this.comboBoxLabel, "2, 2");
        this.comboBoxLabel.setSelectedIndex(0);
        this.comboBoxLabel.setMaximumRowCount(12);
        this.comboBoxLabel.setEditable(true);
        this.txtfldParameter = new JTextField();
        this.txtfldParameter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (StringUtils.equals((CharSequence)((String)PartitionCriteriaShortPanel.this.comboBoxLabel.getSelectedItem()), (CharSequence)"PEDG") && NumberUtils.isNumber((String)PartitionCriteriaShortPanel.this.txtfldParameter.getText())) {
                    String max = String.valueOf((int)Math.pow(2.0, new Double(PartitionCriteriaShortPanel.this.txtfldParameter.getText())));
                    PartitionCriteriaShortPanel.this.txtfldCountedEnd.setText(max);
                    PartitionCriteriaShortPanel.this.txtfldSizedEnd.setText(max);
                }
            }
        });
        panel_1.add((Component)this.txtfldParameter, "4, 2");
        this.txtfldParameter.setColumns(10);
        this.comboBoxType = new JComboBox<Object>(new Object[0]);
        this.comboBoxType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    PartitionCriteria.PartitionType type;
                    switch (PartitionCriteriaShortPanel.this.comboBoxType.getSelectedIndex()) {
                        case 0: {
                            type = PartitionCriteria.PartitionType.RAW;
                            break;
                        }
                        case 1: {
                            type = PartitionCriteria.PartitionType.BINARIZATION;
                            break;
                        }
                        case 2: {
                            type = PartitionCriteria.PartitionType.FREE_GROUPING;
                            break;
                        }
                        case 3: {
                            type = PartitionCriteria.PartitionType.COUNTED_GROUPING;
                            break;
                        }
                        case 4: {
                            type = PartitionCriteria.PartitionType.SIZED_GROUPING;
                            break;
                        }
                        default: {
                            type = PartitionCriteria.PartitionType.RAW;
                        }
                    }
                    PartitionCriteriaShortPanel.this.display(type);
                }
            }
        });
        this.comboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"Raw", "Binarization", "Free Grouping", "Counted Grouping", "Sized Grouping"}));
        this.comboBoxType.setSelectedIndex(0);
        this.comboBoxType.setMaximumRowCount(12);
        panel_1.add((Component)this.comboBoxType, "6, 2, fill, default");
        JPanel panel = new JPanel();
        panel_1.add((Component)panel, "8, 2");
        panel.setLayout(new BoxLayout(panel, 1));
        this.panelRaw = new JPanel();
        panel.add(this.panelRaw);
        this.panelRaw.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.lblnone = new JLabel("(none)");
        this.lblnone.setHorizontalAlignment(0);
        this.panelRaw.add((Component)this.lblnone, "2, 2");
        this.panelBinarization = new JPanel();
        panel.add(this.panelBinarization);
        this.panelBinarization.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.txtfldPattern = new JTextField();
        this.panelBinarization.add((Component)this.txtfldPattern, "2, 2, fill, default");
        this.txtfldPattern.setColumns(20);
        JLabel lblPattern = new JLabel("(pattern)");
        this.panelBinarization.add((Component)lblPattern, "4, 2, left, default");
        this.panelFreeGrouping = new JPanel();
        panel.add(this.panelFreeGrouping);
        this.panelFreeGrouping.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.MIN_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.txtfldSteps = new JTextField();
        this.panelFreeGrouping.add((Component)this.txtfldSteps, "2, 2, fill, default");
        this.txtfldSteps.setColumns(20);
        JLabel lblSteps = new JLabel("(steps)");
        this.panelFreeGrouping.add((Component)lblSteps, "4, 2, left, default");
        this.panelCountedGrouping = new JPanel();
        panel.add(this.panelCountedGrouping);
        this.panelCountedGrouping.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.txtfldCountedStart = new JTextField();
        this.panelCountedGrouping.add((Component)this.txtfldCountedStart, "2, 2, fill, default");
        this.txtfldCountedStart.setColumns(10);
        this.txtfldCountedCount = new JTextField();
        this.panelCountedGrouping.add((Component)this.txtfldCountedCount, "4, 2, fill, default");
        this.txtfldCountedCount.setColumns(10);
        this.txtfldCountedEnd = new JTextField();
        this.panelCountedGrouping.add((Component)this.txtfldCountedEnd, "6, 2, fill, default");
        this.txtfldCountedEnd.setColumns(10);
        JLabel lblStart = new JLabel("(start, count, end)");
        this.panelCountedGrouping.add((Component)lblStart, "8, 2, right, default");
        this.panelSizedGrouping = new JPanel();
        panel.add(this.panelSizedGrouping);
        this.panelSizedGrouping.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.txtfldSizedStart = new JTextField();
        this.panelSizedGrouping.add((Component)this.txtfldSizedStart, "2, 2, fill, default");
        this.txtfldSizedStart.setColumns(10);
        this.txtfldSizedSize = new JTextField();
        this.panelSizedGrouping.add((Component)this.txtfldSizedSize, "4, 2, fill, default");
        this.txtfldSizedSize.setColumns(10);
        this.txtfldSizedEnd = new JTextField();
        this.panelSizedGrouping.add((Component)this.txtfldSizedEnd, "6, 2, fill, default");
        this.txtfldSizedEnd.setColumns(10);
        JLabel lblSize = new JLabel("(start, size, end)");
        this.panelSizedGrouping.add((Component)lblSize, "8, 2, right, default");
        this.cmbbxCumulationType = new JComboBox();
        this.cmbbxCumulationType.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Asc.", "Desc."}));
        panel_1.add((Component)this.cmbbxCumulationType, "10, 2, fill, default");
        this.cmbbxValueFilter = new JComboBox();
        this.cmbbxValueFilter.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Null", "Zero"}));
        panel_1.add((Component)this.cmbbxValueFilter, "12, 2, fill, default");
        this.buttonClear = new JButton("");
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartitionCriteriaShortPanel.this.clear();
            }
        });
        this.cmbbxSizeFilter = new JComboBox();
        this.cmbbxSizeFilter.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Trim", "Empty", "Holes"}));
        panel_1.add((Component)this.cmbbxSizeFilter, "14, 2, fill, default");
        this.buttonClear.setMaximumSize(new Dimension(18, 18));
        this.buttonClear.setIcon(new ImageIcon(PartitionCriteriaShortPanel.class.getResource("/org/tip/puckgui/images/edit-clear-16x16.png")));
        panel_1.add((Component)this.buttonClear, "16, 2");
        this.display(PartitionCriteria.PartitionType.RAW);
        this.setCriteria(defaultCriteria);
    }

    public void clear() {
        this.targetLabels.set(0, "");
        this.comboBoxLabel.setModel(new DefaultComboBoxModel<Object>(this.targetLabels.toArray()));
        this.display(PartitionCriteria.PartitionType.RAW);
        this.comboBoxType.setSelectedIndex(0);
        this.txtfldParameter.setText("");
        this.txtfldPattern.setText("");
        this.txtfldSteps.setText("");
        this.txtfldCountedStart.setText("");
        this.txtfldCountedCount.setText("");
        this.txtfldCountedEnd.setText("");
        this.txtfldSizedStart.setText("");
        this.txtfldSizedSize.setText("");
        this.txtfldSizedEnd.setText("");
        this.cmbbxCumulationType.setSelectedIndex(0);
        this.cmbbxValueFilter.setSelectedIndex(0);
        this.cmbbxSizeFilter.setSelectedIndex(0);
    }

    public void display(PartitionCriteria.PartitionType type) {
        this.panelRaw.setVisible(false);
        this.panelBinarization.setVisible(false);
        this.panelFreeGrouping.setVisible(false);
        this.panelCountedGrouping.setVisible(false);
        this.panelSizedGrouping.setVisible(false);
        switch (type) {
            case RAW: {
                this.panelRaw.setVisible(true);
                break;
            }
            case BINARIZATION: {
                this.panelBinarization.setVisible(true);
                break;
            }
            case FREE_GROUPING: {
                this.panelFreeGrouping.setVisible(true);
                break;
            }
            case COUNTED_GROUPING: {
                this.panelCountedGrouping.setVisible(true);
                break;
            }
            case SIZED_GROUPING: {
                this.panelSizedGrouping.setVisible(true);
            }
        }
    }

    public PartitionCriteria getCriteria() {
        PartitionCriteria result;
        String label = (String)this.comboBoxLabel.getSelectedItem();
        if (this.panelRaw.isVisible()) {
            result = PartitionCriteria.createRaw(label, this.txtfldParameter.getText());
        } else if (this.panelBinarization.isVisible()) {
            result = PartitionCriteria.createBinarization(label, this.txtfldParameter.getText(), this.txtfldPattern.getText());
        } else if (this.panelFreeGrouping.isVisible()) {
            result = PartitionCriteria.createGrouping(label, this.txtfldParameter.getText(), this.txtfldSteps.getText());
        } else if (this.panelCountedGrouping.isVisible()) {
            Double start = NumberUtils.isNumber((String)this.txtfldCountedStart.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldCountedStart.getText())) : null;
            Double count = NumberUtils.isNumber((String)this.txtfldCountedCount.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldCountedCount.getText())) : null;
            Double end = NumberUtils.isNumber((String)this.txtfldCountedEnd.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldCountedEnd.getText())) : null;
            result = PartitionCriteria.createCountedGrouping(label, this.txtfldParameter.getText(), start, count, end);
        } else if (this.panelSizedGrouping.isVisible()) {
            Double start = NumberUtils.isNumber((String)this.txtfldSizedStart.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldSizedStart.getText())) : null;
            Double size = NumberUtils.isNumber((String)this.txtfldSizedSize.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldSizedSize.getText())) : null;
            Double end = NumberUtils.isNumber((String)this.txtfldSizedEnd.getText()) ? Double.valueOf(Double.parseDouble(this.txtfldSizedEnd.getText())) : null;
            result = PartitionCriteria.createSizedGrouping(label, this.txtfldParameter.getText(), start, size, end);
        } else {
            result = null;
        }
        if (result != null) {
            switch (this.cmbbxCumulationType.getSelectedIndex()) {
                case 0: {
                    result.setCumulationType(PartitionCriteria.CumulationType.NONE);
                    break;
                }
                case 1: {
                    result.setCumulationType(PartitionCriteria.CumulationType.ASCENDANT);
                    break;
                }
                case 2: {
                    result.setCumulationType(PartitionCriteria.CumulationType.DESCENDANT);
                    break;
                }
                default: {
                    result.setCumulationType(PartitionCriteria.CumulationType.NONE);
                }
            }
            switch (this.cmbbxValueFilter.getSelectedIndex()) {
                case 0: {
                    result.setValueFilter(PartitionCriteria.ValueFilter.NONE);
                    break;
                }
                case 1: {
                    result.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    break;
                }
                case 2: {
                    result.setValueFilter(PartitionCriteria.ValueFilter.ZERO);
                    break;
                }
                default: {
                    result.setValueFilter(PartitionCriteria.ValueFilter.NONE);
                }
            }
            switch (this.cmbbxSizeFilter.getSelectedIndex()) {
                case 0: {
                    result.setSizeFilter(PartitionCriteria.SizeFilter.NONE);
                    break;
                }
                case 1: {
                    result.setSizeFilter(PartitionCriteria.SizeFilter.TRIM);
                    break;
                }
                case 2: {
                    result.setSizeFilter(PartitionCriteria.SizeFilter.EMPTY);
                    break;
                }
                case 3: {
                    result.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    break;
                }
                default: {
                    result.setSizeFilter(PartitionCriteria.SizeFilter.NONE);
                }
            }
        }
        return result;
    }

    public void setCriteria(PartitionCriteria source) {
        if (source != null) {
            int index;
            this.comboBoxLabel.setModel(new DefaultComboBoxModel<Object>(this.targetLabels.toArray()));
            if (source.getLabel() != null && (index = this.targetLabels.indexOf(source.getLabel())) != -1) {
                this.comboBoxLabel.setSelectedIndex(index);
            }
            if (source.getLabelParameter() != null) {
                this.txtfldParameter.setText(source.getLabelParameter());
            }
            if (source.getType() != null) {
                switch (source.getType()) {
                    case RAW: {
                        this.comboBoxType.setSelectedIndex(0);
                        break;
                    }
                    case BINARIZATION: {
                        this.comboBoxType.setSelectedIndex(1);
                        if (source.getPattern() == null) break;
                        this.txtfldPattern.setText(source.getPattern());
                        break;
                    }
                    case FREE_GROUPING: {
                        this.comboBoxType.setSelectedIndex(2);
                        if (source.getIntervals() == null) break;
                        this.txtfldSteps.setText(source.getIntervals().toBasicStepString());
                        break;
                    }
                    case COUNTED_GROUPING: {
                        this.comboBoxType.setSelectedIndex(3);
                        if (source.getStart() != null) {
                            this.txtfldCountedStart.setText(MathUtils.toString(source.getStart()));
                        }
                        if (source.getCount() != null) {
                            this.txtfldCountedCount.setText(MathUtils.toString(source.getCount()));
                        }
                        if (source.getEnd() == null) break;
                        this.txtfldCountedEnd.setText(MathUtils.toString(source.getEnd()));
                        break;
                    }
                    case SIZED_GROUPING: {
                        this.comboBoxType.setSelectedIndex(4);
                        if (source.getStart() != null) {
                            this.txtfldSizedStart.setText(MathUtils.toString(source.getStart()));
                        }
                        if (source.getSize() != null) {
                            this.txtfldSizedSize.setText(MathUtils.toString(source.getSize()));
                        }
                        if (source.getEnd() == null) break;
                        this.txtfldSizedEnd.setText(MathUtils.toString(source.getEnd()));
                    }
                }
            }
            if (source.getCumulationType() != null) {
                switch (source.getCumulationType()) {
                    case NONE: {
                        this.cmbbxCumulationType.setSelectedIndex(0);
                        break;
                    }
                    case ASCENDANT: {
                        this.cmbbxCumulationType.setSelectedIndex(1);
                        break;
                    }
                    case DESCENDANT: {
                        this.cmbbxCumulationType.setSelectedIndex(2);
                        break;
                    }
                    default: {
                        this.cmbbxCumulationType.setSelectedIndex(0);
                    }
                }
            }
            if (source.getValueFilter() != null) {
                switch (source.getValueFilter()) {
                    case NONE: {
                        this.cmbbxValueFilter.setSelectedIndex(0);
                        break;
                    }
                    case NULL: {
                        this.cmbbxValueFilter.setSelectedIndex(1);
                        break;
                    }
                    case ZERO: {
                        this.cmbbxValueFilter.setSelectedIndex(2);
                        break;
                    }
                    default: {
                        this.cmbbxValueFilter.setSelectedIndex(0);
                    }
                }
            }
            if (source.getSizeFilter() != null) {
                switch (source.getSizeFilter()) {
                    case NONE: {
                        this.cmbbxSizeFilter.setSelectedIndex(0);
                        break;
                    }
                    case TRIM: {
                        this.cmbbxSizeFilter.setSelectedIndex(1);
                        break;
                    }
                    case EMPTY: {
                        this.cmbbxSizeFilter.setSelectedIndex(2);
                        break;
                    }
                    case HOLES: {
                        this.cmbbxSizeFilter.setSelectedIndex(3);
                        break;
                    }
                    default: {
                        this.cmbbxValueFilter.setSelectedIndex(0);
                    }
                }
            }
        }
    }
}

