/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.workers.AttributeDescriptor;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeToRelationCriteria;
import org.tip.puck.net.workers.AttributeWorker;

public class AttributeToRelationInputDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private final JPanel contentPanel = new JPanel();
    private AttributeToRelationCriteria dialogCriteria;
    private static AttributeToRelationCriteria lastCriteria = new AttributeToRelationCriteria();
    private JComboBox cmbbxTarget;
    private JComboBox cmbbxLabel;
    private JTextField txtfldNewName;
    private JCheckBox chckbxIgnoreCase;

    public AttributeToRelationInputDialog(List<String> relationModelNames, final AttributeDescriptors attributeDescriptors) {
        ArrayList<String> targetLabels = new ArrayList<String>();
        targetLabels.add("ALL");
        targetLabels.add("CORPUS");
        targetLabels.add("INDIVIDUALS");
        targetLabels.add("FAMILIES");
        targetLabels.add("RELATIONS");
        if (relationModelNames != null) {
            for (String name : relationModelNames) {
                targetLabels.add(name);
            }
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Attribute To Relation Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AttributeToRelationInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AttributeToRelationInputDialog.this.dialogCriteria = null;
                AttributeToRelationInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 235);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblTarget = new JLabel("Target:");
        this.contentPanel.add((Component)lblTarget, "2, 2, right, default");
        this.cmbbxTarget = new JComboBox<Object>(targetLabels.toArray());
        this.cmbbxTarget.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    StringList labels;
                    switch (AttributeToRelationInputDialog.this.cmbbxTarget.getSelectedIndex()) {
                        case 0: {
                            labels = attributeDescriptors.labels();
                            break;
                        }
                        case 1: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.CORPUS).labels();
                            break;
                        }
                        case 2: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.INDIVIDUALS).labels();
                            break;
                        }
                        case 3: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.FAMILIES).labels();
                            break;
                        }
                        case 4: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.RELATION).labels();
                            break;
                        }
                        default: {
                            labels = attributeDescriptors.findByRelationModelName((String)AttributeToRelationInputDialog.this.cmbbxTarget.getSelectedItem()).labels();
                        }
                    }
                    Collections.sort(labels);
                    AttributeToRelationInputDialog.this.cmbbxLabel.setModel(new DefaultComboBoxModel<Object>(labels.toArray()));
                    AttributeToRelationInputDialog.this.cmbbxLabel.setSelectedIndex(-1);
                }
            }
        });
        this.contentPanel.add((Component)this.cmbbxTarget, "4, 2, fill, default");
        JLabel lblLabel = new JLabel("Label:");
        this.contentPanel.add((Component)lblLabel, "2, 4, right, default");
        this.cmbbxLabel = new JComboBox<Object>(attributeDescriptors.labelsSorted().toArray());
        this.cmbbxLabel.setEditable(true);
        this.contentPanel.add((Component)this.cmbbxLabel, "4, 4, fill, default");
        JLabel lblNewLabel = new JLabel("Role:");
        this.contentPanel.add((Component)lblNewLabel, "2, 6, right, default");
        this.txtfldNewName = new JTextField();
        this.contentPanel.add((Component)this.txtfldNewName, "4, 6");
        this.txtfldNewName.setColumns(10);
        JPanel panel = new JPanel();
        panel.setBorder(null);
        this.contentPanel.add((Component)panel, "4, 8, fill, center");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"21px"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"83px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"21px"), FormFactory.DEFAULT_ROWSPEC}));
        this.chckbxIgnoreCase = new JCheckBox("");
        panel.add((Component)this.chckbxIgnoreCase, "2, 2, left, top");
        JLabel lblIgnoreCase = new JLabel("ignore case");
        panel.add((Component)lblIgnoreCase, "4, 2, left, center");
        JCheckBox chckbxTrim = new JCheckBox("");
        panel.add((Component)chckbxTrim, "2, 3");
        chckbxTrim.setEnabled(false);
        chckbxTrim.setSelected(true);
        JLabel lblTrimLabelAnd = new JLabel("trim label and new label");
        panel.add((Component)lblTrimLabelAnd, "4, 3");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeToRelationInputDialog.this.dialogCriteria = null;
                AttributeToRelationInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Convert");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeToRelationCriteria criteria = AttributeToRelationInputDialog.this.getCriteria();
                if (StringUtils.isBlank((CharSequence)criteria.getLabel())) {
                    String title = "Invalid input";
                    String message = "Please, enter a label not empty.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    AttributeToRelationInputDialog.this.dialogCriteria = criteria;
                    AttributeToRelationInputDialog.this.setVisible(false);
                }
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public AttributeToRelationCriteria getCriteria() {
        String optionalName;
        AttributeWorker.Scope scope;
        AttributeToRelationCriteria result = new AttributeToRelationCriteria();
        switch (this.cmbbxTarget.getSelectedIndex()) {
            case 0: {
                scope = AttributeWorker.Scope.ALL;
                optionalName = null;
                break;
            }
            case 1: {
                scope = AttributeWorker.Scope.CORPUS;
                optionalName = null;
                break;
            }
            case 2: {
                scope = AttributeWorker.Scope.INDIVIDUALS;
                optionalName = null;
                break;
            }
            case 3: {
                scope = AttributeWorker.Scope.FAMILIES;
                optionalName = null;
                break;
            }
            case 4: {
                scope = AttributeWorker.Scope.RELATIONS;
                optionalName = null;
                break;
            }
            default: {
                scope = AttributeWorker.Scope.RELATION;
                optionalName = (String)this.cmbbxTarget.getSelectedItem();
            }
        }
        result.setScope(scope);
        result.setOptionalRelationName(optionalName);
        result.setLabel((String)this.cmbbxLabel.getSelectedItem());
        result.setRoleName(this.txtfldNewName.getText());
        if (this.chckbxIgnoreCase.isSelected()) {
            result.setCaseOption(AttributeWorker.CaseOption.IGNORE_CASE);
        } else {
            result.setCaseOption(AttributeWorker.CaseOption.CASE_SENSITIVE);
        }
        return result;
    }

    public AttributeToRelationCriteria getDialogCriteria() {
        AttributeToRelationCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(AttributeToRelationCriteria source) {
        if (source != null) {
            switch (source.getScope()) {
                case ALL: {
                    this.cmbbxTarget.setSelectedIndex(0);
                    break;
                }
                case CORPUS: {
                    this.cmbbxTarget.setSelectedIndex(1);
                    break;
                }
                case INDIVIDUALS: {
                    this.cmbbxTarget.setSelectedIndex(2);
                    break;
                }
                case FAMILIES: {
                    this.cmbbxTarget.setSelectedIndex(3);
                    break;
                }
                case RELATIONS: {
                    this.cmbbxTarget.setSelectedIndex(4);
                    break;
                }
                default: {
                    this.cmbbxTarget.setSelectedItem(source.getOptionalRelationName());
                }
            }
            this.cmbbxLabel.setSelectedItem(source.getLabel());
            this.txtfldNewName.setText(source.getRoleName());
            if (source.isCaseSensitive()) {
                this.chckbxIgnoreCase.setSelected(false);
            } else {
                this.chckbxIgnoreCase.setSelected(true);
            }
        }
    }

    public static void main(String[] args) {
        AttributeToRelationInputDialog.showDialog(null, null);
    }

    public static AttributeToRelationCriteria showDialog(List<String> relationModelNames, AttributeDescriptors attributeDescriptors) {
        AttributeToRelationInputDialog dialog = new AttributeToRelationInputDialog(relationModelNames, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        AttributeToRelationCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

