/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import org.tip.puck.util.MathUtils;

public class AttributeDescriptor {
    public static Scope[] CanonicalScopes = new Scope[]{Scope.CORPUS, Scope.INDIVIDUALS, Scope.FAMILIES};
    private Scope scope;
    private String optionalRelationName;
    private String label;
    private long countOfSet;
    private long countOfBlank;
    private long max;

    public AttributeDescriptor(Scope scope, String label) {
        this.scope = scope == null ? Scope.NONE : scope;
        this.label = label;
        this.countOfSet = 0L;
        this.countOfBlank = 0L;
    }

    public AttributeDescriptor(String optionalRelationName, String label) {
        this.scope = Scope.RELATION;
        this.optionalRelationName = optionalRelationName;
        this.label = label;
        this.countOfSet = 0L;
        this.countOfBlank = 0L;
    }

    public long getCountOfBlank() {
        return this.countOfBlank;
    }

    public long getCountOfFilled() {
        long result = this.countOfSet - this.countOfBlank;
        return result;
    }

    public long getCountOfNotSet() {
        long result = this.max < this.countOfSet ? this.countOfSet : this.max - this.countOfSet;
        return result;
    }

    public long getCountOfSet() {
        return this.countOfSet;
    }

    public double getCovegareOfNotSet() {
        double result = this.max < this.getCountOfNotSet() ? 100.0 : MathUtils.percent(this.getCountOfNotSet(), this.max);
        return result;
    }

    public double getCoverageOfBlank() {
        double result = this.max < this.getCountOfBlank() ? 100.0 : MathUtils.percent(this.getCountOfBlank(), this.max);
        return result;
    }

    public double getCoverageOfFilled() {
        double result = this.max < this.getCountOfFilled() ? 100.0 : MathUtils.percent(this.getCountOfFilled(), this.max);
        return result;
    }

    public double getCoverageOfSet() {
        double result = this.max < this.getCountOfSet() ? 100.0 : MathUtils.percent(this.getCountOfSet(), this.max);
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    public long getMax() {
        return this.max;
    }

    public String getOptionalRelationName() {
        return this.optionalRelationName;
    }

    public String getRelationName() {
        String result;
        switch (this.scope) {
            case CORPUS: 
            case INDIVIDUALS: 
            case FAMILIES: {
                result = this.scope.name();
                break;
            }
            case RELATION: {
                result = this.optionalRelationName;
                break;
            }
            case ACTORS: {
                result = this.scope.name();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void incCountOfBlank() {
        ++this.countOfBlank;
    }

    public void incCountOfSet() {
        ++this.countOfSet;
    }

    public void setCountOfBlank(long countOfBlank) {
        this.countOfBlank = countOfBlank;
    }

    public void setCountOfSet(long count) {
        this.countOfSet = count;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public void setOptionalRelationName(String optionalRelationName) {
        this.optionalRelationName = optionalRelationName;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public static enum Scope {
        NONE,
        CORPUS,
        INDIVIDUALS,
        FAMILIES,
        RELATION,
        ACTORS;

    }
}

