/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.csv;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;

public class CSVFile {
    private static final Logger logger = LoggerFactory.getLogger(CSVFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;
    public static final int GEONAMES_FILE = 0;
    public static final int PERSONNAL_FILE = 1;

    public static Graph<Place> load(File csvFile, Graph<?> graph, int typeOfCSV) throws PuckException {
        Graph<Place> returnHashedPlaces = new Graph<Place>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(csvFile.getAbsolutePath()));
            returnHashedPlaces = CSVFile.readLines(br, graph, typeOfCSV);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnHashedPlaces;
    }

    public static Graph<Place> readLines(BufferedReader reader, Graph<?> placesGraph, int typeOfCSV) throws IOException {
        String nextLine;
        Graph<Place> graphPlaces = new Graph<Place>("GraphPlaces");
        ArrayList places = new ArrayList();
        int i = 0;
        while ((nextLine = reader.readLine()) != null) {
            String[] columnDetail = nextLine.split("\t", -1);
            for (Node<?> node : placesGraph.getNodes()) {
                Coordinate c;
                String stringNode = Arrays.asList(node.getLabel().split(",")).get(0);
                if (typeOfCSV == 0 && stringNode.compareTo(columnDetail[1]) == 0 | stringNode.compareTo(columnDetail[2]) == 0 | stringNode.compareTo(columnDetail[3]) == 0) {
                    c = new Coordinate(Double.parseDouble(columnDetail[4]), Double.parseDouble(columnDetail[5]));
                    graphPlaces.addNode(new Place(Integer.parseInt(columnDetail[0]), columnDetail[1], columnDetail[1], columnDetail[2], columnDetail[3], columnDetail[8], c));
                    continue;
                }
                if (typeOfCSV != 1 || stringNode.compareTo(columnDetail[1]) != 0) continue;
                c = new Coordinate(Double.parseDouble(columnDetail[3]), Double.parseDouble(columnDetail[4]));
                graphPlaces.addNode(new Place(Integer.parseInt(columnDetail[0]), columnDetail[1], "", "", "", columnDetail[2], c));
            }
            ++i;
        }
        System.out.println("End csv file : " + placesGraph.nodeCount() + " nodes found");
        return graphPlaces;
    }
}

