/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.alliancenets;

import org.tip.puck.alliancenets.Alliance;
import org.tip.puck.alliancenets.AllianceNet;
import org.tip.puck.alliancenets.Group;
import org.tip.puck.alliancenets.TopologicalIndices;
import org.tip.puck.evo.Generator;
import org.tip.puck.util.RandomGenerator;

public class RandomGen
extends Generator {
    private AllianceNet allianceNet;
    private TopologicalIndices indices;
    private TopologicalIndices targetIndices;

    public RandomGen(int nodeCount, int edgeCount, TopologicalIndices targetIndices) {
        super(nodeCount, edgeCount);
        this.targetIndices = targetIndices;
        this.indices = null;
    }

    @Override
    public void createProgSet() {
        this.progcount = 0;
        this.progset = null;
    }

    @Override
    public void run() {
        this.allianceNet = new AllianceNet(true);
        Group[] nodeArray = new Group[this.nodeCount];
        int i = 0;
        while (i < this.nodeCount) {
            nodeArray[i] = this.allianceNet.addNodeWithId(i);
            ++i;
        }
        int n = (int)this.targetIndices.getN();
        int i2 = 0;
        while (i2 < n) {
            int targIndex;
            Group targNode;
            int origIndex = RandomGenerator.instance().random.nextInt(this.nodeCount);
            Group origNode = nodeArray[origIndex];
            Alliance alliance = this.allianceNet.getEdge(origNode, targNode = nodeArray[targIndex = RandomGenerator.instance().random.nextInt(this.nodeCount)]);
            if (alliance == null) {
                this.allianceNet.addEdge(origNode, targNode, i2);
                alliance = this.allianceNet.getEdge(origNode, targNode);
            }
            alliance.setWeight(alliance.getWeight() + 1.0);
            ++i2;
        }
    }

    @Override
    public double distance(Generator generator) {
        return 0.0;
    }

    @Override
    public Generator clone() {
        return new RandomGen(this.nodeCount, this.edgeCount, this.targetIndices);
    }

    public TopologicalIndices getIndices() {
        return this.indices;
    }

    public void setIndices(TopologicalIndices indices) {
        this.indices = indices;
    }

    public TopologicalIndices getTargetIndices() {
        return this.targetIndices;
    }

    public void setTargetIndices(TopologicalIndices targetIndices) {
        this.targetIndices = targetIndices;
    }

    public AllianceNet getNet() {
        return this.allianceNet;
    }
}

