package org.tip.puck.geo2;

import java.text.Collator;
import java.util.Comparator;

/**
 * 
 */
public class Place2Comparator implements Comparator<Place2> {

	public enum Sorting {
		DEFAULT,
		TOPONYM
	}

	private Sorting sorting;

	/**
	 * 
	 * @param sorting
	 */
	public Place2Comparator() {
		//
		this.sorting = Sorting.DEFAULT;
	}

	/**
	 * 
	 * @param sorting
	 */
	public Place2Comparator(final Sorting sorting) {
		//
		this.sorting = sorting;
	}

	/**
	 * 
	 */
	@Override
	public int compare(final Place2 alpha, final Place2 bravo) {
		int result;

		//
		result = compare(alpha, bravo, this.sorting);

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public String getLabel(final Place2 source) {
		String result;

		if (source == null) {
			result = null;
		} else {
			result = source.getToponym();
		}

		//
		return result;
	}

	/**
	 * 
	 * @param alpha
	 * @param bravo
	 * @param sorting
	 * @return
	 */
	public static int compare(final Place2 alpha, final Place2 bravo, final Sorting sorting) {
		int result;

		if ((alpha == null) && (bravo == null)) {
			//
			result = 0;

		} else if (alpha == null) {
			//
			result = -1;

		} else if (bravo == null) {
			//
			result = +1;

		} else {
			//
			switch (sorting) {
				case DEFAULT:
				case TOPONYM:
					//
					result = compare(alpha.getToponym(), bravo.getToponym());
				break;

				default:
					result = 0;
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param alpha
	 * @param bravo
	 * @return
	 */
	public static int compare(final String alpha, final String bravo) {
		int result;

		//
		if ((alpha == null) && (bravo == null)) {
			//
			result = 0;

		} else if (alpha == null) {
			//
			result = -1;

		} else if (bravo == null) {
			//
			result = +1;

		} else {
			//
			result = Collator.getInstance().compare(alpha, bravo);
		}

		//
		return result;
	}
}
