package org.tip.puck.geo.tools;

import java.util.ArrayList;

import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.io.BuildingGeoLinks;
import org.tip.puck.geo2.Coordinate2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;

/**
 * 
 */
public class GeotoolsUtils {

	private static final Logger logger = LoggerFactory.getLogger(GeotoolsUtils.class);

	private GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

	/**
	 * 
	 * @param geoNetwork
	 * @param geoFlowNetwork
	 * @return
	 */
	public ArrayList<DefaultFeatureCollection> getFeaturesForNodesPlaces(final Graph<Place> geoNetwork, final Graph<?> geoFlowNetwork) {

		ArrayList<DefaultFeatureCollection> collectionsPointsAndLines = new ArrayList<DefaultFeatureCollection>();

		DefaultFeatureCollection featurePointsCollection;
		DefaultFeatureCollection featureLinesCollection;
//		SimpleFeatureBuilder featureBuilder;

//		GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

		SimpleFeatureType pointFeatureType;

		SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();

		// set the name
		b.setName("SCHEMA_POINT");

		// add a geometry property
		b.setCRS(DefaultGeographicCRS.WGS84); // set crs first
		b.add("id_geonames", Integer.class);
		b.add("name", String.class);
		b.add("country", String.class);
		b.add("the_geom", Point.class); // then add geometry

		// build the type
		pointFeatureType = b.buildFeatureType();

		featurePointsCollection = new DefaultFeatureCollection("internal", pointFeatureType);

//		featureBuilder = new SimpleFeatureBuilder(pointFeatureType);

		// Add nodes and build geometry
		for (Node<Place> node : geoNetwork.getNodes()) {

			Point point = this.geometryFactory.createPoint(node.getReferent().getCoordinate());

			SimpleFeature f = SimpleFeatureBuilder.build(pointFeatureType, new Object[] { node.getReferent().getIdGeonames(), node.getReferent().getName(),
					node.getReferent().getCountry_ISO2(), point }, null);

			if (f != null) {
				featurePointsCollection.add(f);
			}

			// Place p;
			// if( f != null ) {
			//
			// featurePointsCollection.add(f);
			//
			// Geometry g = (Geometry) f.getAttribute( "the_geom" );
			// p = new Place(node.getLabel(), g.getCoordinate());
			//
			// }
			// else {
			// p = new Place(node.getLabel());
			//
			// }
			// graphPlaces.addNode(node.getId(),p);
			//
			// //prepare for clustering
			// placesList.add(p); //hashset guarantee to avoid duplicate value
			// placesListDuplicate.add(p); //list conserve all values

		}
		collectionsPointsAndLines.add(featurePointsCollection);

		// Add links
		geoNetwork.addLinksByIds(geoNetwork.getLinks());

		BuildingGeoLinks linksFactory = new BuildingGeoLinks();
		featureLinesCollection = linksFactory.buildLinkGeometry(null, geoNetwork);

		collectionsPointsAndLines.add(featureLinesCollection);

		return collectionsPointsAndLines;
	}

	/**
	 * 
	 * @param source
	 * @return
	 */
	public static com.vividsolutions.jts.geom.Coordinate convert(final Coordinate2 source) {
		com.vividsolutions.jts.geom.Coordinate result;

		if (source == null) {
			result = null;
		} else {
			result = new com.vividsolutions.jts.geom.Coordinate(source.getLongitude(), source.getLatitude(), source.getElevation());
		}

		//
		return result;
	}

	/**
	 * 
	 * @param geoNetwork
	 * @param geoFlowNetwork
	 * @return
	 */
	public static ArrayList<DefaultFeatureCollection> getFeaturesForNodesPlaces(final Graph<Place2> graph) {
		ArrayList<DefaultFeatureCollection> result;

		result = new ArrayList<DefaultFeatureCollection>();

//		SimpleFeatureBuilder featureBuilder;

		GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

		SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();

		// Set the name.
		builder.setName("SCHEMA_POINT");

		// Add a geometry property.
		builder.setCRS(DefaultGeographicCRS.WGS84); // set crs first
		builder.add("id_geonames", String.class);
		builder.add("name", String.class);
		builder.add("weight", Double.class);
		builder.add("the_geom", Point.class); // then add geometry

		// build the type
		SimpleFeatureType pointFeatureType = builder.buildFeatureType();

		DefaultFeatureCollection featurePointsCollection = new DefaultFeatureCollection("internal", pointFeatureType);
//		featureBuilder = new SimpleFeatureBuilder(pointFeatureType);

		// Add nodes and build geometry
		for (Node<Place2> node : graph.getNodes()) {
			logger.debug("node.getReferent={}", node.getReferent());
			Point point = geometryFactory.createPoint(convert(node.getReferent().getCoordinate()));

			SimpleFeature feature = SimpleFeatureBuilder.build(pointFeatureType, new Object[] { node.getReferent().getExtraData(),
					node.getReferent().getToponym(), node.getWeight(), point }, null);

			if (feature != null) {
				featurePointsCollection.add(feature);
			}
		}
		result.add(featurePointsCollection);

		// Add links
		BuildingGeoLinks linksFactory = new BuildingGeoLinks();

		DefaultFeatureCollection featureLinesCollection;
		featureLinesCollection = linksFactory.buildLinkGeometry2(null, graph);
		result.add(featureLinesCollection);

		//
		return result;
	}
}