/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ManyValuesMap<K, V>
implements Map<K, Set<V>> {
    private Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    public static <K> Map<Integer, Set<K>> valuesCount(Map<K, ? extends Set<?>> map) {
        HashMap<Integer, Set<Integer>> wMap = new HashMap<Integer, Set<Integer>>();
        for (Map.Entry<K, Set<?>> entry : map.entrySet()) {
            K k = entry.getKey();
            int weight = entry.getValue().size();
            Set kSet = (Set)wMap.get(weight);
            if (kSet == null) {
                wMap.put(weight, new HashSet());
                kSet = (Set)wMap.get(weight);
            }
            kSet.add(k);
        }
        return wMap;
    }

    private Set<V> init(K key) {
        Set<V> get = this.map.get(key);
        if (get == null) {
            get = new HashSet<V>();
            this.map.put(key, get);
        }
        return get;
    }

    public Map<K, Set<V>> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public int valuesSize() {
        int total = 0;
        for (Map.Entry<K, Set<V>> entry : this.entrySet()) {
            Set<V> Set2 = entry.getValue();
            if (Set2 == null) continue;
            total += Set2.size();
        }
        return total;
    }

    public int valueSize(K key) {
        return this.map.get(key).size();
    }

    public boolean add(K key, V value) {
        return this.init(key).add(value);
    }

    @Override
    public boolean remove(K key, V value) {
        Set<V> set = this.map.get(key);
        if (set == null) {
            return false;
        }
        return set.remove(value);
    }

    public boolean removeAll(K key, Collection<? extends V> values) {
        Set<V> set = this.map.get(key);
        if (set == null) {
            return false;
        }
        boolean result = true;
        for (V v : values) {
            result &= set.remove(v);
        }
        return result;
    }

    public boolean addAll(K key, Collection<? extends V> values) {
        Set<V> initSet = this.init(key);
        boolean result = true;
        for (V v : values) {
            result &= initSet.add(v);
        }
        return result;
    }

    public Set<V> append(K key, Set<V> value) {
        Set<V> init = this.init(key);
        TreeSet<V> set = new TreeSet<V>(init);
        init.addAll(value);
        return set;
    }

    public void appendAll(Map<? extends K, ? extends Set<V>> m) {
        Set<K> keySet = m.keySet();
        for (K k : keySet) {
            Set<V> set = m.get(k);
            this.append(k, set);
        }
    }

    public boolean hasValue(K key, V value) {
        Set<V> elementSet = this.map.get(key);
        if (elementSet == null) {
            return false;
        }
        return elementSet.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, Set<V>> entry : this.entrySet()) {
            Set<V> Set2 = entry.getValue();
            if (!Set2.contains(value)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "";
        for (Map.Entry<K, Set<V>> entry : this.map.entrySet()) {
            K k = entry.getKey();
            Set<V> Set2 = entry.getValue();
            string = String.valueOf(string) + k + ":  " + Set2 + ".\n";
        }
        return string.substring(0, string.length() - 1);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<V> put(K key, Set<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Set<V>> m) {
        this.map.putAll(m);
    }

    @Override
    public Set<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Set<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, Set<V>>> entrySet() {
        return this.map.entrySet();
    }

    public static void main(String[] args) {
        ManyValuesMap<Integer, Integer> manyValuesMap = new ManyValuesMap<Integer, Integer>();
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                manyValuesMap.add(i, j * i);
                ++j;
            }
            ++i;
        }
        System.out.println("Map: ");
        System.out.println(manyValuesMap.toString());
    }
}

