/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.report;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportAttribute;
import org.tip.puck.report.ReportAttributes;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;

public class ReportTXTFile {
    private static final Logger logger = LoggerFactory.getLogger(ReportTXTFile.class);

    public static void save(File file, Report source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                ReportTXTFile.writeGeneral(out, source);
                ReportTXTFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static void write(PrintWriter out, Report source) {
        for (Object output : source.outputs()) {
            if (output == null) continue;
            if (output instanceof ReportAttributes) {
                ReportAttributes attributes = (ReportAttributes)output;
                out.println("Attribute table");
                for (ReportAttribute item : attributes) {
                    out.println(String.valueOf(item.label()) + "\t" + item.value());
                }
                out.println();
                continue;
            }
            if (output instanceof ReportChart) {
                ReportChart chart = (ReportChart)output;
                out.println("Chart: " + chart.getTitle());
                out.println();
                continue;
            }
            if (output instanceof ReportTable) {
                ReportTable table = (ReportTable)output;
                int rowIndex = 0;
                while (rowIndex < table.getRowCount()) {
                    int columnIndex = 0;
                    while (columnIndex < table.getColumnCount()) {
                        out.append("\t").append(table.getString(rowIndex, columnIndex));
                        ++columnIndex;
                    }
                    out.println();
                    ++rowIndex;
                }
                out.println();
                continue;
            }
            if (output instanceof ReportRawData) {
                ReportRawData rawData = (ReportRawData)output;
                out.println("RawData:" + rawData.getTitle());
                out.println(rawData.getData());
                out.println();
                continue;
            }
            if (output instanceof Report) {
                Report report = (Report)output;
                ReportTXTFile.write(out, report);
                out.println();
                continue;
            }
            out.println(output.toString());
            out.println();
        }
    }

    public static void writeGeneral(PrintWriter out, Report source) {
        out.println("     General information");
        out.println("Title: " + source.title());
        out.println("Origin: " + source.origin());
        out.println("Date:" + new SimpleDateFormat("dd/MM/yyyy HH':'mm").format(source.date().getTime()));
        out.println("Target: " + source.target());
        out.println("Time spent: " + source.timeSpent());
        out.println();
        out.println("     Inputs");
        out.println("Input comment: " + source.inputComment());
        out.println("Input data:");
        for (ReportAttribute item : source.inputs()) {
            out.println(String.valueOf(item.label()) + "\t" + item.value());
        }
        out.println();
        out.println();
    }
}

