/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.workers.GraphValuator;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationEnvironment;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.sequences.workers.SequenceCriteria;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;

public class RelationValuator {
    public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");

    public static String extractYear(String source) {
        Matcher matcher = YEAR_PATTERN.matcher(source);
        String result = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) : null;
        return result;
    }

    public static Value get(Relation source, String label) {
        Value result = RelationValuator.get(source, label, null);
        return result;
    }

    public static Value get(Relation source, String label, Object parameter) {
        Object result;
        EndogenousLabel endogenousLabel;
        try {
            endogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
        }
        catch (IllegalArgumentException exception) {
            endogenousLabel = null;
        }
        if (endogenousLabel == null) {
            String attributeValue = source.getAttributeValue(label);
            if (attributeValue == null) {
                result = null;
            } else if (label.toUpperCase().contains("DATE")) {
                String year = RelationValuator.extractYear(attributeValue);
                result = year == null ? null : new Value(Integer.parseInt(year));
            } else if (label.toUpperCase().equals("TIME")) {
                if (source.getAttributeValue("TIME") != null) {
                    try {
                        result = new Value(Integer.parseInt(source.getAttributeValue("TIME")));
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("time value is not an integer");
                        result = null;
                    }
                } else {
                    result = null;
                }
            } else if (label.toUpperCase().contains("PLACE")) {
                Place place;
                String level = parameter == null ? "LOCAL" : "" + parameter;
                String homonym = source.getAttributeValue(label);
                result = Geography.getInstance() != null ? ((place = Geography.getInstance().getPlace(homonym, level)) == null || place.getName() == null ? null : new Value(place.getToponym())) : new Value(attributeValue);
            } else {
                result = new Value(attributeValue);
            }
        } else {
            switch (endogenousLabel) {
                case ID: {
                    result = new Value(source.getId());
                    break;
                }
                case TYPEDID: {
                    result = new Value(source.getTypedId());
                    break;
                }
                case NRINDIVIDUALS: {
                    result = new Value(source.getIndividuals().size());
                    break;
                }
                case NRACTORS: {
                    result = new Value(source.actors().size());
                    break;
                }
                case NRROLES: {
                    result = new Value(source.actors().getRoles().size());
                    break;
                }
                case GENDER_RATIO: {
                    result = new Value(source.getIndividuals().genderRatio(Gender.FEMALE));
                    break;
                }
                case TREES: {
                    result = new Value(RelationWorker.getLinkTrees(source, true, "GENDER", (String)parameter));
                    break;
                }
                case DISTANCE: {
                    GeoLevel distance = RelationValuator.getDistance(Geography.getInstance(), source);
                    if (distance == null) {
                        result = null;
                        break;
                    }
                    result = new Value(distance);
                    break;
                }
                case DISTANCEDYNAMIC: {
                    GeoLevel distance2 = RelationValuator.getDistance(Geography.getInstance(), source);
                    if (distance2 == null) {
                        result = null;
                        break;
                    }
                    result = new Value(distance2.dynamic());
                    break;
                }
                default: {
                    result = null;
                }
            }
        }
        return result;
    }

    public static GeoLevel getDistance(Geography geography, Relation event) {
        GeoLevel result = geography.getDistance(event.getAttributeValue("START_PLACE"), event.getAttributeValue("END_PLACE"));
        return result;
    }

    public static NumberedValues getByIndividuals(Relations source, String label, Object parameter) {
        NumberedValues result = new NumberedValues();
        for (Relation relation : source) {
            for (Individual individual : relation.getIndividuals()) {
                if (result.containsKey(individual.getId())) {
                    System.err.println("Multiple relation entries for " + individual);
                }
                result.put(individual.getId(), RelationValuator.get(relation, label, parameter));
            }
        }
        return result;
    }

    public static String getEgoRolePartners(Relation relation, Individual ego, String relationModelName, String egoRoleName) {
        String result = "";
        if (relation.getModel().getName().equals(relationModelName)) {
            Individuals partners = new Individuals();
            for (Individual partner : relation.getIndividuals(egoRoleName)) {
                if (partner == ego) continue;
                partners.put(partner);
            }
            result = partners.toStringAsNameList();
        }
        return result;
    }

    public static Value get(Relation relation, Individual ego, String label, RelationEnvironment egoEnvironment) throws PuckException {
        Value result = null;
        if (label.equals("HOST")) {
            result = Value.valueOf(RelationValuator.getHostType(relation, ego, egoEnvironment.getEgoRoleName(), egoEnvironment.getRelationsByAlter()));
        } else if (label.equals("MIG")) {
            result = Value.valueOf(RelationValuator.getRelationTypesAsShortCutString(relation, ego, "MIG", egoEnvironment.getEgoRoleName(), egoEnvironment.getRelationsByAlter()));
        } else if (label.equals("HOSTMIG")) {
            result = Value.valueOf(String.valueOf(RelationValuator.getRelationTypesAsShortCutString(relation, ego, "HOST", egoEnvironment.getEgoRoleName(), egoEnvironment.getRelationsByAlter())) + ":" + RelationValuator.getRelationTypesAsShortCutString(relation, ego, "MIG", egoEnvironment.getEgoRoleName(), egoEnvironment.getRelationsByAlter()));
        } else if (label.equals("MIGRATIONTYPE")) {
            result = Value.valueOf(RelationValuator.getMigrationType(relation, ego, egoEnvironment.getEgoRoleName(), egoEnvironment.getRelationsByAlter()));
        } else if (label.equals("CHILDMIGRATIONTYPE")) {
            result = Value.valueOf(RelationValuator.getChildMigrationType(ego, relation, egoEnvironment.getEgoRoleName(), egoEnvironment.getThreshold(), egoEnvironment.getRelationsByAlter()));
        }
        return result;
    }

    public static Value get(Relation relation, Individual ego, String label, Object labelParameter, SequenceCriteria criteria) throws PuckException {
        Value result = null;
        if (labelParameter instanceof RelationEnvironment) {
            result = RelationValuator.get(relation, ego, label, (RelationEnvironment)labelParameter);
        } else if (label.equals("AGE") && ego != null) {
            result = Value.valueOf(RelationValuator.getAge(ego, relation));
        } else if (IndividualValuator.isIndividualAttributeLabel(label, relation.getIndividuals())) {
            if (IndividualValuator.isTimeDependent(label)) {
                Integer time = relation.getTime(criteria.getDateLabel());
                result = Value.valueOf(PartitionMaker.create(String.valueOf(label) + "_" + time, relation.getIndividuals(), new PartitionCriteria(label, ToolBox.asString(labelParameter))));
            } else {
                result = Value.valueOf(PartitionMaker.create(String.valueOf(label) + "_" + relation, relation.getIndividuals(), new PartitionCriteria(label, ToolBox.asString(labelParameter))));
            }
        } else if (GraphValuator.getAttributeLabels().contains(label)) {
            result = GraphValuator.get(RelationWorker.getReferentGraph(relation), label);
        } else if (label.equals("TREES_BY_ID")) {
            result = Value.valueOf(RelationWorker.getLinkTrees(relation, false, "ID", null));
        } else if (label.equals("TREES_BY_GENDER")) {
            result = Value.valueOf(RelationWorker.getLinkTrees(relation, false, "GENDER", null));
        } else if (label.equals("TREES_BY_KIN")) {
            result = Value.valueOf(RelationWorker.getLinkTrees(relation, false, "KIN", criteria.getPattern()));
        } else if (label.equals("REFERENT_CHAIN")) {
            result = Value.valueOf(RelationWorker.getReferentChainCensus(relation, criteria.getGroupAffiliationLabel()));
        } else if (label.equals("REFERENT_KIN")) {
            result = Value.valueOf(RelationWorker.getReferentKinCensus(relation, criteria.getPattern(), criteria.getGroupAffiliationLabel()));
        } else if (label.equals("PLACE")) {
            String placeValue = relation.getAttributeValue(criteria.getLocalUnitLabel());
            result = placeValue != null ? Value.valueOf(placeValue) : RelationValuator.get(relation, criteria.getPlaceLabel(), (Object)criteria.getLevel());
        } else if (label.equals("TURNOVER")) {
            result = Value.valueOf(MathUtils.round(RelationValuator.getTurnover(relation, (Relation)labelParameter, (List<String>)criteria.getRoleNames()), 2));
        } else if (label.equals("REGION")) {
            Place region = Geography.getInstance().getSup(relation.getAttributeValue("END_PLACE"), (List<String>)criteria.getMinimalPlaceNames());
            if (region != null) {
                result = Value.valueOf(region.getName());
            }
        } else if (label.contains("REFERENT")) {
            Actor actor = relation.getActor(ego, criteria.getEgoRoleName());
            if (actor != null) {
                if (label.equals("REFERENT")) {
                    result = Value.valueOf(actor.getReferent());
                } else if (label.equals("REFERENT_KIN")) {
                    result = Value.valueOf(RelationWorker.getReferentRole(actor, criteria.getPattern(), criteria.getGroupAffiliationLabel(), relation));
                } else if (label.equals("REFERENT_CHAIN")) {
                    result = Value.valueOf(RelationWorker.getReferentChainGenderString(actor, criteria.getGroupAffiliationLabel(), relation));
                } else if (label.equals("REFERENT_KIN_TYPE")) {
                    result = Value.valueOf(RelationWorker.getReferentRoleShort(actor, criteria.getPattern(), criteria.getGroupAffiliationLabel(), relation));
                } else if (label.equals("REFERENT_CHAIN_TYPE")) {
                    result = Value.valueOf(RelationWorker.getReferentChainNumber(actor, relation));
                }
            }
        } else {
            result = RelationValuator.get(relation, label, labelParameter);
        }
        return result;
    }

    public static NumberedValues get(Relations source, String label) {
        NumberedValues result = RelationValuator.get(source, label, null);
        return result;
    }

    public static NumberedValues get(Relations source, String label, Object parameter) {
        NumberedValues result = new NumberedValues();
        for (Relation relation : source) {
            result.put(relation.getId(), RelationValuator.get(relation, label, parameter));
        }
        return result;
    }

    public static List<String> getAttributeLabels(Relations source) {
        List<String> result = RelationValuator.getAttributeLabels(source, null);
        return result;
    }

    public static List<String> getAttributeLabels(Relations source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        EndogenousLabel[] endogenousLabelArray = EndogenousLabel.values();
        int n = endogenousLabelArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndogenousLabel label = endogenousLabelArray[n2];
            result.add(label.toString());
            ++n2;
        }
        result.addAll(RelationValuator.getExogenousAttributeLabels(source, limit));
        Collections.sort(result);
        return result;
    }

    public static List<String> getAttributeLabelSample(Relations source) {
        List<String> result = RelationValuator.getAttributeLabels(source, 10000);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Relations source) {
        List<String> result = RelationValuator.getExogenousAttributeLabels(source, null);
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Relations source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        HashSet<String> buffer = new HashSet<String>();
        if (source != null) {
            int index = 0;
            Iterator iterator = source.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Relation relation = (Relation)iterator.next();
                for (Attribute attribute : relation.attributes()) {
                    buffer.add(attribute.getLabel());
                }
            }
        }
        for (String string : buffer) {
            result.add(string);
        }
        Collections.sort(result);
        return result;
    }

    public static boolean isBirth(Object source) {
        boolean result = !(source instanceof Attributable) ? false : ((Attributable)source).getAttributeValue("END_PLACE") != null && ((Attributable)source).getAttributeValue("START_PLACE") == null;
        return result;
    }

    public static boolean isDeath(Object source) {
        boolean result = !(source instanceof Attributable) ? false : ((Attributable)source).getAttributeValue("END_PLACE") == null && ((Attributable)source).getAttributeValue("START_PLACE") != null;
        return result;
    }

    private static String getHostType(Relation event, Individual ego, String egoRoleName, Map<Individual, List<String>> relationsByAlter) {
        String result;
        ArrayList<String> hosts = new ArrayList<String>();
        List<String> allhosts = RelationValuator.reduceRelations(RelationValuator.getRelationTypes(event, ego, "HOST", egoRoleName, "UNKNOWN", relationsByAlter), "HOST");
        for (String host : allhosts) {
            boolean consider = true;
            if (host.contains("FRIEND")) {
                for (String otherhost : allhosts) {
                    if (otherhost.contains("FRIEND")) continue;
                    consider = false;
                    break;
                }
                if (!consider) continue;
            }
            hosts.add(host);
        }
        if (RelationValuator.isBirth(event)) {
            result = "PARENTS";
        } else if (RelationValuator.isDeath(event)) {
            result = "DEATH";
        } else if (hosts.size() == 0) {
            result = "UNKNOWN";
            System.err.println(String.valueOf(result) + " " + event);
        } else if (hosts.contains("TRANSITION")) {
            result = "TRANSITION";
        } else if (PuckUtils.containsStrings(hosts, "FATHER OR PATERNAL HOME;MOTHER OR MATERNAL HOME")) {
            result = "PARENTS";
        } else if (PuckUtils.containsStrings(hosts, "SIBLING OR FRATERNAL HOME")) {
            result = "RELATIVE";
        } else if (PuckUtils.containsStrings(hosts, "SPOUSE OR MARITAL HOME")) {
            result = "SPOUSE";
        } else if (PuckUtils.containsStrings(hosts, "CHILD OR FILIAL HOME")) {
            result = "CHILD";
        } else if (PuckUtils.containsStrings(hosts, "RELATIVE;RELATIVE_AGNATIC;RELATIVE_UTERINE;RELATIVE_COGNATIC;RELATIVE_OR_AFFINE")) {
            result = "RELATIVE";
        } else if (hosts.contains("AFFINE")) {
            result = "AFFINE";
        } else if (hosts.contains("LANDLORD")) {
            result = "RENT";
        } else if (hosts.contains("UNRELATED")) {
            result = "UNRELATED";
        } else if (hosts.contains("HOTEL-HOSTEL") || hosts.contains("WITHOUT FIXED DOMICILE")) {
            result = "PUBLIC";
        } else {
            result = "";
            for (String host : hosts) {
                if ((host = host.replaceAll("RELATIVE_OR_AFFINE", "RELATIVE").replaceAll("SIBLING", "RELATIVE").replaceAll("FATHER", "PARENTS").replaceAll("MOTHER", "PARENTS")).equals("RELATIVES_MARITAL HOME")) {
                    result = "AFFINE";
                } else if (host.equals("SPOUSES_PATERNAL HOME")) {
                    result = "SPOUSE";
                } else if (host.equals("SPOUSES_MARITAL HOME")) {
                    result = "PARENTS";
                } else {
                    String[] hostParts = host.split("S_");
                    if (hostParts.length > 1) {
                        host = "via " + hostParts[0];
                    }
                    result = String.valueOf(result) + host + " ";
                }
                if (result.contains("via PARENTS")) {
                    result = "via PARENTS";
                    continue;
                }
                if (result.contains("via SPOUSE")) {
                    result = "via SPOUSE";
                    continue;
                }
                if (result.contains("via RELATIVE")) {
                    result = "via RELATIVE";
                    continue;
                }
                if (result.contains("via MASTER")) {
                    result = "via MASTER";
                    continue;
                }
                if (result.lastIndexOf("via") <= 0) continue;
                System.err.println("double reference " + result);
            }
            if (result.contains("null")) {
                result = "UNKNOWN";
                System.err.println(String.valueOf(result) + " " + event);
            }
        }
        if (result.contains("LODGER")) {
            System.err.println("Inverted landlord-lodger relation for " + event);
        }
        result = result.trim();
        return result;
    }

    private static String getMigrationType(Relation event, Individual ego, String egoRoleName, Map<Individual, List<String>> relationsByAlter) {
        String result;
        List<String> hosts = RelationValuator.getRelationTypes(event, ego, "HOST", egoRoleName, "UNKNOWN", relationsByAlter);
        List<String> migs = RelationValuator.getRelationTypes(event, ego, "MIG", egoRoleName, "UNKNOWN", relationsByAlter);
        if (RelationValuator.isBirth(event)) {
            result = "BIRTH";
        } else if (RelationValuator.isDeath(event)) {
            result = "DEATH";
        } else {
            int n;
            String hostType = "OTHER";
            if (hosts.size() == 0) {
                hostType = "NOBODY";
            } else {
                String[] types = new String[]{"EGO", "FATHER", "MOTHER", "SPOUSE", "CHILD", "SIBLING"};
                boolean end = false;
                String[] stringArray = types;
                n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    if (hosts.contains(type)) {
                        hostType = type;
                        end = true;
                        break;
                    }
                    ++n2;
                }
                if (!end && (hosts.contains("RELATIVE_AGNATIC") || hosts.contains("RELATIVE_UTERINE") || hosts.contains("RELATIVE_COGNATIC") || hosts.contains("RELATIVE"))) {
                    hostType = "KIN";
                } else if (!end && hosts.contains("AFFINE")) {
                    hostType = "AFFINE";
                }
            }
            String migType = "OTHER";
            if (migs.size() == 0) {
                migType = "NOBODY";
            } else {
                String[] types = new String[]{"EGO", "FATHER", "MOTHER", "SPOUSE", "CHILD", "SIBLING"};
                boolean end = false;
                String[] stringArray = types;
                int n3 = types.length;
                n = 0;
                while (n < n3) {
                    String type = stringArray[n];
                    if (migs.contains(type)) {
                        migType = type;
                        end = true;
                        break;
                    }
                    ++n;
                }
                if (!end && (migs.contains("RELATIVE_AGNATIC") || migs.contains("RELATIVE_UTERINE") || migs.contains("RELATIVE_COGNATIC") || migs.contains("RELATIVE"))) {
                    migType = "KIN";
                } else if (!end && migs.contains("AFFINE")) {
                    migType = "AFFINE";
                }
            }
            result = "WITH_" + migType + "_TO_" + hostType;
            result = result.replaceAll("WITH_NOBODY", "ALONE");
        }
        return result;
    }

    private static List<String> getRelationTypes(Individuals alters, String roleName, Map<Individual, List<String>> relationsByAlter) {
        ArrayList<String> result = new ArrayList<String>();
        for (Individual alter : alters) {
            List<String> relations = relationsByAlter.get(alter);
            if (relations == null) continue;
            for (String relation : relations) {
                if (result.contains(relation)) continue;
                result.add(relation);
            }
        }
        Collections.sort(result);
        return result;
    }

    private static List<String> getRelationTypes(Relation event, Individual ego, String roleName, String egoRoleName, String impersonalLabel, Map<Individual, List<String>> relationsByAlter) {
        Individuals alters = event.getIndividuals(roleName);
        if (roleName.equals("MIG")) {
            alters.removeById(ego.getId());
        }
        List<String> result = RelationValuator.getRelationTypes(alters, roleName, relationsByAlter);
        if (alters.size() == 0) {
            Actor egoActor = event.actors().get(ego.getId(), egoRoleName);
            if (egoActor.attributes() != null && egoActor.getAttributeValue(impersonalLabel) != null) {
                result.add(egoActor.getAttributeValue(impersonalLabel));
            } else {
                for (Actor alterActor : event.actors().getByRole(egoRoleName)) {
                    List<String> relations;
                    String relation;
                    if (alterActor == null || alterActor.equals(egoActor) || alterActor.attributes() == null || (relation = alterActor.getAttributeValue(impersonalLabel)) == null || (relations = relationsByAlter.get(alterActor.getIndividual())) == null) continue;
                    for (String egoRelation : relations) {
                        if (result.contains(egoRelation = String.valueOf(egoRelation) + "S_" + relation)) continue;
                        result.add(egoRelation);
                    }
                }
            }
        }
        return result;
    }

    private static String getChildMigrationType(Individual ego, Relation event, String egoRoleName, Integer threshold, Map<Individual, List<String>> relationsByAlter) {
        List<String> hosts = RelationValuator.getRelationTypes(event, ego, "HOST", egoRoleName, "UNKNOWN", relationsByAlter);
        List<String> migs = RelationValuator.getRelationTypes(event, ego, "MIG", egoRoleName, "UNKNOWN", relationsByAlter);
        String result = null;
        if (RelationValuator.isBirth(event)) {
            result = "BIRTH";
        } else if (!(RelationValuator.getAge(ego, event) > threshold || hosts.contains("FATHER") || hosts.contains("MOTHER") || migs.contains("FATHER") || migs.contains("MOTHER"))) {
            result = "NOPARENTS";
        }
        return result;
    }

    private static Double getTurnover(Relation event, Relation previousEvent, List<String> roleNames) {
        Double result = 0.0;
        if (previousEvent != null) {
            Individuals previousAlters = previousEvent.getIndividuals(roleNames);
            Individuals currentAlters = event.getIndividuals(roleNames);
            Double n = new Double(previousAlters.size());
            for (Individual individual : previousAlters) {
                if (!currentAlters.contains(individual)) continue;
                result = result + 1.0;
            }
            result = result / n;
        }
        return result;
    }

    public static Integer getAge(Individual ego, Relation event) {
        Integer result = null;
        if (event != null && RelationValuator.getYear(event) != null) {
            result = IndividualValuator.ageAtYear(ego, RelationValuator.getYear(event));
        }
        return result;
    }

    public static Integer getYear(Relation event) {
        Integer result = null;
        if (event != null) {
            result = IndividualValuator.extractYearAsInt(event.getAttributeValue("DATE"));
        }
        return result;
    }

    private static String getRelationTypesAsShortCutString(Relation event, Individual ego, String roleName, String egoRoleName, Map<Individual, List<String>> relationsByAlters) {
        String result = Trafo.asShortCutString(RelationValuator.getRelationTypes(event, ego, roleName, egoRoleName, "UNKNOWN", relationsByAlters), 2);
        if (result == null && roleName.equals("MIG")) {
            result = "SG";
        }
        return result;
    }

    public static List<String> reduceRelations(List<String> relations, String alterRole) {
        ArrayList<String> result = new ArrayList<String>();
        for (String relation : relations) {
            String reducedRelation = null;
            reducedRelation = relation.equals("EGO") ? "OWN HOME" : (alterRole.equals("HOST") && relation.equals("FATHER") || relation.equals("PATERNAL HOME") ? "FATHER OR PATERNAL HOME" : (alterRole.equals("HOST") && relation.equals("CHILD") || relation.equals("FILIAL HOME") ? "CHILD OR FILIAL HOME" : (alterRole.equals("HOST") && relation.equals("MOTHER") || relation.equals("MATERNAL HOME") ? "MOTHER OR MATERNAL HOME" : (alterRole.equals("HOST") && relation.equals("SIBLING") || relation.equals("FRATERNAL HOME") ? "SIBLING OR FRATERNAL HOME" : (alterRole.equals("HOST") && relation.equals("SPOUSE") || relation.equals("MARITAL HOME") ? "SPOUSE OR MARITAL HOME" : (relation.equals("STATE") || relation.equals("NGO") ? "STATE OR NGO" : (relation.equals("WORKPLACE") || relation.equals("HOMELESS") ? "WITHOUT FIXED DOMICILE" : (relation.equals("FRIEND") || relation.equals("EMPLOYERS_EMPLOYEE") || relation.equals("LANDLORDS_LODGER") || relation.equals("MASTERS_APPRENTICE") || relation.equals("FRIENDS_FRIEND") ? "FRIEND OR COLLEGUE" : (relation.contains("UNRELATEDS_") ? "UNRELATED" : (relation.contains("S_") ? relation.replaceAll("_AGNATIC", "").replaceAll("_UTERINE", "").replaceAll("_COGNATIC", "").replaceAll("RELATIVE", "RELATIVE_OR_AFFINE") : relation))))))))));
            if (result.contains(reducedRelation = RelationValuator.reduceRelation(reducedRelation))) continue;
            result.add(reducedRelation);
        }
        return result;
    }

    private static String reduceRelation(String relation) {
        String result = null;
        if (relation.equals("FATHER OR PATERNAL HOME") || relation.equals("MOTHER OR MATERNAL HOME")) {
            result = "PARENTS";
        } else if (relation.equals("SPOUSE OR MARITAL HOME")) {
            result = "SPOUSE";
        } else if (relation.equals("CHILD OR FILIAL HOME")) {
            result = "CHILD";
        } else if (relation.equals("LANDLORD")) {
            result = "RENT";
        } else if (relation.equals("HOTEL-HOSTEL") || relation.equals("WITHOUT FIXED DOMICILE")) {
            result = "PUBLIC";
        } else {
            result = relation.replaceAll("RELATIVE_OR_AFFINE", "RELATIVE").replaceAll("FATHER", "PARENTS").replaceAll("MOTHER", "PARENTS");
            if (result.equals("RELATIVES_MARITAL HOME")) {
                result = "AFFINE";
            } else if (result.equals("SIBLINGS_MARITAL HOME")) {
                result = "AFFINE";
            } else if (result.equals("SPOUSES_PATERNAL HOME")) {
                result = "SPOUSE";
            } else if (result.equals("SPOUSES_MARITAL HOME")) {
                result = "PARENTS";
            } else {
                String[] relationParts = result.split("S_");
                if (relationParts.length > 1) {
                    result = "via " + relationParts[0];
                    if (result.contains("via PARENTS")) {
                        result = "via PARENTS";
                    } else if (result.contains("via SPOUSE")) {
                        result = "via SPOUSE";
                    } else if (result.contains("via SIBLING")) {
                        result = "via SIBLING";
                    } else if (result.contains("via RELATIVE")) {
                        result = "via RELATIVE";
                    } else if (result.contains("via MASTER")) {
                        result = "via MASTER";
                    } else if (result.lastIndexOf("via") > 0) {
                        System.err.println("double reference " + result);
                    }
                }
            }
        }
        return result;
    }

    public static enum EndogenousLabel {
        ID,
        TYPEDID,
        DISTANCE,
        DISTANCEDYNAMIC,
        NRINDIVIDUALS,
        NRACTORS,
        NRROLES,
        GENDER_RATIO,
        TURNOVER,
        HOST,
        MIG,
        HOSTMIG,
        MIGRATIONTYPE,
        CHILDMIGRATIONTYPE,
        TREES,
        REGION,
        AGE;

    }
}

