/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.txt;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.BARIURDetector;
import org.tip.puck.io.bar.BARTXTFile;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.net.Net;
import org.tip.puck.util.PuckUtils;

public class TXTFile {
    private static final Logger logger = LoggerFactory.getLogger(TXTFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    public static Net load(File file) throws PuckException {
        Net result = TXTFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BARIURDetector.Format format = BARIURDetector.detectFormat(file);
        switch (format) {
            case BAR: {
                result = BARTXTFile.load(file, DEFAULT_CHARSET_NAME);
                break;
            }
            case IUR: {
                result = IURTXTFile.load(file, DEFAULT_CHARSET_NAME);
                break;
            }
            case CONFLICTING: {
                throw PuckExceptions.FORMAT_CONFLICT.create();
            }
            case UNKNOWN: {
                throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown format.", new Object[0]);
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static List<StringList> readLineBlocks(File file, String charsetName) {
        List<StringList> result;
        block5: {
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                    result = PuckUtils.readLineBlocks(in);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    result = null;
                    IOUtils.closeQuietly(in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }

    public static StringList readLines(File file, String charsetName) {
        StringList result;
        block5: {
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                    result = PuckUtils.readLines(in);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    result = null;
                    IOUtils.closeQuietly(in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        IURTXTFile.save(file, source);
    }
}

