/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.evo;

import java.util.Collections;
import java.util.Vector;
import org.tip.puck.evo.EvoGen;
import org.tip.puck.evo.Generator;
import org.tip.puck.evo.PopGenerator;
import org.tip.puck.util.RandomGenerator;

public class EvoStrategy
implements PopGenerator {
    private int parents;
    private int mixing;
    private int children;

    public EvoStrategy(int parents, int mixing, int children) {
        this.parents = parents;
        this.mixing = mixing;
        this.children = parents;
    }

    @Override
    public int popSize() {
        return this.parents + this.children;
    }

    @Override
    public Vector<Generator> newGeneration(EvoGen evo) {
        Collections.shuffle(evo.population);
        Collections.sort(evo.population);
        Vector<Generator> newPopulation = new Vector<Generator>();
        int i = 0;
        while (i < this.parents) {
            newPopulation.add((Generator)evo.population.get(i));
            ++i;
        }
        i = 0;
        while (i < this.children) {
            Generator child2;
            Generator parent = this.selectParent(evo);
            Generator child = parent.cloneProgs();
            int j = 1;
            while (j < this.mixing) {
                parent = this.selectParent(evo);
                child = child2 = child.recombine(parent);
                ++j;
            }
            parent = child.clone();
            parent.initProgsRandom();
            child = child2 = child.recombine(parent);
            newPopulation.add(child);
            ++i;
        }
        return newPopulation;
    }

    private Generator selectParent(EvoGen evo) {
        int index = RandomGenerator.instance().random.nextInt(this.parents);
        return evo.getPopulation().get(index);
    }

    @Override
    public String infoString() {
        String str = "";
        str = String.valueOf(str) + "search algorithm: evolutionary strategy\n";
        str = String.valueOf(str) + "parents: " + this.parents + "\n";
        str = String.valueOf(str) + "mixing: " + this.mixing + "\n";
        return str;
    }
}

