/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.kinoath;

import java.awt.Component;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.util.GenericFileFilter;

public class KinOathExportFileSelector
extends JFileChooser {
    private static final long serialVersionUID = -7786124373871130820L;
    private static final Logger logger = LoggerFactory.getLogger(KinOathExportFileSelector.class);
    private File currentFile = null;

    public KinOathExportFileSelector(File targetFile) {
        this.setSelectedFile(targetFile);
        this.setDialogTitle("Export kin diagram");
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Export");
        this.setDialogType(2);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Diagram files (*.pdf, *.png, *.svg)", "pdf", "png", "svg");
        this.addChoosableFileFilter(defaultFileFilter);
        this.addChoosableFileFilter(new GenericFileFilter("Portable Document Format (*.pdf)", "pdf"));
        this.addChoosableFileFilter(new GenericFileFilter("Portable Network Graphics (*.png)", "png"));
        this.addChoosableFileFilter(new GenericFileFilter("Scalable Vector Graphics (*.svg)", "svg"));
        this.setFileFilter(defaultFileFilter);
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (!StringUtils.endsWithAny((CharSequence)ToolBox.getExtension(file), (CharSequence[])new CharSequence[]{"svg", "pdf", "png"})) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".svg");
            this.setSelectedFile(file);
        }
        if (file.exists()) {
            String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
            int response = JOptionPane.showConfirmDialog(this, message, title, 1);
            if (response == 0) {
                super.approveSelection();
            } else if (response != 1) {
                super.cancelSelection();
            }
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        System.out.println("==== SET SELECTED FILE=================");
        System.out.println("SELECED FILE " + file);
        if (file != null) {
            this.currentFile = file;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.resetChoosableFileFilters();
        }
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        KinOathExportFileSelector selector = new KinOathExportFileSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

