/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapPane;
import org.geotools.swing.action.InfoAction;
import org.geotools.swing.action.PanAction;
import org.geotools.swing.action.ZoomInAction;
import org.geotools.swing.action.ZoomOutAction;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.styling.JSimpleStyleDialog;
import org.geotools.swing.tool.ZoomInTool;
import org.geotools.swing.tool.ZoomOutTool;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.tip.puck.geo.tools.GeotoolsUtils;
import org.tip.puck.geo2.Place2;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.gis.SIGFile;
import org.tip.puckgui.util.GenericFileFilter;

public class MapPanel
extends JPanel {
    private static final long serialVersionUID = -2451122245332109771L;
    StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory();
    public MapContent mapContent = new MapContent();
    private JTable tablePoints;
    private JTable tableLinks;
    JList listLayers = null;
    DefaultListModel listModel = new DefaultListModel();
    public double lastDraggedX = 0.0;
    public double lastDraggedY = 0.0;
    public double initialXClicked = 0.0;
    public double initialYClicked = 0.0;
    public boolean firstClickOnDrag = false;
    Tools selectedTool = Tools.DRAG;
    List<JToggleButton> listToggleButtons = new ArrayList<JToggleButton>();
    ZoomInTool zit = new ZoomInTool();
    ZoomOutTool zot = new ZoomOutTool();
    String labelGraph = "";
    JLabel lblPathToLayers;
    JLabel lblAvailableLayers;
    JTabbedPane tabbedPane;
    JScrollPane pTablLinesGeoView;
    JScrollPane pTablPointsGeoView;

    public MapPanel(Graph<Place2> source) {
        this.setLayout(new BorderLayout(0, 0));
        final JMapPane mapPane = new JMapPane();
        ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed = GeotoolsUtils.getFeaturesForNodesPlaces(source);
        this.labelGraph = source.getLabel();
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        JPanel pMap = new JPanel();
        this.tabbedPane.addTab("Viewer", null, pMap, null);
        pMap.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        pMap.add(splitPane);
        JPanel panelRightMap = new JPanel();
        splitPane.setRightComponent(panelRightMap);
        panelRightMap.setLayout(new BorderLayout(0, 0));
        JMenuBar menuBarMap = new JMenuBar();
        panelRightMap.add((Component)menuBarMap, "North");
        final JToggleButton tglbtnDrag = new JToggleButton((Action)new PanAction((MapPane)mapPane));
        this.listToggleButtons.add(tglbtnDrag);
        tglbtnDrag.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionPan.png")));
        tglbtnDrag.setSelectedIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionPan_selected.png")));
        menuBarMap.add(tglbtnDrag);
        tglbtnDrag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.selectedTool = Tools.DRAG;
                MapPanel.this.unselectToggleButtonsExcept(tglbtnDrag);
            }
        });
        final JToggleButton tglbtnSelect = new JToggleButton((Action)new InfoAction((MapPane)mapPane));
        this.listToggleButtons.add(tglbtnSelect);
        tglbtnSelect.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionSelect.png")));
        tglbtnSelect.setSelectedIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionSelect_selected.png")));
        menuBarMap.add(tglbtnSelect);
        tglbtnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.selectedTool = Tools.SELECT;
                MapPanel.this.unselectToggleButtonsExcept(tglbtnSelect);
            }
        });
        final JToggleButton tglbtnZoomIn = new JToggleButton((Action)new ZoomInAction((MapPane)mapPane));
        this.listToggleButtons.add(tglbtnZoomIn);
        tglbtnZoomIn.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomIn.png")));
        tglbtnZoomIn.setSelectedIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomIn_selected.png")));
        menuBarMap.add(tglbtnZoomIn);
        tglbtnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.selectedTool = Tools.ZOOMIN;
                MapPanel.this.unselectToggleButtonsExcept(tglbtnZoomIn);
            }
        });
        final JToggleButton tglbtnZoomOut = new JToggleButton((Action)new ZoomOutAction((MapPane)mapPane));
        this.listToggleButtons.add(tglbtnZoomOut);
        tglbtnZoomOut.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomOut.png")));
        tglbtnZoomOut.setSelectedIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomOut_selected.png")));
        menuBarMap.add(tglbtnZoomOut);
        tglbtnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.selectedTool = Tools.ZOOMOUT;
                MapPanel.this.unselectToggleButtonsExcept(tglbtnZoomOut);
            }
        });
        JButton tglbtnCenterView = new JButton("");
        tglbtnCenterView.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mActionZoomFullExtent.png")));
        menuBarMap.add(tglbtnCenterView);
        tglbtnCenterView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReferencedEnvelope env = MapPanel.this.maximiseBoundsForLayers();
                mapPane.setDisplayArea((Envelope)env);
                mapPane.repaint();
            }
        });
        JButton btExportShapefile = new JButton("");
        btExportShapefile.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mSaveShapefile.png")));
        menuBarMap.add(btExportShapefile);
        btExportShapefile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.prepareExportShapeFile();
            }
        });
        JButton btExportSVG = new JButton("");
        btExportSVG.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mSaveSVG.png")));
        menuBarMap.add(btExportSVG);
        btExportSVG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapPanel.this.prepareExportSVG();
            }
        });
        JLabel statusBar = new JLabel("Status bar");
        panelRightMap.add((Component)statusBar, "South");
        mapPane.addMouseListener(new MapMouseListener(){

            public void onMouseWheelMoved(MapMouseEvent arg0) {
            }

            public void onMouseReleased(MapMouseEvent arg0) {
                MapPanel.this.firstClickOnDrag = false;
            }

            public void onMousePressed(MapMouseEvent arg0) {
            }

            public void onMouseMoved(MapMouseEvent arg0) {
            }

            public void onMouseExited(MapMouseEvent arg0) {
            }

            public void onMouseEntered(MapMouseEvent arg0) {
            }

            public void onMouseDragged(MapMouseEvent ev) {
                DirectPosition2D pos = ev.getWorldPos();
                Coordinate coord = new Coordinate(pos.x, pos.y);
                ReferencedEnvelope env = mapPane.getDisplayArea();
                if (!MapPanel.this.firstClickOnDrag) {
                    MapPanel.this.initialXClicked = pos.x;
                    MapPanel.this.initialYClicked = pos.y;
                    MapPanel.this.firstClickOnDrag = true;
                }
            }

            public void onMouseClicked(MapMouseEvent ev) {
                DirectPosition2D pos = ev.getWorldPos();
                Coordinate coord = new Coordinate(pos.x, pos.y);
                ReferencedEnvelope env = mapPane.getDisplayArea();
                block0 : switch (ev.getButton()) {
                    case 1: {
                        switch (MapPanel.this.selectedTool) {
                            case DRAG: {
                                env = MapPanel.this.centerOn(env, coord);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        env = MapPanel.this.centerOn(env, coord);
                        break;
                    }
                }
                MapPanel.this.lastDraggedX = pos.x;
                MapPanel.this.lastDraggedY = pos.y;
                MapPanel.this.initialXClicked = pos.x;
                MapPanel.this.initialYClicked = pos.y;
                mapPane.setDisplayArea((Envelope)env);
                mapPane.repaint();
            }
        });
        mapPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent arg0) {
                ReferencedEnvelope env = mapPane.getDisplayArea();
                double clickToZoom = 0.03;
                int clicks = arg0.getWheelRotation();
                int sign = clicks < 0 ? -1 : 1;
                double width = env.getWidth();
                double delta = width * clickToZoom * (double)sign;
                env.expandBy(delta, delta);
                mapPane.setDisplayArea((Envelope)env);
                mapPane.repaint();
            }
        });
        panelRightMap.add((Component)mapPane, "Center");
        JPanel panelLeftList = new JPanel();
        splitPane.setLeftComponent(panelLeftList);
        panelLeftList.setLayout(new BorderLayout(0, 0));
        JMenuBar menuBarLayers = new JMenuBar();
        panelLeftList.add((Component)menuBarLayers, "North");
        JButton btnAddShapeLayer = new JButton("");
        btnAddShapeLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser inFileDlg = new JFileChooser("user.dir");
                inFileDlg.setFileFilter(new FileNameExtensionFilter("Shapefile (*.shp)", "shp"));
                int returnVal = inFileDlg.showOpenDialog(MapPanel.this);
                if (returnVal == 0) {
                    String browseDir = inFileDlg.getCurrentDirectory().toString();
                    String inFile = null;
                    inFile = inFileDlg.getSelectedFile().toString();
                    inFileDlg.setCurrentDirectory(new File(inFile));
                    try {
                        MapPanel.this.displaysShapefile(new File(inFile));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
        btnAddShapeLayer.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
        menuBarLayers.add(btnAddShapeLayer);
        JButton btnRemoveShapeLayer = new JButton("");
        btnRemoveShapeLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel.this.listLayers.getSelectedValue();
                Layer selectedLayer = null;
                for (Layer iterLayer : MapPanel.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) != 0) continue;
                    selectedLayer = iterLayer;
                    break;
                }
                MapPanel.this.mapContent.removeLayer(selectedLayer);
                MapPanel.this.listModel.removeElement(selectedLayerTitle);
                mapPane.repaint();
            }
        });
        btnRemoveShapeLayer.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
        menuBarLayers.add(btnRemoveShapeLayer);
        JButton btnLayerProperties = new JButton("");
        btnLayerProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel.this.listLayers.getSelectedValue();
                Layer selectedLayer = null;
                for (Layer iterLayer : MapPanel.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) != 0) continue;
                    selectedLayer = iterLayer;
                    break;
                }
                if (selectedLayer != null) {
                    Style newStyle = JSimpleStyleDialog.showDialog(null, (SimpleFeatureType)((SimpleFeatureType)selectedLayer.getFeatureSource().getSchema()));
                    ((FeatureLayer)selectedLayer).setStyle(newStyle);
                    mapPane.repaint();
                }
            }
        });
        btnLayerProperties.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/gis/mParametersLayer.png")));
        menuBarLayers.add(btnLayerProperties);
        JButton btnLayerUp = new JButton("");
        btnLayerUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel.this.listLayers.getSelectedValue();
                int selectedIndex = MapPanel.this.listLayers.getSelectedIndex();
                Layer selectedLayer = null;
                int count = 0;
                for (Layer iterLayer : MapPanel.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
                        selectedLayer = iterLayer;
                        break;
                    }
                    ++count;
                }
                int newPosition = count + 1;
                System.out.println(MapPanel.this.mapContent.layers().size());
                System.out.println(MapPanel.this.listModel.getSize());
                if (newPosition < MapPanel.this.listModel.getSize()) {
                    MapPanel.this.mapContent.moveLayer(count, newPosition);
                    MapPanel.this.listModel.remove(selectedIndex);
                    if (selectedIndex - 1 < 0) {
                        selectedIndex = 0;
                    }
                    MapPanel.this.listModel.insertElementAt(selectedLayerTitle, selectedIndex - 1);
                    MapPanel.this.listLayers.setSelectedIndex(selectedIndex - 1);
                    mapPane.repaint();
                }
            }
        });
        btnLayerUp.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/up-16x16.png")));
        menuBarLayers.add(btnLayerUp);
        JButton btnLayerDown = new JButton("");
        btnLayerDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String selectedLayerTitle = (String)MapPanel.this.listLayers.getSelectedValue();
                int selectedIndex = MapPanel.this.listLayers.getSelectedIndex();
                Layer selectedLayer = null;
                int count = 0;
                for (Layer iterLayer : MapPanel.this.mapContent.layers()) {
                    if (iterLayer.getTitle().compareTo(selectedLayerTitle) == 0) {
                        selectedLayer = iterLayer;
                        break;
                    }
                    ++count;
                }
                int newPosition = count - 1;
                if (newPosition > -1) {
                    MapPanel.this.mapContent.moveLayer(count, newPosition);
                    MapPanel.this.listModel.remove(selectedIndex);
                    if (selectedIndex + 1 > MapPanel.this.listModel.getSize()) {
                        selectedIndex = MapPanel.this.listModel.getSize() - 1;
                    }
                    MapPanel.this.listModel.insertElementAt(selectedLayerTitle, selectedIndex + 1);
                    mapPane.repaint();
                    MapPanel.this.listLayers.setSelectedIndex(selectedIndex + 1);
                }
            }
        });
        btnLayerDown.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/down-16x16.png")));
        menuBarLayers.add(btnLayerDown);
        this.listLayers = new JList(this.listModel);
        panelLeftList.add((Component)this.listLayers, "Center");
        JPanel pInformation = new JPanel();
        this.tabbedPane.addTab("Layers Information", null, pInformation, null);
        pInformation.setLayout(null);
        JLabel lblCartoTypeFixed = new JLabel("Cartography type :");
        lblCartoTypeFixed.setBounds(12, 39, 143, 15);
        pInformation.add(lblCartoTypeFixed);
        JLabel lblAvailableLayersFixed = new JLabel("Available layers :");
        lblAvailableLayersFixed.setBounds(12, 66, 155, 15);
        pInformation.add(lblAvailableLayersFixed);
        JLabel lblCorpusNameFixed = new JLabel("Corpus Name :");
        lblCorpusNameFixed.setBounds(12, 12, 117, 15);
        pInformation.add(lblCorpusNameFixed);
        JLabel lblDateFixed = new JLabel("Date :");
        lblDateFixed.setBounds(12, 93, 66, 15);
        pInformation.add(lblDateFixed);
        JLabel lblSavedLayersFixed = new JLabel("Layers saved at :");
        lblSavedLayersFixed.setBounds(12, 120, 117, 15);
        pInformation.add(lblSavedLayersFixed);
        JLabel lblCorpus = new JLabel(this.labelGraph.substring(0, this.labelGraph.lastIndexOf(".")));
        lblCorpus.setBounds(200, 12, 500, 15);
        pInformation.add(lblCorpus);
        JLabel lblCartoType = new JLabel(this.labelGraph.substring(this.labelGraph.lastIndexOf(".") + 5));
        lblCartoType.setBounds(200, 39, 500, 15);
        pInformation.add(lblCartoType);
        this.lblAvailableLayers = new JLabel("ListOfLayers");
        this.lblAvailableLayers.setBounds(200, 66, 500, 15);
        pInformation.add(this.lblAvailableLayers);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date date = new Date();
        System.out.println(dateFormat.format(date));
        JLabel lblDate = new JLabel(dateFormat.format(date));
        lblDate.setBounds(200, 93, 300, 15);
        pInformation.add(lblDate);
        this.lblPathToLayers = new JLabel("/path/to/layers");
        this.lblPathToLayers.setBounds(200, 120, 500, 15);
        pInformation.add(this.lblPathToLayers);
        JLabel lblSCRFixed = new JLabel("SCR :");
        lblSCRFixed.setBounds(12, 147, 66, 15);
        pInformation.add(lblSCRFixed);
        JLabel lblSCR = new JLabel("WGS84 - (4326)");
        lblSCR.setBounds(200, 147, 117, 15);
        pInformation.add(lblSCR);
        mapPane.setRenderer((GTRenderer)new StreamingRenderer());
        mapPane.setMapContent(this.mapContent);
        this.pTablPointsGeoView = new JScrollPane();
        this.tabbedPane.addTab("Attributes table points", null, this.pTablPointsGeoView, null);
        this.pTablLinesGeoView = new JScrollPane();
        this.tabbedPane.addTab("Attributes table links", null, this.pTablLinesGeoView, null);
        JMenuBar menuBarPoints = new JMenuBar();
        JMenuBar menuBarLinks = new JMenuBar();
        this.pTablPointsGeoView.add(menuBarPoints);
        this.pTablLinesGeoView.add(menuBarLinks);
        JButton btnAddPoint = new JButton("");
        btnAddPoint.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
        menuBarPoints.add(btnAddPoint);
        JButton btnDelPoint = new JButton("");
        btnDelPoint.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
        menuBarPoints.add(btnDelPoint);
        JButton btnAddLinks = new JButton("");
        btnAddLinks.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/add-16x16.png")));
        menuBarLinks.add(btnAddLinks);
        JButton btnDelLinks = new JButton("");
        btnDelLinks.setIcon(new ImageIcon(MapPanel.class.getResource("/org/tip/puckgui/images/remove-16x16.png")));
        menuBarLinks.add(btnDelLinks);
        this.tablePoints = new JTable();
        this.tablePoints.setSelectionMode(2);
        Object[] colNameNodes = this.labelGraph.contains("Net Places") || this.labelGraph.contains("Net_Places") ? new String[]{"id_geonames", "Toponym", "Country", "Long", "Lat", "Weight"} : new String[]{"id_geonames", "Toponym", "Country", "Long", "Lat"};
        DefaultTableModel modelAttributesTablePoints = (DefaultTableModel)this.tablePoints.getModel();
        modelAttributesTablePoints.setColumnIdentifiers(colNameNodes);
        this.tablePoints.setModel(modelAttributesTablePoints);
        this.tableLinks = new JTable();
        this.tableLinks.setSelectionMode(2);
        Object[] colNameLinks = new String[]{"Toponym_Origin", "Toponym_Destination", "Weight", "Long_Origin", "Lat_Origin", "Long_Destination", "Lat_Destination"};
        DefaultTableModel modelAttributesTableLinks = (DefaultTableModel)this.tableLinks.getModel();
        modelAttributesTableLinks.setColumnIdentifiers(colNameLinks);
        this.tableLinks.setModel(modelAttributesTableLinks);
        JScrollPane scrollPaneTablePoints = new JScrollPane();
        this.pTablPointsGeoView.setViewportView(scrollPaneTablePoints);
        scrollPaneTablePoints.setViewportView(this.tablePoints);
        JScrollPane scrollPaneTableLinks = new JScrollPane();
        this.pTablLinesGeoView.setViewportView(scrollPaneTableLinks);
        scrollPaneTableLinks.setViewportView(this.tableLinks);
        try {
            this.displayWorldBorderShapefile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.diplayCollectionsPointsAndLines(collectionfeaturesReadyToBeDisplayed);
    }

    private DirectPosition2D calculateWorldPos(MapPane pane, MouseEvent event) {
        AffineTransform tr = pane.getScreenToWorldTransform();
        DirectPosition2D pos = new DirectPosition2D((double)event.getX(), (double)event.getY());
        tr.transform((Point2D)pos, (Point2D)pos);
        pos.setCoordinateReferenceSystem(pane.getMapContent().getCoordinateReferenceSystem());
        return pos;
    }

    private ReferencedEnvelope centerOn(ReferencedEnvelope env, Coordinate coordClicked) {
        Coordinate pEnv = env.centre();
        double dX = -(pEnv.x - coordClicked.x);
        double dY = -(pEnv.y - coordClicked.y);
        env.translate(dX, dY);
        return env;
    }

    private Style createFromSLD(File sld) {
        try {
            this.createFromSLD2(sld.toURI().toURL());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Style createFromSLD2(URL sld) {
        try {
            SLDParser stylereader = new SLDParser(this.styleFactory, sld.toURI().toURL());
            Style[] style = stylereader.readXML();
            return style[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Style createStyle(File file, FeatureSource<?, ?> featureSource) {
        File sld = this.toSLDFile(file);
        if (sld != null) {
            return this.createFromSLD(sld);
        }
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        return JSimpleStyleDialog.showDialog(null, (SimpleFeatureType)schema);
    }

    private Style createStyle2(FeatureSource featureSource) {
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        Class geomType = schema.getGeometryDescriptor().getType().getBinding();
        if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
            return this.createPolygonStyle();
        }
        if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
            return this.createLineStyle();
        }
        return this.createPointStyle();
    }

    private Style createPolygonStyle() {
        Stroke stroke = this.styleFactory.createStroke((Expression)this.filterFactory.literal((Object)Color.LIGHT_GRAY), (Expression)this.filterFactory.literal(1), (Expression)this.filterFactory.literal(0.5));
        Fill fill = this.styleFactory.createFill((Expression)this.filterFactory.literal((Object)new Color(227, 198, 141)), (Expression)this.filterFactory.literal(0.5));
        PolygonSymbolizer sym = this.styleFactory.createPolygonSymbolizer(stroke, fill, null);
        Rule rule = this.styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = this.styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createLineStyle() {
        Stroke stroke = this.styleFactory.createStroke((Expression)this.filterFactory.literal((Object)Color.BLUE), (Expression)this.filterFactory.literal(1));
        LineSymbolizer sym = this.styleFactory.createLineSymbolizer(stroke, null);
        Rule rule = this.styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = this.styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    private Style createPointStyle() {
        Graphic gr = this.styleFactory.createDefaultGraphic();
        Mark mark = this.styleFactory.getCircleMark();
        mark.setStroke((org.opengis.style.Stroke)this.styleFactory.createStroke((Expression)this.filterFactory.literal((Object)Color.BLUE), (Expression)this.filterFactory.literal(1)));
        mark.setFill((org.opengis.style.Fill)this.styleFactory.createFill((Expression)this.filterFactory.literal((Object)Color.CYAN)));
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(mark);
        gr.setSize((Expression)this.filterFactory.literal(5));
        PointSymbolizer sym = this.styleFactory.createPointSymbolizer(gr, null);
        Rule rule = this.styleFactory.createRule();
        rule.symbolizers().add(sym);
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle(new Rule[]{rule});
        Style style = this.styleFactory.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    public void diplayCollectionsPointsAndLines(ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed) {
        try {
            SimpleFeatureSource featureSourcePoints = DataUtilities.source((FeatureCollection)((FeatureCollection)collectionfeaturesReadyToBeDisplayed.get(0)));
            Style stylePoints = this.createFromSLD2(MapPanel.class.getResource("/org/tip/puckgui/views/geo/data/SCHEMA_POINTS.sld"));
            FeatureLayer layerPoints = new FeatureLayer((FeatureSource)featureSourcePoints, stylePoints);
            this.setUpTablePointsData((FeatureSource<?, ?>)featureSourcePoints);
            int nbFeaturePoints = featureSourcePoints.getFeatures().size();
            ReferencedEnvelope bounds = layerPoints.getBounds();
            double dh = Math.abs(bounds.getHeight() - bounds.getHeight() * 1.1);
            double dw = Math.abs(bounds.getWidth() - bounds.getWidth() * 1.1);
            bounds.expandBy(Math.max(dh, dw));
            SimpleFeatureSource featureSourceLines = DataUtilities.source((FeatureCollection)((FeatureCollection)collectionfeaturesReadyToBeDisplayed.get(1)));
            Style styleLines = this.createFromSLD2(MapPanel.class.getResource("/org/tip/puckgui/views/geo/data/SCHEMA_LINES.sld"));
            FeatureLayer layerLines = new FeatureLayer((FeatureSource)featureSourceLines, styleLines);
            if (featureSourceLines.getFeatures().size() == 0) {
                this.tabbedPane.setEnabledAt(3, false);
            } else {
                this.tabbedPane.setEnabledAt(3, true);
            }
            this.setUpTableLinksData((FeatureSource<?, ?>)featureSourceLines);
            int nbFeatureLines = featureSourceLines.getFeatures().size();
            if (nbFeaturePoints > 0) {
                this.mapContent.addLayer((Layer)layerPoints);
                layerPoints.setTitle("Points Layer");
                this.listModel.add(this.listModel.getSize() - 1, layerPoints.getTitle());
                this.lblAvailableLayers.setText(String.valueOf(this.lblAvailableLayers.getText()) + ", " + layerPoints.getTitle());
            }
            if (nbFeatureLines > 0) {
                this.mapContent.addLayer((Layer)layerLines);
                layerLines.setTitle("Links Layer");
                this.listModel.add(this.listModel.getSize() - 1, layerLines.getTitle());
                this.lblAvailableLayers.setText(String.valueOf(this.lblAvailableLayers.getText()) + ", " + layerLines.getTitle());
            }
            this.mapContent.getViewport().setBounds(bounds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void displayFeatureCollectionLayer(String title, FeatureCollection<?, ?> featureCollection, Style style) {
        FeatureLayer layer = new FeatureLayer(featureCollection, style);
        this.mapContent.addLayer((Layer)layer);
        layer.setTitle(title);
        this.listModel.addElement(title);
    }

    public void displayFeatureSourceLayer(String title, FeatureSource<?, ?> featureSource, Style style) {
        FeatureLayer layer = new FeatureLayer(featureSource, style);
        this.mapContent.addLayer((Layer)layer);
        layer.setTitle(title);
        this.listModel.addElement(title);
    }

    private void displaysShapefile(File file) throws IOException {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)file);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        Style style = this.createStyle(file, (FeatureSource<?, ?>)featureSource);
        this.displayFeatureSourceLayer(file.getName(), (FeatureSource<?, ?>)featureSource, style);
    }

    private void displaysShapefile(URL urlSHP, URL urlStyle) throws IOException {
        System.out.println("create style");
        System.out.println(urlStyle.getPath());
        Style style = this.createFromSLD(new File(urlStyle.getPath()));
        System.out.println(style.toString());
        FileDataStore store = FileDataStoreFinder.getDataStore((URL)urlSHP);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        String fileName = urlSHP.toString().substring(urlSHP.toString().lastIndexOf("/") + 1, urlSHP.toString().lastIndexOf("."));
        this.displayFeatureSourceLayer(fileName, (FeatureSource<?, ?>)featureSource, style);
    }

    private void displaysShapefile2(URL urlSHP, URL urlStyle) throws IOException {
        System.out.println("create style");
        System.out.println("urlStyle.getpath=" + urlStyle.getPath());
        FileDataStore store = FileDataStoreFinder.getDataStore((URL)urlSHP);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        Style style = this.createStyle2((FeatureSource)featureSource);
        String fileName = urlSHP.toString().substring(urlSHP.toString().lastIndexOf("/") + 1, urlSHP.toString().lastIndexOf("."));
        this.displayFeatureSourceLayer(fileName, (FeatureSource<?, ?>)featureSource, style);
    }

    private void displayWorldBorderShapefile() throws IOException {
        URL urlShapeFile = MapPanel.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.shp");
        URL urlStyle = MapPanel.class.getResource("/org/tip/puckgui/views/geo/data/TM_WORLD_BORDERS-0.3.sld");
        this.displaysShapefile2(urlShapeFile, urlStyle);
        this.lblAvailableLayers.setText("WORLD BORDERS");
    }

    public List<Layer> getLayers() {
        return this.mapContent.layers();
    }

    public ReferencedEnvelope maximiseBoundsForLayers() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Layer iterLayer : this.getLayers()) {
            if (iterLayer.getTitle().compareTo("TM_WORLD_BORDERS-0.3.shp") == 0) continue;
            ReferencedEnvelope bounds = iterLayer.getBounds();
            double minXTemp = bounds.getMinX();
            minX = Math.min(minX, minXTemp);
            double maxXTemp = bounds.getMaxX();
            maxX = Math.max(maxX, maxXTemp);
            double minYTemp = bounds.getMinY();
            minY = Math.min(minY, minYTemp);
            double maxYTemp = bounds.getMaxY();
            maxY = Math.max(maxY, maxYTemp);
        }
        ReferencedEnvelope env = new ReferencedEnvelope();
        env.init(minX, maxX, minY, maxY);
        double dh = Math.abs(env.getHeight() - env.getHeight() * 1.1);
        double dw = Math.abs(env.getWidth() - env.getWidth() * 1.1);
        env.expandBy(Math.max(dh, dw));
        return env;
    }

    private void prepareExportShapeFile() {
        String prefixFileName = this.labelGraph;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        String fileDate = dateFormat.format(date);
        File targetFile = new File(String.valueOf(prefixFileName) + "_" + fileDate + ".shp");
        boolean ended = false;
        while (!ended) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(targetFile);
            chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            GenericFileFilter defaultFileFilter = new GenericFileFilter("Shapefile (*.shp)", "shp");
            chooser.addChoosableFileFilter(defaultFileFilter);
            chooser.setFileFilter(defaultFileFilter);
            if (chooser.showSaveDialog(this) == 0) {
                boolean doSave;
                targetFile = chooser.getSelectedFile();
                if (targetFile.exists()) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                    int response = JOptionPane.showConfirmDialog(this, message, title, 1);
                    if (response == 0) {
                        doSave = true;
                        ended = true;
                    } else if (response == 1) {
                        doSave = false;
                        ended = false;
                    } else {
                        doSave = false;
                        ended = true;
                    }
                } else {
                    doSave = true;
                    ended = true;
                }
                if (!doSave) continue;
                SIGFile.exportToShapefile(this.getLayers(), targetFile);
                this.lblPathToLayers.setText(targetFile.getPath());
                continue;
            }
            System.out.println("No Selection");
            ended = true;
        }
    }

    private void prepareExportSVG() {
        String prefixFileName = this.labelGraph;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
        Date date = new Date();
        String fileDate = dateFormat.format(date);
        File targetFile = new File(String.valueOf(prefixFileName) + "_" + fileDate + ".svg");
        boolean ended = false;
        while (!ended) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(targetFile);
            chooser.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            GenericFileFilter defaultFileFilter = new GenericFileFilter("Shapefile (*.svg)", "svg");
            chooser.addChoosableFileFilter(defaultFileFilter);
            chooser.setFileFilter(defaultFileFilter);
            if (chooser.showSaveDialog(this) == 0) {
                boolean doSave;
                targetFile = chooser.getSelectedFile();
                if (targetFile.exists()) {
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.title");
                    String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileConfirm.existingFile.text");
                    int response = JOptionPane.showConfirmDialog(this, message, title, 1);
                    if (response == 0) {
                        doSave = true;
                        ended = true;
                    } else if (response == 1) {
                        doSave = false;
                        ended = false;
                    } else {
                        doSave = false;
                        ended = true;
                    }
                } else {
                    doSave = true;
                    ended = true;
                }
                if (!doSave) continue;
                try {
                    FileOutputStream output = new FileOutputStream(targetFile);
                    ReferencedEnvelope env = this.maximiseBoundsForLayers();
                    SIGFile.exportSVG(this.mapContent, env, output, null);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("No Selection ");
            ended = true;
        }
    }

    public void setUpTablePointsData(FeatureSource<?, ?> featureSourcePoints) {
        ArrayList<SimpleFeature> list;
        DefaultTableModel tableModelPoints;
        block10: {
            tableModelPoints = (DefaultTableModel)this.tablePoints.getModel();
            list = new ArrayList<SimpleFeature>();
            SimpleFeatureIterator iterator = null;
            try {
                try {
                    iterator = (SimpleFeatureIterator)featureSourcePoints.getFeatures().features();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        list.add(feature);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    iterator.close();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
            iterator.close();
        }
        int index = 0;
        while (index < list.size()) {
            SimpleFeature feature = (SimpleFeature)list.get(index);
            Object[] data = this.labelGraph.contains("Net Places") || this.labelGraph.contains("Net Places") ? new Object[6] : new Object[5];
            if (feature.getAttribute(0) != null) {
                int ix_id = ((String)feature.getAttribute(0)).indexOf("id=");
                data[0] = ((String)feature.getAttribute(0)).substring(ix_id + 3, ((String)feature.getAttribute(0)).indexOf(";"));
                int ix_admin = ((String)feature.getAttribute(0)).indexOf("admin=");
                data[2] = ((String)feature.getAttribute(0)).substring(ix_admin + 6, ((String)feature.getAttribute(0)).indexOf("]"));
            } else {
                data[0] = "N/A";
                data[2] = "N/A";
            }
            data[1] = feature.getAttribute(1);
            Geometry g = (Geometry)feature.getAttribute("the_geom");
            data[3] = new Double(g.getCoordinate().x);
            data[4] = new Double(g.getCoordinate().y);
            if (this.labelGraph.contains("Net Places") || this.labelGraph.contains("Net_Places")) {
                data[5] = (Double)feature.getAttribute("weight");
            }
            tableModelPoints.addRow(data);
            ++index;
        }
        this.tablePoints.setModel(tableModelPoints);
        tableModelPoints.fireTableDataChanged();
        this.tablePoints.repaint();
    }

    public void setUpTableLinksData(FeatureSource<?, ?> featureSourceLinks) {
        ArrayList<SimpleFeature> list;
        DefaultTableModel tableModelLinks;
        block10: {
            try {
                if (featureSourceLinks.getFeatures().size() == 0) {
                    return;
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            tableModelLinks = (DefaultTableModel)this.tableLinks.getModel();
            list = new ArrayList<SimpleFeature>();
            SimpleFeatureIterator iterator = null;
            try {
                try {
                    iterator = (SimpleFeatureIterator)featureSourceLinks.getFeatures().features();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        list.add(feature);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    iterator.close();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                iterator.close();
                throw throwable;
            }
            iterator.close();
        }
        int index = 0;
        while (index < list.size()) {
            SimpleFeature feature = (SimpleFeature)list.get(index);
            Object[] data = new Object[7];
            String OD = (String)feature.getAttribute(0);
            OD = OD.replace(",", "").replace(" ", "");
            String O = OD.substring(0, OD.indexOf("--") - 1);
            String D = OD.substring(OD.indexOf("--") + 2, OD.length());
            data[0] = O;
            data[1] = D;
            data[2] = feature.getAttribute(1);
            Geometry g = (Geometry)feature.getAttribute("the_geom");
            data[3] = new Double(g.getCoordinates()[0].x);
            data[4] = new Double(g.getCoordinates()[0].y);
            data[5] = new Double(g.getCoordinates()[g.getCoordinates().length - 1].x);
            data[6] = new Double(g.getCoordinates()[g.getCoordinates().length - 1].y);
            tableModelLinks.addRow(data);
            ++index;
        }
        this.tableLinks.setModel(tableModelLinks);
        tableModelLinks.fireTableDataChanged();
        this.tableLinks.repaint();
    }

    public File toSLDFile(File file) {
        String path = file.getAbsolutePath();
        String base = path.substring(0, path.length() - 4);
        String newPath = String.valueOf(base) + ".sld";
        File sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        newPath = String.valueOf(base) + ".SLD";
        sld = new File(newPath);
        if (sld.exists()) {
            return sld;
        }
        return null;
    }

    private void unselectToggleButtonsExcept(JToggleButton tglbSelected) {
        for (JToggleButton iterTglb : this.listToggleButtons) {
            iterTglb.setSelected(false);
        }
        tglbSelected.setSelected(true);
    }

    private static enum Tools {
        DRAG,
        SELECT,
        ZOOMIN,
        ZOOMOUT;

    }
}

