/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.filebatchconverter;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBatchConverterSourceDirectorySelector
extends JFileChooser {
    private static final long serialVersionUID = -7969688115121640994L;
    private static final Logger logger = LoggerFactory.getLogger(FileBatchConverterSourceDirectorySelector.class);

    public FileBatchConverterSourceDirectorySelector(File sourceDirectory) {
        File targetDirectory = sourceDirectory == null ? null : (sourceDirectory.isDirectory() ? sourceDirectory : sourceDirectory.getParentFile());
        this.setSelectedFile(targetDirectory);
        this.setDialogTitle("File Batch Converter source directory");
        this.setFileSelectionMode(1);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Set Source");
        this.setDialogType(2);
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        System.out.println("==== SET SELECTED FILE=================");
        System.out.println("SELECED FILE " + file);
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        FileBatchConverterSourceDirectorySelector selector = new FileBatchConverterSourceDirectorySelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

