/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tip.puck.io.kinsources.Catalog;
import org.tip.puck.io.kinsources.CatalogItem;
import org.tip.puck.io.kinsources.KinsourcesFile;
import org.tip.puckgui.models.CatalogModel;

public class KinsourcesCatalogSelectorDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private final JPanel contentPanel = new JPanel();
    private static Catalog lastCatalog;
    private CatalogItem dialogCriteria;
    private static CatalogItem lastCriteria;
    private JTable tblItems;
    private JButton btnBrowseKinsources;
    private JButton btnBrowseDataset;

    static {
        lastCriteria = null;
    }

    public KinsourcesCatalogSelectorDialog() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Kinsources Catalog Selector");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(KinsourcesCatalogSelectorDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KinsourcesCatalogSelectorDialog.this.dialogCriteria = null;
                KinsourcesCatalogSelectorDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 482, 478);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, "About Kinsources", 4, 2, null, null));
        this.getContentPane().add((Component)panel, "North");
        panel.setLayout(new BoxLayout(panel, 1));
        JTextPane txtpnIntroduction = new JTextPane();
        txtpnIntroduction.setEditable(false);
        txtpnIntroduction.setText("Kinsources is an open and interactive platform to archive, share, analyze and compare kinship data used in scientific research.\n\nThis selector allows you to open a dataset file directly from Kinsources.\n\nVisit the Kinsources website: https://www.kinsources.net/");
        panel.add(txtpnIntroduction);
        this.btnBrowseKinsources = new JButton("Browse Kinsources");
        this.btnBrowseKinsources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String KINSOURCES_URL = "https://www.kinsources.net/";
                try {
                    if (Desktop.isDesktopSupported()) {
                        Desktop desktop = Desktop.getDesktop();
                        if (desktop.isSupported(Desktop.Action.BROWSE)) {
                            URI uri = new URI(KINSOURCES_URL);
                            desktop.browse(uri);
                        } else if (KinsourcesCatalogSelectorDialog.this.btnBrowseKinsources != null) {
                            KinsourcesCatalogSelectorDialog.this.btnBrowseKinsources.setEnabled(false);
                        }
                    } else if (KinsourcesCatalogSelectorDialog.this.btnBrowseKinsources != null) {
                        KinsourcesCatalogSelectorDialog.this.btnBrowseKinsources.setEnabled(false);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    System.err.println("The system cannot find the URL specified: [" + KINSOURCES_URL + "]");
                    JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
                }
                catch (URISyntaxException use) {
                    use.printStackTrace();
                    System.out.println("Illegal character in path [" + KINSOURCES_URL + "]");
                    JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
                }
            }
        });
        this.btnBrowseKinsources.setHorizontalAlignment(2);
        panel.add(this.btnBrowseKinsources);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.tblItems = new JTable();
        this.tblItems.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    KinsourcesCatalogSelectorDialog.this.openDataset();
                }
            }
        });
        this.tblItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    KinsourcesCatalogSelectorDialog.this.openDataset();
                }
            }
        });
        this.tblItems.setSelectionMode(0);
        scrollPane.setViewportView(this.tblItems);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KinsourcesCatalogSelectorDialog.this.dialogCriteria = null;
                KinsourcesCatalogSelectorDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Open");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KinsourcesCatalogSelectorDialog.this.openDataset();
            }
        });
        Component horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        JButton btnRefresh = new JButton("Refresh");
        buttonPane.add(btnRefresh);
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KinsourcesCatalogSelectorDialog.this.refresh();
            }
        });
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        this.btnBrowseDataset = new JButton("Browse");
        this.btnBrowseDataset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CatalogItem criteria = KinsourcesCatalogSelectorDialog.this.getCriteria();
                try {
                    if (criteria == null) {
                        String title = "Invalid input";
                        String message = "Please, select a dataset.";
                        JOptionPane.showMessageDialog(null, message, title, 0);
                    } else if (Desktop.isDesktopSupported()) {
                        Desktop desktop = Desktop.getDesktop();
                        if (desktop.isSupported(Desktop.Action.BROWSE)) {
                            URI uri = new URI(criteria.getPermanentLink());
                            desktop.browse(uri);
                        } else if (KinsourcesCatalogSelectorDialog.this.btnBrowseDataset != null) {
                            KinsourcesCatalogSelectorDialog.this.btnBrowseKinsources.setEnabled(false);
                        }
                    } else if (KinsourcesCatalogSelectorDialog.this.btnBrowseDataset != null) {
                        KinsourcesCatalogSelectorDialog.this.btnBrowseDataset.setEnabled(false);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    System.err.println("The system cannot find the URL specified: [" + criteria.getPermanentLink() + "]");
                    JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
                }
                catch (URISyntaxException use) {
                    use.printStackTrace();
                    System.out.println("Illegal character in path [" + criteria.getPermanentLink() + "]");
                    JOptionPane.showMessageDialog(null, "Sorry, browser call failed.", "Error", 0);
                }
            }
        });
        this.btnBrowseDataset.setActionCommand("OK");
        buttonPane.add(this.btnBrowseDataset);
        horizontalStrut = Box.createHorizontalStrut(20);
        buttonPane.add(horizontalStrut);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        if (lastCatalog == null) {
            this.refresh();
        } else {
            this.tblItems.setModel(new CatalogModel(lastCatalog));
        }
        this.setCriteria(lastCriteria);
        this.tblItems.getColumnModel().getColumn(0).setMaxWidth(40);
    }

    public CatalogItem getCriteria() {
        int currentIndex = this.tblItems.getSelectedRow();
        CatalogItem result = currentIndex == -1 ? null : ((CatalogModel)this.tblItems.getModel()).getSource().getByIndex(currentIndex);
        return result;
    }

    public CatalogItem getDialogCriteria() {
        CatalogItem result = this.dialogCriteria;
        return result;
    }

    public void openDataset() {
        CatalogItem criteria = this.getCriteria();
        if (criteria == null) {
            String title = "Invalid input";
            String message = "Please, select a dataset.";
            JOptionPane.showMessageDialog(null, message, title, 0);
        } else {
            lastCriteria = criteria;
            this.dialogCriteria = criteria;
            this.setVisible(false);
        }
    }

    public void refresh() {
        Catalog catalog = KinsourcesFile.loadCatalog();
        if (catalog == null) {
            catalog = KinsourcesFile.loadCatalog();
        }
        if (catalog == null) {
            String title = "Kinsources Catalog Error";
            String message = "<html><p>Sorry, the Kinsources Catalog is not reachable.</p><p>Please, check your Internet connection and/or try later.</p></html>";
            JOptionPane.showMessageDialog(null, message, title, 0);
            catalog = new Catalog();
            lastCatalog = null;
        } else {
            lastCatalog = catalog = catalog.findWithFile().sortByName();
        }
        TableModel model = this.tblItems.getModel();
        if (model instanceof DefaultTableModel) {
            this.tblItems.setModel(new CatalogModel(catalog));
        } else {
            ((CatalogModel)this.tblItems.getModel()).setSource(catalog);
        }
    }

    private void setCriteria(CatalogItem source) {
    }

    public static void main(String[] args) {
        KinsourcesCatalogSelectorDialog.showDialog();
    }

    public static CatalogItem showDialog() {
        KinsourcesCatalogSelectorDialog dialog = new KinsourcesCatalogSelectorDialog();
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        CatalogItem result = dialog.getDialogCriteria();
        return result;
    }
}

