/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import java.awt.Component;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.util.GenericFileFilter;
import org.tip.puckgui.views.ConfirmOverwriteDialog;

public class CorpusSaveFileSelector
extends JFileChooser {
    private static final long serialVersionUID = -7786124373871130820L;
    private static final Logger logger = LoggerFactory.getLogger(CorpusSaveFileSelector.class);

    public CorpusSaveFileSelector(File targetFile) {
        this.setSelectedFile(targetFile);
        this.setDialogTitle(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.saveAsFileChooser.text"));
        this.setFileSelectionMode(0);
        this.setAcceptAllFileFilterUsed(true);
        this.setApproveButtonText("Save");
        this.setDialogType(2);
        GenericFileFilter defaultFileFilter = new GenericFileFilter("Genealogic files (*.puc, *.iur.ods, *.iur.txt, *.iur.xls, *.ged, *.pl, *.tip, *.xml)", "ged", "iur.ods", "pl", "puc", "tip", "iur.txt", "iur.xls", "xml");
        this.addChoosableFileFilter(defaultFileFilter);
        this.addChoosableFileFilter(new GenericFileFilter("PUCK (*.puc)", "puc"));
        this.addChoosableFileFilter(new GenericFileFilter("IUR (*.iur.ods,*.iur.txt,*.iur.xls)", "iur.ods", "iur.txt", "iur.xls"));
        this.addChoosableFileFilter(new GenericFileFilter("IUR OpenDocumentFormat Spreadsheet (*.iur.ods)", "iur.ods"));
        this.addChoosableFileFilter(new GenericFileFilter("IUR Text (*.iur.txt)", "iur.txt"));
        this.addChoosableFileFilter(new GenericFileFilter("IUR Microsoft Excel (*.iur.xls)", "iur.xls"));
        this.addChoosableFileFilter(new GenericFileFilter("GEDCOM (*.ged)", "ged"));
        this.addChoosableFileFilter(new GenericFileFilter("Prolog (*.pl)", "pl"));
        this.addChoosableFileFilter(new GenericFileFilter("TIP (*.tip)", "tip"));
        this.addChoosableFileFilter(new GenericFileFilter("Extensible Markup Language (*.xml)", "xml"));
        this.setFileFilter(defaultFileFilter);
    }

    @Override
    public void approveSelection() {
        File targetFile = this.getSelectedFile();
        logger.debug("getCurrentDirectory(): {}", (Object)this.getCurrentDirectory());
        logger.debug("selectedFile={}", (Object)targetFile);
        if (StringUtils.isBlank((CharSequence)ToolBox.getExtension(targetFile))) {
            targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".txt");
        }
        if (!StringUtils.endsWithAny((CharSequence)ToolBox.getExtension(targetFile), (CharSequence[])new CharSequence[]{"ged", "ods", "pl", "puc", "tip", "txt", "xls", "xml"})) {
            targetFile = new File(String.valueOf(targetFile.getAbsolutePath()) + ".txt");
            this.setSelectedFile(targetFile);
        }
        if (targetFile.exists()) {
            if (ConfirmOverwriteDialog.showDialog(null)) {
                logger.debug("Overwrite");
                super.approveSelection();
            } else {
                logger.debug("Cancel overwrite");
            }
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.resetChoosableFileFilters();
        }
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        CorpusSaveFileSelector selector = new CorpusSaveFileSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

