/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.util.Chronometer;

public class ProgressStatus {
    private static final Logger logger = LoggerFactory.getLogger(ProgressStatus.class);
    private long current;
    private long max;
    private long extra1;
    private String description;
    private Chronometer chrono;

    public ProgressStatus() {
        this.current = 0L;
        this.max = 0L;
        this.extra1 = 0L;
        this.chrono = new Chronometer().reset().start();
    }

    public ProgressStatus(long start, long max) {
        this.current = start;
        this.max = max;
    }

    public Chronometer getChrono() {
        return this.chrono;
    }

    public long getCurrent() {
        return this.current;
    }

    public int getCurrentRate() {
        int result = this.max == 0L ? 0 : (int)(this.current * 100L / this.max);
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public long getExtra1() {
        return this.extra1;
    }

    public long getMax() {
        return this.max;
    }

    public void inc() {
        ++this.current;
    }

    public void incExtra1() {
        ++this.extra1;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExtra1(long extra1) {
        this.extra1 = extra1;
    }

    public void setMax(long max) {
        this.max = max;
    }
}

