/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.util.NumberablesHashMap;

public class ComboBoxIds {
    private static ComboBoxIds instance = null;
    private List<String> items = null;

    private ComboBoxIds() {
    }

    public List<String> items() {
        List<String> result = this.items;
        return result;
    }

    public void update(List<Individual> individuals) {
        if (individuals == null) {
            this.items = new ArrayList<String>(0);
        } else {
            this.items = new ArrayList<String>(individuals.size());
            for (Individual individual : individuals) {
                this.items.add(String.valueOf(individual.getId()) + " " + individual.getName());
            }
        }
    }

    public static String extractId(String input) {
        String result;
        if (input == null) {
            result = null;
        } else {
            boolean ended = false;
            int index = 0;
            while (!ended) {
                if (index < input.length()) {
                    if (Character.isDigit(input.charAt(index))) {
                        ++index;
                        continue;
                    }
                    ended = true;
                    continue;
                }
                ended = true;
            }
            result = input.substring(0, index);
        }
        return result;
    }

    public static String extractName(String input) {
        String result;
        if (input == null) {
            result = null;
        } else {
            boolean ended = false;
            int index = 0;
            while (!ended) {
                if (index < input.length()) {
                    if (Character.isDigit(input.charAt(index))) {
                        ++index;
                        continue;
                    }
                    ended = true;
                    continue;
                }
                ended = true;
            }
            result = input.substring(index);
        }
        return result;
    }

    public static Individual getIndividualFromInput(Net net, Object value) {
        Individual result;
        String input = value == null ? null : (value instanceof String ? (String)value : value.toString());
        String newIndividualIdInput = ComboBoxIds.extractId(input);
        if (StringUtils.isBlank((CharSequence)newIndividualIdInput)) {
            result = null;
        } else {
            int newIndividualId = Integer.parseInt(newIndividualIdInput);
            result = (Individual)net.individuals().getById(newIndividualId);
        }
        return result;
    }

    public static Individual getOrCreateIndividualFromInput(NumberablesHashMap.IdStrategy idStrategy, Net net, Object value, Gender gender) {
        Individual result;
        String input = value == null ? null : (value instanceof String ? (String)value : value.toString());
        String newIndividualIdInput = ComboBoxIds.extractId(input);
        if (StringUtils.isBlank((CharSequence)newIndividualIdInput)) {
            String newIndividualNameInput = ComboBoxIds.extractName(input);
            result = StringUtils.isBlank((CharSequence)newIndividualNameInput) || StringUtils.equals((CharSequence)newIndividualNameInput, (CharSequence)"---") ? null : net.createIndividual(idStrategy, newIndividualNameInput, gender);
        } else {
            int newIndividualId = Integer.parseInt(newIndividualIdInput);
            result = (Individual)net.individuals().getById(newIndividualId);
            if (result == null) {
                result = new Individual(newIndividualId, "?", gender);
                net.individuals().put(result);
                String newIndividualNameInput = ComboBoxIds.extractName(input);
                if (StringUtils.isNotBlank((CharSequence)newIndividualNameInput)) {
                    result.setName(newIndividualNameInput);
                }
            }
        }
        return result;
    }

    public static Individual getOrCreateIndividualFromInput(Net net, Object value, Gender gender) {
        Individual result = ComboBoxIds.getOrCreateIndividualFromInput(net.getDefaultIdStrategy(), net, value, gender);
        return result;
    }

    public static ComboBoxIds instance() {
        if (instance == null) {
            instance = new ComboBoxIds();
        }
        ComboBoxIds result = instance;
        return result;
    }
}

