/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.tip.puck.statistics.FiliationCount;

public class NumberedFiliationCounts
extends HashMap<Integer, FiliationCount>
implements Iterable<FiliationCount> {
    private static final long serialVersionUID = 7423770237304696469L;

    public NumberedFiliationCounts() {
    }

    public NumberedFiliationCounts(int initialCapacity) {
        super(initialCapacity);
    }

    public double averageAgnatic() {
        int sum = 0;
        int count = 0;
        for (FiliationCount value : this) {
            sum = (int)((double)sum + value.getAgnatic());
            ++count;
        }
        double result = count == 0 ? 0.0 : (double)sum * 1.0 / (double)count;
        return result;
    }

    public double averageCognatic() {
        int sum = 0;
        int count = 0;
        for (FiliationCount value : this) {
            sum = (int)((double)sum + value.getCognatic());
            ++count;
        }
        double result = count == 0 ? 0.0 : (double)sum * 1.0 / (double)count;
        return result;
    }

    public double averagePositiveAgnatic() {
        int sum = 0;
        int count = 0;
        for (FiliationCount value : this) {
            if (value.getAgnatic() == 0.0) continue;
            sum = (int)((double)sum + value.getAgnatic());
            ++count;
        }
        double result = count == 0 ? 0.0 : (double)sum * 1.0 / (double)count;
        return result;
    }

    public double averagePositiveCognatic() {
        int sum = 0;
        int count = 0;
        for (FiliationCount value : this) {
            if (value.getCognatic() == 0.0) continue;
            sum = (int)((double)sum + value.getCognatic());
            ++count;
        }
        double result = count == 0 ? 0.0 : (double)sum * 1.0 / (double)count;
        return result;
    }

    public double averagePositiveUterine() {
        int sum = 0;
        int count = 0;
        for (FiliationCount value : this) {
            if (value.getUterine() == 0.0) continue;
            sum = (int)((double)sum + value.getUterine());
            ++count;
        }
        double result = count == 0 ? 0.0 : (double)sum * 1.0 / (double)count;
        return result;
    }

    public double averageUterine() {
        int sum = 0;
        int count = 0;
        for (FiliationCount value : this) {
            sum = (int)((double)sum + value.getUterine());
            ++count;
        }
        double result = count == 0 ? 0.0 : (double)sum * 1.0 / (double)count;
        return result;
    }

    @Override
    public Iterator<FiliationCount> iterator() {
        Iterator<FiliationCount> result = super.values().iterator();
        return result;
    }

    public double maxAgnatic() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (FiliationCount value : this) {
                if (!(value.getAgnatic() > result)) continue;
                result = value.getAgnatic();
            }
        }
        return result;
    }

    public double maxCognatic() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (FiliationCount value : this) {
                if (!(value.getCognatic() > result)) continue;
                result = value.getCognatic();
            }
        }
        return result;
    }

    public double maxUterine() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MIN_VALUE;
            for (FiliationCount value : this) {
                if (!(value.getUterine() > result)) continue;
                result = value.getUterine();
            }
        }
        return result;
    }

    public double minAgnatic() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (FiliationCount value : this) {
                if (!(value.getAgnatic() < result)) continue;
                result = value.getAgnatic();
            }
        }
        return result;
    }

    public double minCognatic() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (FiliationCount value : this) {
                if (!(value.getCognatic() < result)) continue;
                result = value.getCognatic();
            }
        }
        return result;
    }

    public double minUterine() {
        double result;
        if (this.size() == 0) {
            result = 0.0;
        } else {
            result = Double.MAX_VALUE;
            for (FiliationCount value : this) {
                if (!(value.getUterine() < result)) continue;
                result = value.getUterine();
            }
        }
        return result;
    }

    public List<FiliationCount> toList() {
        ArrayList<FiliationCount> result = new ArrayList<FiliationCount>(this.values());
        return result;
    }
}

