/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath;

public class PruningCriteria {
    public static PruningCriteria DIRECT = new PruningCriteria(1, 1, 1, AboveType.COLLATERALS, UnderType.AFFINES);
    public static PruningCriteria GRAND = new PruningCriteria(2, 1, 2, AboveType.COLLATERALS, UnderType.AFFINES);
    public static PruningCriteria GREAT = new PruningCriteria(3, 1, 3, AboveType.COLLATERALS, UnderType.AFFINES);
    public static PruningCriteria FULL = new PruningCriteria(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, AboveType.ALL, UnderType.ALL);
    private int parentsDepth;
    private int partnersDepth;
    private int childrenDepth;
    private boolean collaterals;
    private boolean affines;

    public PruningCriteria() {
        this(3, 1, 3, AboveType.COLLATERALS, UnderType.AFFINES);
    }

    public PruningCriteria(int parentsDepth, int partnersDepth, int childrenDepth, AboveType aboveType, UnderType underType) {
        this.parentsDepth = parentsDepth;
        this.partnersDepth = partnersDepth;
        this.childrenDepth = childrenDepth;
        this.collaterals = aboveType == AboveType.COLLATERALS;
        this.affines = underType == UnderType.AFFINES;
    }

    public int getChildrenDepth() {
        return this.childrenDepth;
    }

    public int getParentsDepth() {
        return this.parentsDepth;
    }

    public int getPartnersDepth() {
        return this.partnersDepth;
    }

    public boolean isAffines() {
        return this.affines;
    }

    public boolean isCollaterals() {
        return this.collaterals;
    }

    public void setAffines(boolean affines) {
        this.affines = affines;
    }

    public void setChildrenDepth(int childrenDepth) {
        this.childrenDepth = childrenDepth;
    }

    public void setCollaterals(boolean collaterals) {
        this.collaterals = collaterals;
    }

    public void setParentsDepth(int parentsDepth) {
        this.parentsDepth = parentsDepth;
    }

    public void setPartnersDepth(int partnersDepth) {
        this.partnersDepth = partnersDepth;
    }

    public static enum AboveType {
        ALL,
        COLLATERALS;

    }

    public static enum UnderType {
        ALL,
        AFFINES;

    }
}

