/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.gis;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.tip.puck.PuckException;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.w3c.dom.Document;

public class SIGFile {
    public static <E> void exportToGIS(Graph<Place> source, String fileName) throws PuckException {
    }

    public static void exportToShapefile(List<Layer> layersList, File file) {
        DefaultTransaction t = null;
        try {
            for (Layer layer : layersList) {
                t = new DefaultTransaction("create");
                SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getFeatureSource();
                SimpleFeatureType ft = (SimpleFeatureType)featureSource.getSchema();
                if (featureSource.getFeatures().isEmpty()) continue;
                String schemaName = String.valueOf(file.toString()) + "_" + ft.getTypeName();
                schemaName = schemaName.substring(schemaName.lastIndexOf("/") + 1, schemaName.length());
                int loShp = schemaName.lastIndexOf(".shp");
                String name = file.toString();
                String dir = file.toString().substring(0, file.toString().lastIndexOf("/") + 1);
                name = name.substring(name.lastIndexOf("/") + 1, name.length());
                int li = name.lastIndexOf("_") + 1;
                int lo = name.lastIndexOf(".shp");
                String saveEndName = name.substring(li, lo);
                name = String.valueOf(name.substring(0, li)) + ft.getTypeName() + "_" + saveEndName;
                name = name.replace(" ", "_");
                File shapeFile = new File(String.valueOf(dir) + name + ".shp");
                URL shapeURL = shapeFile.toURI().toURL();
                Map<String, URL> map = Collections.singletonMap("url", shapeURL);
                FileDataStoreFactorySpi factory = FileDataStoreFinder.getDataStoreFactory((String)"shp");
                DataStore dataStore = factory.createNewDataStore(map);
                dataStore.createSchema((FeatureType)ft);
                SimpleFeatureStore featureStore = (SimpleFeatureStore)DataStoreFinder.getDataStore(map).getFeatureSource(name);
                featureStore.setTransaction((Transaction)t);
                SimpleFeatureCollection collection = featureSource.getFeatures();
                featureStore.addFeatures((FeatureCollection)collection);
                t.commit();
                t.close();
            }
        }
        catch (Exception eek) {
            eek.printStackTrace();
            try {
                t.rollback();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void exportSVG(MapContent map, ReferencedEnvelope env, OutputStream out, Dimension canvasSize) throws IOException, ParserConfigurationException {
        SVGGeneratorContext ctx1;
        if (canvasSize == null) {
            canvasSize = new Dimension(6400, 3600);
        }
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        document = db.getDOMImplementation().createDocument(null, "svg", null);
        SVGGeneratorContext ctx = ctx1 = SVGGeneratorContext.createDefault((Document)document);
        ctx.setComment("Generated by GeoTools2 with Batik SVG Generator");
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, true);
        g2d.setSVGCanvasSize(canvasSize);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        Rectangle outputArea = new Rectangle(g2d.getSVGCanvasSize());
        ReferencedEnvelope dataArea = map.getMaxBounds();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        renderer.paint((Graphics2D)g2d, outputArea, dataArea);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(out, "UTF-8");
            g2d.stream((Writer)osw);
        }
        finally {
            if (osw != null) {
                osw.close();
            }
        }
    }
}

