/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.dat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Cluster;

public class DATFile {
    private static final Logger logger = LoggerFactory.getLogger(DATFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static <E> void exportToDAT(Graph<E> source, String fileName) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), DEFAULT_CHARSET_NAME));
                String datString = GraphReporter.getRawMatrixStrings(source).toString();
                out.print(datString);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + fileName + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + fileName + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static Graph<Cluster<Individual>> load(File file) throws PuckException {
        Graph<Cluster<Individual>> result = DATFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Graph<Cluster<Individual>> load(File file, String charsetName) throws PuckException {
        Graph<Cluster<Individual>> result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = DATFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Graph<Cluster<Individual>> read(BufferedReader in) throws PuckException {
        Graph<Cluster<Individual>> result;
        try {
            in.mark(100000);
            String line = in.readLine();
            String[] tokens = line.split("\t");
            result = new Graph<Cluster<Individual>>(0, Array.getLength(tokens));
            int tokenIndex = 0;
            while (tokenIndex < Array.getLength(tokens)) {
                result.addNode(tokenIndex + 1, null);
                ++tokenIndex;
            }
            in.reset();
            int lineCount = 0;
            boolean ended = false;
            while (!ended) {
                String line2 = in.readLine();
                if (line2 == null) {
                    ended = true;
                    continue;
                }
                ++lineCount;
                String[] tokens2 = line2.split("\t");
                int tokenIndex2 = 0;
                while (tokenIndex2 < tokens2.length) {
                    double weight = Double.parseDouble(tokens2[tokenIndex2]);
                    if (weight != 0.0) {
                        result.addArcWeight(lineCount, tokenIndex2 + 1, weight);
                    }
                    ++tokenIndex2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading DAT line.", new Object[0]);
        }
        return result;
    }
}

