/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.evo;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import org.tip.puck.evo.ProgSet;

public abstract class Generator
implements Comparable<Generator> {
    protected int nodeCount;
    protected int edgeCount;
    protected int cycle;
    protected int curEdges;
    protected ProgSet progset;
    protected int progcount;
    public boolean simulated;
    public double fitness;
    public double postFitness;
    private Vector<ProgSet> executionPaths;
    protected boolean checkPaths;

    public Generator(int nodeCount, int edgeCount) {
        this.nodeCount = nodeCount;
        this.edgeCount = edgeCount;
        this.cycle = 0;
        this.progset = null;
        this.simulated = false;
        this.fitness = 0.0;
        this.postFitness = 0.0;
        this.checkPaths = false;
    }

    public abstract Generator clone();

    public abstract void createProgSet();

    public abstract void run();

    public abstract double distance(Generator var1);

    public void copy(Generator generator) {
    }

    public String paramsString() {
        return "";
    }

    public void initProgs() {
        this.createProgSet();
        this.progset.init();
    }

    public void initProgsRandom() {
        this.createProgSet();
        this.progset.initRandom();
    }

    public Generator recombine(Generator parent2) {
        Generator generator = null;
        generator = this.clone();
        generator.progset = this.progset.recombine(parent2.progset);
        return generator;
    }

    public Generator cloneProgs() {
        Generator generator = null;
        generator = this.clone();
        generator.progset = this.progset.clone(true);
        return generator;
    }

    public int genotypeSize() {
        return this.progset.size();
    }

    public void writeProgs(String filePath) throws IOException {
        FileOutputStream fos = new FileOutputStream(filePath);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        this.progset.write(out, false);
        out.close();
        fos.close();
    }

    public void printProgs(boolean evalStats) {
        this.progset.print(evalStats);
    }

    public void loadProgs(String filePath) throws IOException {
        this.createProgSet();
        this.progset.load(filePath);
    }

    public void dynPruning() {
        this.progset.dynPruning();
    }

    public void progsClearBranching() {
        this.progset.clearBranching();
    }

    public boolean progsCompareBranching(Generator generator) {
        return this.progset.compareBranching(generator.progset);
    }

    public int executionPath(ProgSet ps) {
        int pos = 0;
        for (ProgSet path : this.executionPaths) {
            if (ps.compareBranching(path)) {
                return pos;
            }
            ++pos;
        }
        this.executionPaths.add(ps.clone(true));
        return pos;
    }

    public void clearExecutionPaths() {
        this.executionPaths.clear();
    }

    @Override
    public int compareTo(Generator generator) {
        if (this.fitness < generator.fitness) {
            return -1;
        }
        if (this.fitness > generator.fitness) {
            return 1;
        }
        return 0;
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public void setSimulated(boolean simulated) {
        this.simulated = simulated;
    }

    public double getPostFitness() {
        return this.postFitness;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setCheckPaths(boolean checkPaths) {
        this.checkPaths = checkPaths;
        if (checkPaths) {
            this.executionPaths = new Vector();
        }
    }

    public Vector<ProgSet> getExecutionPaths() {
        return this.executionPaths;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public void setEdgeCount(int edgeCount) {
        this.edgeCount = edgeCount;
    }

    public ProgSet getProgset() {
        return this.progset;
    }
}

