/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PuckException
extends Exception {
    private static final long serialVersionUID = -5156031052993724552L;
    public static final int NOCODE = 0;
    private int code;

    public PuckException() {
        this.code = 0;
    }

    public PuckException(int code, String message) {
        super(message);
        this.code = code;
    }

    public PuckException(int code, String message, Exception exception) {
        super(message, exception);
        this.code = code;
    }

    public int getCode() {
        int result = this.code;
        return result;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String toString() {
        String result = this.getCause() == null ? MessageFormat.format("[code={0}]: {1}", this.getCode(), this.getMessage()) : MessageFormat.format("[code={0}]: {1} <= {2}", this.getCode(), this.getMessage(), this.getCause().toString());
        return result;
    }

    public String toString(StackTraceElement caller) {
        String result = caller == null ? this.toString() : MessageFormat.format("{0} line {1} {2}", PuckException.shrink(caller.getClassName()), caller.getLineNumber(), this.toString());
        return result;
    }

    public static PuckException getInstance(StackTraceElement caller, int code, String message, Exception exception) {
        PuckException result = new PuckException(code, message, exception);
        Logger.getLogger(PuckException.class).error((Object)result.toString(caller));
        return result;
    }

    public static String shrink(String source) {
        String result;
        if (StringUtils.isBlank((CharSequence)source)) {
            result = null;
        } else {
            String[] tokens = source.split("\\.");
            StringBuffer buffer = new StringBuffer(source.length());
            int tokenCount = 0;
            while (tokenCount < tokens.length - 2) {
                buffer.append(tokens[tokenCount].substring(0, 1));
                buffer.append('.');
                ++tokenCount;
            }
            if (tokens.length >= 2) {
                buffer.append(tokens[tokens.length - 2]);
                buffer.append('.');
            }
            if (tokens.length >= 1) {
                buffer.append(tokens[tokens.length - 1]);
            }
            result = buffer.toString();
        }
        return result;
    }
}

