package org.tip.puck.geo.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;

import com.vividsolutions.jts.geom.Coordinate;

import fr.devinsy.util.StringList;

public class PlaceFile {
	
	static private final Logger logger = LoggerFactory.getLogger(PlaceFile.class);
	public static final String DEFAULT_CHARSET_NAME = "8859_1";//"UTF-8";
	public static final int MAX_LINE_SIZE = 2048;
	
/*	public static void convertGeography (Geography geography){
		
		StringList result = new StringList();
		Map<String,StringList> homonymLists = geography.homonymLists();
				
		for (Place place: geography.getPlaces()) {
			String sup = "";
			if (place.getSup()!=null){
				sup = place.getSup().getTogoToponym();
			}
			
			String homonyms = "";
			StringList homonymList = homonymLists.get(place.getId());
			if (homonymList != null){
				for (String homonym : homonymList){
					if (homonyms.length()!=0){
						homonyms+= ";";
					}
					homonyms += homonym;
				}
			}
					
			result.appendln(place.getTogoToponym()+"\t\t\t\t\t"+place.getLevel()+"\t"+sup+"\t\t"+homonyms+"\t");
		}
		result.sort();

		
		for (String line : result){
			System.out.println(line);
		}
	}*/

	public static Geography loadGeoData(File file) throws PuckException{
		Geography result;
		
		result = null;
		
		BufferedReader in = null;
		try {
			in = new BufferedReader(new InputStreamReader(new FileInputStream(file), DEFAULT_CHARSET_NAME));
			result = readGeoData(in);
		} catch (UnsupportedEncodingException exception) {
			throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]");
		} catch (FileNotFoundException exception) {
			throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]");
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (IOException exception) {
				logger.warn("Not managed error.");
				exception.printStackTrace();
			}
		}
		//
		return result;
	}
	
	private static Geography readGeoData(BufferedReader in) throws PuckException{
		Geography result;
		
		result = new Geography();
		Place world = new Place(GeoLevel.INTERCONTINENTAL, "World");
		result.put(world);
		
		boolean ended = false;
		while (!ended) {
			//
			try {
				//
				in.mark(MAX_LINE_SIZE);
				String line = readNotEmptyLine(in);

				if (line != null) {
					String[] tokens = line.split("\\t");
					Place place = null;
					Place supPlace = world;
					for (int i=0;i<7;i++){
						GeoLevel level = GeoLevel.values()[i+1];
						String name = tokens[i];
						if (!StringUtils.isBlank(name)){
							String id = name;
							if (supPlace != null) {
								id += " / " + supPlace.getName();
							}
							place = result.get(level,id);
							if (place == null){
								place = new Place(level,name);
								if (supPlace != null) {
									place.setSup(supPlace);
								}
								result.put(place);
							}
							supPlace = place;
							place = null;
						}
					}
					result.put(tokens[7], supPlace);
										
					if (tokens.length==10){
						supPlace.setCoordinate(new Coordinate(Double.parseDouble(tokens[9]), Double.parseDouble(tokens[8])));
					}
					supPlace = world;
				} else {
					ended = true;
				}
			} catch (final IOException exception) {
				throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.");
			}
		}
		//
		result.updateDistricts();
		//
		return result;
	}


/*		static public PlaceLine readPlaceLine(final BufferedReader in) throws PuckException {
			PlaceLine result;
			
			result = new PlaceLine();

			try {
				//
				in.mark(MAX_LINE_SIZE);
				String line = readNotEmptyLine(in);

				if (line != null) {
					String[] tokens = line.split("\\t");
					Place place = null;
					for (int i=0;i<tokens.length;i++){
						Geo level = Geo.values()[i];
						String name = tokens[i];
						
					}
					
					
					
					
					
				} else {
					in.reset();
					result = null;
				}
			} catch (final IOException exception) {
				throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.");
			}

			//
			return result;
		}*/
	

	/**
	 * Reads a not empty line from a BufferedReader.
	 * 
	 * @param in
	 *            The source of reading.
	 * 
	 * @return a not empty line or null.
	 * 
	 * @throws PuckException
	 */
	static public String readNotEmptyLine(final BufferedReader in) throws PuckException {
		String result;

		try {
			boolean ended = false;
			result = null;
			while (!ended) {
				//
				String line = in.readLine();

				if (line == null) {
					ended = true;
					result = null;
				} else if (StringUtils.isNotBlank(line)) {
					ended = true;
					result = line;
				}
			}
		} catch (final IOException exception) {
			throw PuckExceptions.IO_ERROR.create(exception, "Reading line.");
		}

		//
		return result;
	}

}
