/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.iurtxts;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckgui.views.ConfirmOverwriteDialog;

public class ExportIURTXTSFileSelector
extends JFileChooser {
    private static final long serialVersionUID = 3969592136506847881L;
    private static final Logger logger = LoggerFactory.getLogger(ExportIURTXTSFileSelector.class);
    private File sourceFile;

    public ExportIURTXTSFileSelector(File sourceFile) {
        this.sourceFile = sourceFile;
        File file = sourceFile == null || StringUtils.isBlank((CharSequence)sourceFile.getAbsolutePath()) ? null : sourceFile.getParentFile();
        this.setCurrentDirectory(file);
        this.setDialogTitle("Export to IURTXTS format");
        this.setFileSelectionMode(1);
        this.setAcceptAllFileFilterUsed(false);
        this.setApproveButtonText("Export");
        this.setDialogType(2);
    }

    @Override
    public void approveSelection() {
        File targetFile = this.getSelectedFile();
        logger.debug("getCurrentDirectory(): {}", (Object)this.getCurrentDirectory());
        logger.debug("selectedFile={}", (Object)targetFile);
        File oneFile = new File(targetFile, String.valueOf(FilenameUtils.getBaseName((String)this.sourceFile.getName())) + "-01-individuals.iurs.txt");
        logger.debug("oneFile={}", (Object)oneFile);
        if (oneFile.exists()) {
            if (ConfirmOverwriteDialog.showDialog(null)) {
                logger.debug("Overwrite");
                super.approveSelection();
            } else {
                logger.debug("Cancel overwrite");
            }
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void cancelSelection() {
        logger.debug("Cancel selection.");
        super.cancelSelection();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
        System.out.println("==== SET SELECTED FILE=================");
        System.out.println("SELECED FILE " + file);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.resetChoosableFileFilters();
        }
    }

    public static File showSelectorDialog(Component parent, File targetFile) {
        File result;
        ExportIURTXTSFileSelector selector = new ExportIURTXTSFileSelector(targetFile);
        if (selector.showDialog(parent, null) == 0) {
            logger.debug("getCurrentDirectory(): {}", (Object)selector.getCurrentDirectory());
            logger.debug("getSelectedFile() : {}", (Object)selector.getSelectedFile());
            result = selector.getSelectedFile();
        } else {
            result = null;
        }
        return result;
    }
}

