/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geographyEditor;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.flatdb4geonames.model.FlatDB4GeoNames;
import org.tip.flatdb4geonames.model.FlatDB4GeoNamesException;
import org.tip.flatdb4geonames.model.GeoNamesLine;
import org.tip.flatdb4geonames.model.GeoNamesLines;
import org.tip.flatdb4geonames.model.GeoNamesSearchCriteria;
import org.tip.flatdb4geonames.model.index.FeatureClass;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.geo2.GeoLevel2;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.Places2;
import org.tip.puck.geo2.io.GEOFile;
import org.tip.puck.net.workers.AttributeValueDescriptor;
import org.tip.puck.net.workers.AttributeValueDescriptors;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.report.Report;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.util.ProgressStatus;
import org.tip.puckgui.views.geographyEditor.AutoFillProgressDialog;
import org.tip.puckgui.views.geographyEditor.CoordinateValueRenderer;
import org.tip.puckgui.views.geographyEditor.GeoNamesLineModel;
import org.tip.puckgui.views.geographyEditor.GeographyExportFileSelector;
import org.tip.puckgui.views.geographyEditor.GeographyImportFileSelector;
import org.tip.puckgui.views.geographyEditor.PlaceLineModel;

public class GeographyEditorPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(GeographyEditorPanel.class);
    private static final long serialVersionUID = -8229975159547539454L;
    private NetGUI netGUI;
    private Filter filter;
    private AttributeValueDescriptors valueDescriptors;
    private JTable tblPlaceLines;
    private final ButtonGroup buttonGroupFilter = new ButtonGroup();
    private JLabel lblStatusValue;
    private JLabel lblConflictedValue;
    private JLabel lblUngeocodedValue;
    private JLabel lblSelectionValue;
    private JTable tblResults;
    private JTextField txtfldInput;
    private JCheckBox chckbxCountryStateRegion;
    private JCheckBox chckbxStreamLake;
    private JCheckBox chckbxParkArea;
    private JCheckBox chckbxCityVillage;
    private JCheckBox chckbxSpotBuildingFarm;
    private JCheckBox chckbxMountainHillRock;
    private JCheckBox chckbxUndersea;
    private JCheckBox chckbxForestHeath;
    private JButton btnSearch;
    private JButton btnSearchToponyms;
    private JButton btnSearchToponym;
    private JButton btnAutoFill;

    public GeographyEditorPanel(final NetGUI parentGUI) {
        this.netGUI = parentGUI;
        if (parentGUI.getNet().getGeography2() == null) {
            parentGUI.getNet().setGeography2(new Geography2());
        }
        this.filter = Filter.ALL;
        this.valueDescriptors = AttributeWorker.getExogenousAttributeValueDescriptors(parentGUI.getNet(), ".*_PLAC.*");
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelContent = new JPanel();
        this.add(panelContent);
        panelContent.setLayout(new BoxLayout(panelContent, 1));
        JSplitPane splitPane = new JSplitPane();
        panelContent.add(splitPane);
        splitPane.setOrientation(0);
        JPanel panelGeography = new JPanel();
        panelGeography.setMinimumSize(new Dimension(10, 300));
        splitPane.setLeftComponent(panelGeography);
        panelGeography.setLayout(new BorderLayout(0, 0));
        JPanel panelControls = new JPanel();
        panelControls.setBorder(new EmptyBorder(0, 0, 5, 0));
        panelGeography.add((Component)panelControls, "North");
        panelControls.setLayout(new BoxLayout(panelControls, 0));
        JPanel panelStats = new JPanel();
        panelStats.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Stats", 4, 2, null, null));
        panelControls.add(panelStats);
        panelStats.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblStatus = new JLabel("Status:");
        panelStats.add((Component)lblStatus, "2, 2, right, default");
        this.lblStatusValue = new JLabel("");
        this.lblStatusValue.setOpaque(true);
        panelStats.add((Component)this.lblStatusValue, "4, 2");
        JLabel lblConflicted = new JLabel("Conflicted:");
        panelStats.add((Component)lblConflicted, "2, 4, right, default");
        this.lblConflictedValue = new JLabel("");
        panelStats.add((Component)this.lblConflictedValue, "4, 4");
        JLabel lblUngeocoded = new JLabel("Ungeocoded:");
        panelStats.add((Component)lblUngeocoded, "2, 6, right, default");
        this.lblUngeocodedValue = new JLabel("");
        panelStats.add((Component)this.lblUngeocodedValue, "4, 6");
        JPanel panelButtons = new JPanel();
        panelControls.add(panelButtons);
        panelButtons.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Actions", 4, 2, null, null));
        panelButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JButton btnClearAll = new JButton("Clear All");
        btnClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String message = "CAUTION: this action will delete all places.\n\nDo you really want delete all places?";
                int answer = JOptionPane.showConfirmDialog(GeographyEditorPanel.this, message, "Confirm dialog", 2);
                if (answer == 0) {
                    Geography2 geography = parentGUI.getNet().getGeography2();
                    geography.clear();
                    GeographyEditorPanel.this.updatePlaceLines();
                }
            }
        });
        panelButtons.add((Component)btnClearAll, "2, 2");
        JButton btnImport = new JButton("Import\u2026");
        btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Geography2 geography;
                    File sourceFile = GeographyImportFileSelector.showSelectorDialog(GeographyEditorPanel.this, parentGUI.getFile().getParentFile());
                    if (sourceFile != null && (geography = GEOFile.load(sourceFile)) != null) {
                        logger.debug("geography.place count=" + geography.countOfPlaces());
                        parentGUI.getNet().setGeography2(geography);
                        GeographyEditorPanel.this.updatePlaceLines();
                        parentGUI.setChanged(true);
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case FILE_NOT_FOUND: {
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.fileNotFound");
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            break;
                        }
                        case BAD_FILE_FORMAT: {
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.badFileFormat");
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            break;
                        }
                        case UNSUPPORTED_FILE_FORMAT: {
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedFileFormat");
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            break;
                        }
                        case NOT_A_FILE: {
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.notAFile");
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.unsupportedEncoding");
                            JOptionPane.showMessageDialog(null, message, title, 0);
                            break;
                        }
                        default: {
                            String message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.default");
                            JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.openFileError.title");
                    String message = "Error loading file.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                }
            }
        });
        JButton btnAdd = new JButton("Add from attributes");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                StringList message = new StringList();
                message.append("<html>");
                message.append("<br/>");
                message.append("<p>This action will add places automatically.</p>");
                message.append("<p>Places are added exploring attributes from individuals, <br/>");
                message.append("families and relations of the current net.</p>");
                message.append("<p>For each attribute with label containing \"_PLAC\" pattern,<br/> a place will be added. ");
                message.append("If a place is already existing<br/> then its uses counter is incremented.<p/>");
                message.append("<br/>");
                message.append("<p>Run auto add from attributes now?</p>");
                message.append("</html>");
                int answer = JOptionPane.showConfirmDialog(GeographyEditorPanel.this, message.toString(), "Confirm dialog", 2);
                if (answer == 0) {
                    Geography2 geography = parentGUI.getNet().getGeography2();
                    int count = 0;
                    for (AttributeValueDescriptor valueDescriptor : GeographyEditorPanel.this.valueDescriptors) {
                        if (geography.contains(valueDescriptor.getValue())) continue;
                        geography.addPlace(new Place2(valueDescriptor.getValue()));
                        ++count;
                    }
                    ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).setSource(geography.getPlaces());
                    GeographyEditorPanel.this.refreshStats();
                    ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).fireTableDataChanged();
                    String title = "Action done";
                    String endMessage = "Added places: " + count;
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, endMessage, title, 1);
                }
            }
        });
        JButton btnNewPlace = new JButton("New Place");
        btnNewPlace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).isSet()) {
                    Place2 newPlace = GeographyEditorPanel.this.netGUI.getNet().getGeography2().addPlace(new Place2("New place"));
                    if (GeographyEditorPanel.this.tblPlaceLines.getCellEditor() != null) {
                        GeographyEditorPanel.this.tblPlaceLines.getCellEditor().stopCellEditing();
                    }
                    ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).setNewItem(newPlace);
                    GeographyEditorPanel.this.tblPlaceLines.scrollRectToVisible(GeographyEditorPanel.this.tblPlaceLines.getCellRect(GeographyEditorPanel.this.tblPlaceLines.getModel().getRowCount() - 1, 0, true));
                    GeographyEditorPanel.this.tblPlaceLines.setRowSelectionInterval(GeographyEditorPanel.this.tblPlaceLines.getModel().getRowCount() - 1, GeographyEditorPanel.this.tblPlaceLines.getModel().getRowCount() - 1);
                    GeographyEditorPanel.this.tblPlaceLines.setColumnSelectionInterval(0, 0);
                    GeographyEditorPanel.this.tblPlaceLines.editCellAt(GeographyEditorPanel.this.tblPlaceLines.getModel().getRowCount() - 1, 0);
                    GeographyEditorPanel.this.tblPlaceLines.getEditorComponent().requestFocus();
                    GeographyEditorPanel.this.refreshStats();
                }
            }
        });
        panelButtons.add((Component)btnNewPlace, "4, 2");
        panelButtons.add((Component)btnAdd, "6, 2");
        panelButtons.add((Component)btnImport, "8, 2");
        JButton btnExport = new JButton("Export\u2026");
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    String targetFileName = parentGUI.getFile() == null ? "untitled.geo.csv" : String.valueOf(FilenameUtils.removeExtension((String)parentGUI.getFile().getAbsolutePath())) + ".geo.csv";
                    File targetFile = GeographyExportFileSelector.showSelectorDialog(GeographyEditorPanel.this, new File(targetFileName));
                    if (targetFile != null) {
                        GEOFile.save(targetFile, parentGUI.getNet().getGeography2());
                    }
                }
                catch (PuckException exception) {
                    String message;
                    String title = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.title");
                    switch (PuckExceptions.valueOf(exception.getCode())) {
                        case UNSUPPORTED_FILE_FORMAT: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedFileFormat");
                            break;
                        }
                        case NOT_A_FILE: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.notAFile");
                            break;
                        }
                        case UNSUPPORTED_ENCODING: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.unsupportedEncoding");
                            break;
                        }
                        default: {
                            message = ResourceBundle.getBundle("org.tip.puckgui.messages").getString("dialog.saveFileError.default");
                        }
                    }
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                }
            }
        });
        this.btnAutoFill = new JButton("Auto Fill\u2026");
        this.btnAutoFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AutoFillProgressDialog.showDialog(GeographyEditorPanel.this, ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).getSource());
                GeographyEditorPanel.this.refreshStats();
                ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).fireTableDataChanged();
            }
        });
        JButton btnDeletePlace = new JButton("Delete Place");
        btnDeletePlace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRowIds;
                logger.debug("Delete place" + ArrayUtils.toString((Object)GeographyEditorPanel.this.tblPlaceLines.getSelectedRows()));
                if (GeographyEditorPanel.this.tblPlaceLines.getCellEditor() != null) {
                    GeographyEditorPanel.this.tblPlaceLines.getCellEditor().stopCellEditing();
                }
                if ((selectedRowIds = GeographyEditorPanel.this.tblPlaceLines.getSelectedRows()).length > 0) {
                    ArrayUtils.reverse((int[])selectedRowIds);
                    int[] nArray = selectedRowIds;
                    int n = selectedRowIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int rowIndex = nArray[n2];
                        Place2 deletedPlace = ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).removeItem(rowIndex);
                        GeographyEditorPanel.this.netGUI.getNet().getGeography2().removePlace(deletedPlace);
                        ++n2;
                    }
                    GeographyEditorPanel.this.tblPlaceLines.changeSelection(selectedRowIds[0], 0, false, false);
                }
                GeographyEditorPanel.this.refreshStats();
            }
        });
        JButton btnStatistics = new JButton("Statistics");
        btnStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Report report = StatisticsReporter.reportGeographyStatistics(parentGUI.getNet());
                parentGUI.addReportTab(report);
            }
        });
        panelButtons.add((Component)btnStatistics, "2, 4");
        panelButtons.add((Component)btnDeletePlace, "4, 4");
        panelButtons.add((Component)this.btnAutoFill, "6, 4");
        panelButtons.add((Component)btnExport, "8, 4");
        JPanel panelFilters = new JPanel();
        panelControls.add(panelFilters);
        panelFilters.setBorder(new TitledBorder(null, "Filters", 4, 2, null, null));
        panelFilters.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(50dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JRadioButton rdbtnAll = new JRadioButton("All");
        rdbtnAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeographyEditorPanel.this.setFilter(Filter.ALL);
            }
        });
        rdbtnAll.setSelected(true);
        this.buttonGroupFilter.add(rdbtnAll);
        panelFilters.add((Component)rdbtnAll, "2, 2");
        JRadioButton rdbtnConflictual = new JRadioButton("Conflictual");
        rdbtnConflictual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeographyEditorPanel.this.setFilter(Filter.CONFLICTUAL);
            }
        });
        this.buttonGroupFilter.add(rdbtnConflictual);
        panelFilters.add((Component)rdbtnConflictual, "4, 2");
        JRadioButton rdbtnBlank = new JRadioButton("Blank");
        rdbtnBlank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeographyEditorPanel.this.setFilter(Filter.BLANK);
            }
        });
        JRadioButton rdbtnUnused = new JRadioButton("Unused");
        rdbtnUnused.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeographyEditorPanel.this.setFilter(Filter.UNUSED);
            }
        });
        this.buttonGroupFilter.add(rdbtnUnused);
        panelFilters.add((Component)rdbtnUnused, "6, 2");
        this.buttonGroupFilter.add(rdbtnBlank);
        panelFilters.add((Component)rdbtnBlank, "2, 4");
        JRadioButton rdbtnUngeocoded = new JRadioButton("Ungeocoded");
        rdbtnUngeocoded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeographyEditorPanel.this.setFilter(Filter.UNGEOCODED);
            }
        });
        this.buttonGroupFilter.add(rdbtnUngeocoded);
        panelFilters.add((Component)rdbtnUngeocoded, "4, 4");
        JPanel panel = new JPanel();
        panelFilters.add((Component)panel, "2, 6, 5, 1, fill, fill");
        panel.setLayout(new BoxLayout(panel, 0));
        JLabel lblSelection = new JLabel("Selection:");
        panel.add(lblSelection);
        this.lblSelectionValue = new JLabel("");
        panel.add(this.lblSelectionValue);
        JScrollPane scrollPanePlaces = new JScrollPane();
        panelGeography.add((Component)scrollPanePlaces, "Center");
        scrollPanePlaces.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        scrollPanePlaces.setVerticalScrollBarPolicy(22);
        scrollPanePlaces.setAlignmentX(0.0f);
        this.tblPlaceLines = new JTable(){

            @Override
            public boolean editCellAt(int row, int column, EventObject event) {
                boolean result = super.editCellAt(row, column, event);
                final Component editor = this.getEditorComponent();
                if (editor != null && editor instanceof JTextComponent) {
                    if (event == null) {
                        ((JTextComponent)editor).selectAll();
                    } else if (event instanceof KeyEvent) {
                        ((JTextComponent)editor).selectAll();
                    } else if (event instanceof ActionEvent) {
                        ((JTextComponent)editor).selectAll();
                    } else if (event instanceof MouseEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((JTextComponent)editor).selectAll();
                            }
                        });
                    }
                }
                return result;
            }
        };
        this.tblPlaceLines.setCellSelectionEnabled(true);
        this.tblPlaceLines.setFillsViewportHeight(true);
        this.tblPlaceLines.setSelectionMode(0);
        scrollPanePlaces.setViewportView(this.tblPlaceLines);
        this.tblPlaceLines.setModel(new PlaceLineModel(parentGUI.getNet().getGeography2().getPlaces(), this.valueDescriptors));
        this.tblPlaceLines.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                GeographyEditorPanel.this.netGUI.setChanged(true);
                GeographyEditorPanel.this.netGUI.getNet().getGeography2().rebuildIndexes();
                GeographyEditorPanel.this.refreshStats();
            }
        });
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.tblPlaceLines.getColumnModel().getColumn(1).setMinWidth(50);
        this.tblPlaceLines.getColumnModel().getColumn(1).setMaxWidth(50);
        this.tblPlaceLines.getColumnModel().getColumn(1).setResizable(false);
        this.tblPlaceLines.getColumnModel().getColumn(2).setMinWidth(90);
        this.tblPlaceLines.getColumnModel().getColumn(2).setMaxWidth(90);
        this.tblPlaceLines.getColumnModel().getColumn(2).setResizable(false);
        this.tblPlaceLines.getColumnModel().getColumn(2).setCellRenderer(new CoordinateValueRenderer());
        this.tblPlaceLines.getColumnModel().getColumn(3).setMinWidth(90);
        this.tblPlaceLines.getColumnModel().getColumn(3).setMaxWidth(90);
        this.tblPlaceLines.getColumnModel().getColumn(3).setResizable(false);
        this.tblPlaceLines.getColumnModel().getColumn(3).setCellRenderer(new CoordinateValueRenderer());
        this.tblPlaceLines.getColumnModel().getColumn(4).setMinWidth(50);
        this.tblPlaceLines.getColumnModel().getColumn(4).setMaxWidth(50);
        this.tblPlaceLines.getColumnModel().getColumn(4).setResizable(false);
        DefaultCellEditor editor = new DefaultCellEditor(new JComboBox<GeoLevel2>(GeoLevel2.values()));
        this.tblPlaceLines.getColumnModel().getColumn(5).setCellEditor(editor);
        this.tblPlaceLines.getColumnModel().getColumn(5).setCellRenderer(centerRenderer);
        this.tblPlaceLines.getColumnModel().getColumn(5).setMinWidth(100);
        this.tblPlaceLines.getColumnModel().getColumn(5).setMaxWidth(130);
        this.tblPlaceLines.getColumnModel().getColumn(5).setResizable(true);
        this.tblPlaceLines.getColumnModel().getColumn(7).setMinWidth(50);
        this.tblPlaceLines.getColumnModel().getColumn(7).setPreferredWidth(80);
        this.tblPlaceLines.getColumnModel().getColumn(7).setMaxWidth(200);
        this.tblPlaceLines.getColumnModel().getColumn(7).setResizable(true);
        JPanel panelGeoNames = new JPanel();
        panelGeoNames.setBorder(new TitledBorder(null, "GeoNames", 4, 2, null, null));
        splitPane.setRightComponent(panelGeoNames);
        panelGeoNames.setLayout(new BorderLayout(0, 0));
        JPanel panelGeonamesControls = new JPanel();
        panelGeoNames.add((Component)panelGeonamesControls, "North");
        panelGeonamesControls.setLayout(new BoxLayout(panelGeonamesControls, 0));
        JPanel panelGeonamesButtons = new JPanel();
        panelGeonamesControls.add(panelGeonamesButtons);
        panelGeonamesButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.btnSearchToponym = new JButton("Search Toponym");
        this.btnSearchToponym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Place2 place = GeographyEditorPanel.this.getSelectedPlace();
                if (place == null) {
                    String title = "Search Issue";
                    String message = "Unselected place. Please select a place in Geography table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                } else {
                    GeographyEditorPanel.this.txtfldInput.setText(place.getToponym());
                    GeographyEditorPanel.this.performSearch();
                }
            }
        });
        panelGeonamesButtons.add((Component)this.btnSearchToponym, "2, 2, default, top");
        JPanel panelFeatureClass = new JPanel();
        panelFeatureClass.setBorder(new TitledBorder(null, "Feature Class", 4, 2, null, null));
        panelGeonamesButtons.add((Component)panelFeatureClass, "4, 2, 1, 5, fill, fill");
        panelFeatureClass.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.chckbxCountryStateRegion = new JCheckBox("Country State Region");
        this.chckbxCountryStateRegion.setSelected(true);
        panelFeatureClass.add((Component)this.chckbxCountryStateRegion, "2, 2");
        this.chckbxParkArea = new JCheckBox("Park Area");
        panelFeatureClass.add((Component)this.chckbxParkArea, "4, 2");
        this.chckbxSpotBuildingFarm = new JCheckBox("Spot Building Farm");
        panelFeatureClass.add((Component)this.chckbxSpotBuildingFarm, "6, 2");
        this.chckbxUndersea = new JCheckBox("Undersea");
        panelFeatureClass.add((Component)this.chckbxUndersea, "8, 2");
        this.chckbxStreamLake = new JCheckBox("Stream Lake");
        panelFeatureClass.add((Component)this.chckbxStreamLake, "2, 4");
        this.chckbxCityVillage = new JCheckBox("City Village");
        panelFeatureClass.add((Component)this.chckbxCityVillage, "4, 4");
        this.chckbxMountainHillRock = new JCheckBox("Mountain Hill Rock");
        panelFeatureClass.add((Component)this.chckbxMountainHillRock, "6, 4");
        this.chckbxForestHeath = new JCheckBox("Forest Heath");
        panelFeatureClass.add((Component)this.chckbxForestHeath, "8, 4");
        JButton btnSetCoordinate = new JButton("Set Coordinate");
        btnSetCoordinate.setToolTipText("Set Coordinate");
        btnSetCoordinate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeoNamesLine result = GeographyEditorPanel.this.getSelectedResult();
                Place2 place = GeographyEditorPanel.this.getSelectedPlace();
                if (result == null && ((GeoNamesLineModel)GeographyEditorPanel.this.tblResults.getModel()).getRowCount() == 1) {
                    result = (GeoNamesLine)((GeoNamesLineModel)GeographyEditorPanel.this.tblResults.getModel()).getSource().get(0);
                }
                if (result == null) {
                    String title = "Set Issue";
                    String message = "Unselected result. Please select a result in GeoNames table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                } else if (place == null) {
                    String title = "Set Issue";
                    String message = "Unselected place. Please select a place in Geography table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                } else {
                    place.setLatitude(result.getLatitude());
                    place.setLongitude(result.getLongitude());
                    place.setElevation(result.getElevation());
                    int rowIndex = GeographyEditorPanel.this.tblPlaceLines.getSelectedRow();
                    if (rowIndex != -1) {
                        ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).fireTableRowsUpdated(rowIndex, rowIndex);
                    }
                }
            }
        });
        panelGeonamesButtons.add((Component)btnSetCoordinate, "6, 2");
        this.btnSearchToponyms = new JButton("Search Toponyms");
        this.btnSearchToponyms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Place2 place = GeographyEditorPanel.this.getSelectedPlace();
                if (place == null) {
                    String title = "Search Issue";
                    String message = "Unselected place. Please select a place in Geography table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                } else {
                    GeographyEditorPanel.this.txtfldInput.setText(place.getToponyms().toStringWithCommas());
                    GeographyEditorPanel.this.performSearch();
                }
            }
        });
        panelGeonamesButtons.add((Component)this.btnSearchToponyms, "2, 4");
        this.txtfldInput = new JTextField();
        this.txtfldInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    logger.debug("enter pressed");
                    GeographyEditorPanel.this.btnSearch.doClick();
                }
            }
        });
        JButton btnSetAll = new JButton("Set All");
        btnSetAll.setToolTipText("Set Coordinate, Homonyms and Toponym");
        btnSetAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GeoNamesLine result = GeographyEditorPanel.this.getSelectedResult();
                Place2 place = GeographyEditorPanel.this.getSelectedPlace();
                if (result == null && ((GeoNamesLineModel)GeographyEditorPanel.this.tblResults.getModel()).getRowCount() == 1) {
                    result = (GeoNamesLine)((GeoNamesLineModel)GeographyEditorPanel.this.tblResults.getModel()).getSource().get(0);
                }
                if (result == null) {
                    String title = "Set Issue";
                    String message = "Unselected result. Please select a result in GeoNames table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                } else if (place == null) {
                    String title = "Set Issue";
                    String message = "Unselected place. Please select a place in Geography table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 0);
                } else {
                    place.setToponym(result.getName());
                    place.setAlternateToponyms(result.getAlternateNames());
                    place.setLatitude(result.getLatitude());
                    place.setLongitude(result.getLongitude());
                    place.setElevation(result.getElevation());
                    place.setExtraData(GeographyEditorPanel.buildExtraDataValue(result));
                    int rowIndex = GeographyEditorPanel.this.tblPlaceLines.getSelectedRow();
                    if (rowIndex != -1) {
                        ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).fireTableRowsUpdated(rowIndex, rowIndex);
                    }
                }
            }
        });
        JButton btnSetData = new JButton("Set Data");
        btnSetData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GeoNamesLine result = GeographyEditorPanel.this.getSelectedResult();
                Place2 place = GeographyEditorPanel.this.getSelectedPlace();
                if (result == null && ((GeoNamesLineModel)GeographyEditorPanel.this.tblResults.getModel()).getRowCount() == 1) {
                    result = (GeoNamesLine)((GeoNamesLineModel)GeographyEditorPanel.this.tblResults.getModel()).getSource().get(0);
                }
                if (result == null) {
                    String title = "Set Issue";
                    String message = "Unselected result. Please select a result in GeoNames table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 2);
                } else if (place == null) {
                    String title = "Set Issue";
                    String message = "Unselected place. Please select a place in Geography table.";
                    JOptionPane.showMessageDialog(GeographyEditorPanel.this, message, title, 2);
                } else {
                    place.setAlternateToponyms(result.getAlternateNames());
                    place.setLatitude(result.getLatitude());
                    place.setLongitude(result.getLongitude());
                    place.setElevation(result.getElevation());
                    place.setExtraData(GeographyEditorPanel.buildExtraDataValue(result));
                    int rowIndex = GeographyEditorPanel.this.tblPlaceLines.getSelectedRow();
                    if (rowIndex != -1) {
                        ((PlaceLineModel)GeographyEditorPanel.this.tblPlaceLines.getModel()).fireTableRowsUpdated(rowIndex, rowIndex);
                    }
                }
            }
        });
        btnSetData.setToolTipText("Set Coordinate and Homonyms");
        panelGeonamesButtons.add((Component)btnSetData, "6, 4");
        panelGeonamesButtons.add((Component)btnSetAll, "6, 6");
        panelGeonamesButtons.add((Component)this.txtfldInput, "4, 8, fill, default");
        this.txtfldInput.setColumns(10);
        this.btnSearch = new JButton("Search");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeographyEditorPanel.this.performSearch();
            }
        });
        panelGeonamesButtons.add((Component)this.btnSearch, "2, 8");
        JScrollPane scrollPaneResults = new JScrollPane();
        scrollPaneResults.setPreferredSize(new Dimension(3, 300));
        panelGeoNames.add((Component)scrollPaneResults, "Center");
        scrollPaneResults.setAlignmentX(0.0f);
        scrollPaneResults.setVerticalScrollBarPolicy(22);
        this.tblResults = new JTable(){

            @Override
            public String getToolTipText(MouseEvent event) {
                String result = null;
                Point p = event.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                int realColumnIndex = this.convertColumnIndexToModel(colIndex);
                GeoNamesLine line = rowIndex == -1 ? null : (GeoNamesLine)((GeoNamesLineModel)GeographyEditorPanel.this.tblResults.getModel()).getSource().get(rowIndex);
                if (line == null) {
                    result = super.getToolTipText(event);
                } else {
                    switch (realColumnIndex) {
                        case 1: {
                            result = line.getName();
                            break;
                        }
                        case 9: {
                            result = line.getTimeZone();
                            break;
                        }
                        case 2: {
                            if (line.getAlternateNames().isEmpty()) {
                                result = super.getToolTipText(event);
                                break;
                            }
                            result = line.getAlternateNames().toStringList().toStringWithCommas();
                            break;
                        }
                        case 6: {
                            if (FlatDB4GeoNames.isOpened()) {
                                StringList html = new StringList();
                                html.append("<html>");
                                html.append(line.getFeatureCodePath()).append("<br/>");
                                html.append(FlatDB4GeoNames.instance().searchFeatureShortDescription(line.getFeatureCodePath())).append("<br/>");
                                html.append(FlatDB4GeoNames.instance().searchFeatureDescription(line.getFeatureCodePath()));
                                html.append("</html>");
                                result = html.toString();
                                break;
                            }
                            result = super.getToolTipText(event);
                            break;
                        }
                        case 7: {
                            if (FlatDB4GeoNames.isOpened()) {
                                String description = FlatDB4GeoNames.instance().searchAdministrativeToponymPath(line.getAdministrativeShortCodePath());
                                if (description == null) {
                                    result = super.getToolTipText(event);
                                    break;
                                }
                                result = description;
                                break;
                            }
                            result = super.getToolTipText(event);
                            break;
                        }
                        default: {
                            result = super.getToolTipText(event);
                        }
                    }
                }
                return result;
            }
        };
        this.tblResults.setFillsViewportHeight(true);
        scrollPaneResults.setViewportView(this.tblResults);
        this.tblResults.setModel(new GeoNamesLineModel(null));
        this.tblResults.getColumnModel().getColumn(0).setMinWidth(80);
        this.tblResults.getColumnModel().getColumn(0).setMaxWidth(80);
        this.tblResults.getColumnModel().getColumn(0).setResizable(false);
        this.tblResults.getColumnModel().getColumn(3).setMinWidth(90);
        this.tblResults.getColumnModel().getColumn(3).setMaxWidth(90);
        this.tblResults.getColumnModel().getColumn(3).setResizable(false);
        this.tblResults.getColumnModel().getColumn(3).setCellRenderer(new CoordinateValueRenderer());
        this.tblResults.getColumnModel().getColumn(4).setMinWidth(90);
        this.tblResults.getColumnModel().getColumn(4).setMaxWidth(90);
        this.tblResults.getColumnModel().getColumn(4).setResizable(false);
        this.tblResults.getColumnModel().getColumn(4).setCellRenderer(new CoordinateValueRenderer());
        this.tblResults.getColumnModel().getColumn(5).setMinWidth(50);
        this.tblResults.getColumnModel().getColumn(5).setMaxWidth(50);
        this.tblResults.getColumnModel().getColumn(5).setResizable(false);
        this.tblResults.getColumnModel().getColumn(8).setMinWidth(80);
        this.tblResults.getColumnModel().getColumn(8).setMaxWidth(80);
        this.tblResults.getColumnModel().getColumn(8).setResizable(false);
        this.tblResults.getColumnModel().getColumn(7).setMinWidth(130);
        this.tblResults.getColumnModel().getColumn(7).setMaxWidth(130);
        this.tblResults.getColumnModel().getColumn(7).setResizable(false);
        this.tblResults.getColumnModel().getColumn(7).setCellRenderer(centerRenderer);
        this.tblResults.getColumnModel().getColumn(6).setMinWidth(80);
        this.tblResults.getColumnModel().getColumn(6).setMaxWidth(80);
        this.tblResults.getColumnModel().getColumn(6).setResizable(false);
        this.tblResults.getColumnModel().getColumn(6).setCellRenderer(centerRenderer);
        this.tblResults.getColumnModel().getColumn(9).setMinWidth(110);
        this.tblResults.getColumnModel().getColumn(9).setMaxWidth(110);
        this.tblResults.getColumnModel().getColumn(9).setResizable(false);
        JPanel panelClose = new JPanel();
        this.add((Component)panelClose, "South");
        panelClose.setLayout(new BoxLayout(panelClose, 0));
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                parentGUI.closeCurrentTab();
            }
        });
        panelClose.add(btnClose);
        Component horizontalGlue = Box.createHorizontalGlue();
        panelClose.add(horizontalGlue);
        JButton btnSaveButton = new JButton("Save");
        btnSaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        panelClose.add(btnSaveButton);
        this.refreshStats();
        if (!FlatDB4GeoNames.isOpened()) {
            this.btnSearchToponym.setEnabled(false);
            this.btnSearchToponyms.setEnabled(false);
            this.btnSearch.setEnabled(false);
            this.btnAutoFill.setEnabled(false);
            String title = "Configuration missing";
            StringList message = new StringList();
            message.append("<html>");
            message.append("<br/>");
            message.append("<p>Some buttons will be disabled because it is required<br/>a FlatDB4GeoNames configuration.</p>");
            message.append("<br/>");
            message.append("<p>Please, in order to do this action available:<br/>");
            message.append("1. Download database using Menu > Tools > Download database\u2026<br/>");
            message.append("2. Set the database directory in Menu > Edit > Preferences.</p>");
            message.append("<br/>");
            message.append("Then you can use these functionalities.");
            message.append("</html>");
            JOptionPane.showMessageDialog(this, message, title, 2);
        }
    }

    public Place2 getSelectedPlace() {
        int rowIndex = this.tblPlaceLines.getSelectedRow();
        Place2 result = rowIndex == -1 ? null : (Place2)((PlaceLineModel)this.tblPlaceLines.getModel()).getSource().get(rowIndex);
        return result;
    }

    public GeoNamesLine getSelectedResult() {
        int rowIndex = this.tblResults.getSelectedRow();
        GeoNamesLine result = rowIndex == -1 ? null : (GeoNamesLine)((GeoNamesLineModel)this.tblResults.getModel()).getSource().get(rowIndex);
        return result;
    }

    public AttributeValueDescriptors getValuesDescriptors() {
        return this.valueDescriptors;
    }

    public void performSearch() {
        try {
            GeoNamesSearchCriteria criteria = new GeoNamesSearchCriteria();
            criteria.setInput(this.txtfldInput.getText());
            if (this.chckbxCityVillage.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.CITY_VILLAGE);
            }
            if (this.chckbxCountryStateRegion.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.COUNTRY_STATE_REGION);
            }
            if (this.chckbxForestHeath.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.FOREST_HEATH);
            }
            if (this.chckbxMountainHillRock.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.MOUNTAIN_HILL_ROCK);
            }
            if (this.chckbxParkArea.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.PARK_AREA);
            }
            if (this.chckbxSpotBuildingFarm.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.SPOT_BUILDING_FARM);
            }
            if (this.chckbxStreamLake.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.STREAM_LAKE);
            }
            if (this.chckbxUndersea.isSelected()) {
                criteria.featureClasses().add((Object)FeatureClass.UNDERSEA);
            }
            GeoNamesLines lines = FlatDB4GeoNames.instance().search(criteria);
            ((GeoNamesLineModel)this.tblResults.getModel()).setSource(lines);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            String title = "Search Error";
            String message = "Error searching.";
            JOptionPane.showMessageDialog(this, message, title, 0);
        }
        catch (FlatDB4GeoNamesException exception) {
            exception.printStackTrace();
            String title = "Search Error";
            String message = "Error searching.";
            JOptionPane.showMessageDialog(this, message, title, 0);
        }
    }

    public void refreshStats() {
        Color statusColor;
        Geography2.Status status = this.netGUI.getNet().getGeography2().getStatus();
        this.lblStatusValue.setText(String.format(" %s ", status.toString()));
        switch (status) {
            case PERFECT: 
            case COMPLETE: {
                statusColor = Color.GREEN;
                break;
            }
            case WORKABLE: {
                statusColor = Color.ORANGE;
                break;
            }
            default: {
                statusColor = Color.RED;
            }
        }
        this.lblStatusValue.setBackground(statusColor);
        int conflictedCount = this.netGUI.getNet().getGeography2().countOfConflictedPlaces();
        int nameCount = this.netGUI.getNet().getGeography2().countOfToponyms();
        this.lblConflictedValue.setText(String.format("%d / %d names (%s)", conflictedCount, nameCount, ToolBox.buildReadablePercentage(conflictedCount, nameCount)));
        int ungeocodedCount = this.netGUI.getNet().getGeography2().countOfUngeocodedPlaces();
        int placeCount = this.netGUI.getNet().getGeography2().countOfPlaces();
        this.lblUngeocodedValue.setText(String.format("%d / %d places (%s)", ungeocodedCount, placeCount, ToolBox.buildReadablePercentage(ungeocodedCount, placeCount)));
    }

    public void setFilter(Filter value) {
        if (value != null) {
            this.filter = value;
            this.updatePlaceLines();
        }
    }

    public void updatePlaceLines() {
        Places2 places;
        Geography2 geography = this.netGUI.getNet().getGeography2();
        switch (this.filter) {
            case BLANK: {
                places = geography.getBlankPlaces();
                break;
            }
            case CONFLICTUAL: {
                places = geography.getConflictedPlaces();
                break;
            }
            case UNGEOCODED: {
                places = geography.getUngeocodedPlaces();
                break;
            }
            case UNUSED: {
                places = new Places2(geography.getPlaces().size());
                for (Place2 place : geography.getPlaces()) {
                    if (this.valueDescriptors.getCountOf(place.getToponyms()) != 0L) continue;
                    places.add(place);
                }
                break;
            }
            default: {
                places = geography.getPlaces();
            }
        }
        ((PlaceLineModel)this.tblPlaceLines.getModel()).setSource(places);
        this.lblSelectionValue.setText(String.format(" %d / %d (%s)", places.size(), geography.countOfPlaces(), ToolBox.buildReadablePercentage(places.size(), geography.countOfPlaces())));
    }

    public static String buildExtraDataValue(GeoNamesLine line) {
        long id = line.getGeoNameId();
        String feature = line.getFeatureCodePath();
        String admin = line.getAdministrativeCodePath();
        String result = String.format("geonames=[id=%d;feature=%s;admin=%s]", id, StringUtils.defaultIfBlank((CharSequence)feature, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)admin, (CharSequence)""));
        return result;
    }

    public static int fillAutomatically(Places2 places, ProgressStatus progressStatus) throws IOException, FlatDB4GeoNamesException {
        int result = 0;
        FeatureClass[] featureClasses = new FeatureClass[]{FeatureClass.COUNTRY_STATE_REGION, FeatureClass.CITY_VILLAGE};
        if (progressStatus != null) {
            progressStatus.setMax(places.size() * featureClasses.length);
        }
        FeatureClass[] featureClassArray = featureClasses;
        int n = featureClasses.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureClass featureClass = featureClassArray[n2];
            for (Place2 place : places) {
                GeoNamesLine line;
                if (Thread.interrupted()) {
                    return result;
                }
                if (progressStatus != null) {
                    progressStatus.inc();
                }
                if (place.getCoordinate() != null) continue;
                GeoNamesSearchCriteria criteria = new GeoNamesSearchCriteria();
                criteria.setInput(place.getToponym());
                criteria.featureClasses().add((Object)featureClass);
                GeoNamesLines lines = FlatDB4GeoNames.instance().search(criteria);
                if (lines.size() == 1) {
                    line = (GeoNamesLine)lines.get(0);
                } else {
                    boolean ended = false;
                    line = null;
                    Iterator iterator = lines.iterator();
                    while (!ended) {
                        if (iterator.hasNext()) {
                            GeoNamesLine subLine = (GeoNamesLine)iterator.next();
                            if (!StringUtils.equalsIgnoreCase((CharSequence)subLine.getName(), (CharSequence)place.getToponym())) continue;
                            if (line == null) {
                                line = subLine;
                                continue;
                            }
                            line = null;
                            ended = true;
                            continue;
                        }
                        ended = true;
                    }
                }
                if (line == null) continue;
                if (progressStatus != null) {
                    progressStatus.incExtra1();
                }
                place.setLatitude(line.getLatitude());
                place.setLongitude(line.getLongitude());
                place.setElevation(line.getElevation());
                place.setAlternateToponyms(line.getAlternateNames());
                place.setExtraData(GeographyEditorPanel.buildExtraDataValue(line));
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public static enum Filter {
        ALL,
        BLANK,
        CONFLICTUAL,
        UNGEOCODED,
        UNUSED;

    }
}

