/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Net;
import org.tip.puck.net.random.RandomNetMaker;
import org.tip.puck.net.workers.NetReporter;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.PuckGUI;
import org.tip.puckgui.views.RandomCorpusCriteria;
import org.tip.puckgui.views.mas.AgnaticCousinsWeightFactor;
import org.tip.puckgui.views.mas.CousinsWeightFactor;
import org.tip.puckgui.views.mas.Divorce2WeightFactor;
import org.tip.puckgui.views.mas.DivorceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeDifferenceWeightFactor;
import org.tip.puckgui.views.mas.NormalAgeWeightFactor;
import org.tip.puckgui.views.mas.PregnancyWeightFactor;
import org.tip.puckgui.views.mas.UterineCousinsWeightFactor;
import org.tip.puckgui.views.mas.WeightFactor;

public class RandomCorpusMASInputWindow
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(RandomCorpusMASInputWindow.class);
    private static final long serialVersionUID = -6113524443785800524L;
    private JFrame thisJFrame;
    private JPanel contentPane;
    private JSpinner spnrInitialPopulation;
    private JSpinner spnrFertilityRate;
    private JSpinner spnrMaxAge;
    private JSpinner spnrYear;
    private JSpinner spnrDivorceProbability;
    private JCheckBox chckbxDivorce;
    private JCheckBox chckbxDivorce2;
    private JCheckBox chckbxNormalAgeFemale;
    private JCheckBox chckbxNormalAgeMale;
    private JCheckBox chckbxNormalAgeUnknown;
    private JCheckBox chckbxNormalAgeDifference;
    private JCheckBox chckbxAgnaticCousins;
    private JCheckBox chckbxPregnancy;
    private JPanel panelDivorce;
    private JPanel panelDivorce2;
    private JPanel panelNormalAgeDifference;
    private JPanel panelCousins;
    private JPanel panelPregnancy;
    private JPanel panelNormalAgeMale;
    private JPanel panelNormalAgeUnknown;
    private JPanel panelNormalAgeFemale;
    private JSpinner spnrNormalAgeDifferenceStdev;
    private JSpinner spnrNormalAgeDifferenceMean;
    private JSpinner spnrNormalAgeMaleMean;
    private JSpinner spnrNormalAgeMaleStdev;
    private JSpinner spnrNormalAgeFemaleMean;
    private JSpinner spnrNormalAgeFemaleStdev;
    private JSpinner spnrFemaleDivorceWeight;
    private JSpinner spnrMaleDivorceWeight;
    private JSpinner spnrBothDivorceWeight;
    private JSpinner spnrAgnaticCousinsCharlie;
    private JSpinner spnrPregnancyAlpha;
    private JSpinner spnrNormalAgeUnknownMean;
    private JSpinner spnrNormalAgeUnknownStdev;
    private JSpinner spnrAgnaticCousinsAlpha;
    private JSpinner spnrAgnaticCousinsBravo;
    private JLabel lblChildren;
    private JCheckBox chckbxChildren;
    private JPanel panelChildren;
    private JLabel label_12;
    private JSpinner spinner;

    public RandomCorpusMASInputWindow(NetGUI gui) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(RandomCorpusMASInputWindow.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.thisJFrame = this;
        this.setTitle("Random Corpus");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 676, 657);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        this.contentPane.add((Component)buttonPanel, "South");
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomCorpusMASInputWindow.this.dispose();
            }
        });
        JButton btnRestoreDefaults = new JButton("Restore defaults");
        btnRestoreDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RandomCorpusMASInputWindow.this.setDefaultCriteria();
            }
        });
        buttonPanel.add(btnRestoreDefaults);
        buttonPanel.add(btnCancel);
        JButton btnLaunch = new JButton("Launch");
        this.getRootPane().setDefaultButton(btnLaunch);
        btnLaunch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RandomCorpusCriteria criteria = RandomCorpusMASInputWindow.this.getCriteria();
                    PuckGUI.instance().getPreferences().setRandomCorpusCriteria(criteria);
                    criteria.setMas(true);
                    RandomNetMaker randomNetMaker = new RandomNetMaker(criteria);
                    Net targetNet = randomNetMaker.createRandomMASNet();
                    Report report = NetReporter.reportRandomCorpusMAS(criteria, randomNetMaker.getMas(), targetNet);
                    NetGUI newGUI = PuckGUI.instance().createNetGUI(new File(targetNet.getLabel()), targetNet);
                    newGUI.addReportTab(report);
                    RandomCorpusMASInputWindow.this.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(RandomCorpusMASInputWindow.this.thisJFrame, message, title, 0);
                }
            }
        });
        buttonPanel.add(btnLaunch);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, "Simulation parameters", 4, 2, null, null));
        this.contentPane.add((Component)panel, "North");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblYear = new JLabel("Year:");
        lblYear.setHorizontalAlignment(0);
        panel.add((Component)lblYear, "2, 2, right, default");
        this.spnrYear = new JSpinner();
        this.spnrYear.setModel(new SpinnerNumberModel(new Integer(300), new Integer(1), null, new Integer(1)));
        panel.add((Component)this.spnrYear, "4, 2");
        JLabel lblInitialPopulation = new JLabel("Initial population:");
        panel.add((Component)lblInitialPopulation, "2, 4, right, default");
        this.spnrInitialPopulation = new JSpinner();
        this.spnrInitialPopulation.setModel(new SpinnerNumberModel(new Integer(100), new Integer(1), null, new Integer(1)));
        panel.add((Component)this.spnrInitialPopulation, "4, 4");
        this.spnrFertilityRate = new JSpinner();
        this.spnrFertilityRate.setModel(new SpinnerNumberModel(new Double(2.0), new Double(0.0), new Double(100.0), new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrFertilityRate.getEditor()).getFormat().setMinimumFractionDigits(5);
        JLabel lblFertilityRate = new JLabel("Fertility rate:");
        panel.add((Component)lblFertilityRate, "2, 6, right, default");
        panel.add((Component)this.spnrFertilityRate, "4, 6");
        JLabel lblMaxAge = new JLabel("Max. age:");
        panel.add((Component)lblMaxAge, "2, 8, right, default");
        this.spnrMaxAge = new JSpinner();
        this.spnrMaxAge.setModel(new SpinnerNumberModel(new Integer(70), new Integer(1), null, new Integer(1)));
        panel.add((Component)this.spnrMaxAge, "4, 8");
        JPanel panel_3 = new JPanel();
        this.contentPane.add((Component)panel_3, "Center");
        panel_3.setLayout(new BoxLayout(panel_3, 1));
        JPanel panel_1 = new JPanel();
        panel_3.add(panel_1);
        JPanel panelWeightFactors = new JPanel();
        panel_3.add(panelWeightFactors);
        panelWeightFactors.setBorder(new TitledBorder(null, "Weight factors", 4, 2, null, null));
        panelWeightFactors.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblDivorce = new JLabel("Divorce");
        panelWeightFactors.add((Component)lblDivorce, "2, 2");
        this.chckbxDivorce = new JCheckBox("");
        this.chckbxDivorce.setSelected(true);
        this.chckbxDivorce.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelDivorce.setVisible(RandomCorpusMASInputWindow.this.chckbxDivorce.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxDivorce, "4, 2");
        this.panelDivorce = new JPanel();
        this.panelDivorce.setEnabled(false);
        panelWeightFactors.add((Component)this.panelDivorce, "6, 2, fill, fill");
        this.panelDivorce.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel label = new JLabel("Probability:");
        this.panelDivorce.add((Component)label, "1, 1");
        this.spnrDivorceProbability = new JSpinner();
        this.spnrDivorceProbability.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
        ((JSpinner.NumberEditor)this.spnrDivorceProbability.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelDivorce.add((Component)this.spnrDivorceProbability, "3, 1");
        JLabel lblDivorce_1 = new JLabel("Divorce2");
        panelWeightFactors.add((Component)lblDivorce_1, "2, 4");
        this.chckbxDivorce2 = new JCheckBox("");
        this.chckbxDivorce2.setSelected(true);
        this.chckbxDivorce2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelDivorce2.setVisible(RandomCorpusMASInputWindow.this.chckbxDivorce2.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxDivorce2, "4, 4");
        this.panelDivorce2 = new JPanel();
        panelWeightFactors.add((Component)this.panelDivorce2, "6, 4, fill, fill");
        this.panelDivorce2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_1 = new JLabel("Female:");
        this.panelDivorce2.add((Component)label_1, "1, 1");
        this.spnrFemaleDivorceWeight = new JSpinner();
        this.spnrFemaleDivorceWeight.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
        ((JSpinner.NumberEditor)this.spnrFemaleDivorceWeight.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelDivorce2.add((Component)this.spnrFemaleDivorceWeight, "3, 1");
        JLabel label_2 = new JLabel("Male:");
        this.panelDivorce2.add((Component)label_2, "5, 1");
        this.spnrMaleDivorceWeight = new JSpinner();
        this.spnrMaleDivorceWeight.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
        ((JSpinner.NumberEditor)this.spnrMaleDivorceWeight.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelDivorce2.add((Component)this.spnrMaleDivorceWeight, "7, 1");
        JLabel label_3 = new JLabel("Both:");
        this.panelDivorce2.add((Component)label_3, "9, 1");
        this.spnrBothDivorceWeight = new JSpinner();
        this.spnrBothDivorceWeight.setModel(new SpinnerNumberModel(new Double(0.01), new Double(0.0), new Double(1.0), new Double(0.01)));
        ((JSpinner.NumberEditor)this.spnrBothDivorceWeight.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelDivorce2.add((Component)this.spnrBothDivorceWeight, "11, 1");
        JLabel lblNormalAgeFemale = new JLabel("Normal age female");
        panelWeightFactors.add((Component)lblNormalAgeFemale, "2, 6");
        this.chckbxNormalAgeFemale = new JCheckBox("");
        this.chckbxNormalAgeFemale.setSelected(true);
        this.chckbxNormalAgeFemale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelNormalAgeFemale.setVisible(RandomCorpusMASInputWindow.this.chckbxNormalAgeFemale.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxNormalAgeFemale, "4, 6");
        this.panelNormalAgeFemale = new JPanel();
        panelWeightFactors.add((Component)this.panelNormalAgeFemale, "6, 6, fill, fill");
        this.panelNormalAgeFemale.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_4 = new JLabel("Mean:");
        this.panelNormalAgeFemale.add((Component)label_4, "1, 1");
        this.spnrNormalAgeFemaleMean = new JSpinner();
        this.spnrNormalAgeFemaleMean.setModel(new SpinnerNumberModel(new Double(25.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeFemaleMean.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeFemale.add((Component)this.spnrNormalAgeFemaleMean, "3, 1");
        JLabel label_5 = new JLabel("Stdev:");
        this.panelNormalAgeFemale.add((Component)label_5, "5, 1");
        this.spnrNormalAgeFemaleStdev = new JSpinner();
        this.spnrNormalAgeFemaleStdev.setModel(new SpinnerNumberModel(new Double(5.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeFemaleStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeFemale.add((Component)this.spnrNormalAgeFemaleStdev, "7, 1");
        JLabel lblNormalAgeMale = new JLabel("Normal age male");
        panelWeightFactors.add((Component)lblNormalAgeMale, "2, 8");
        this.chckbxNormalAgeMale = new JCheckBox("");
        this.chckbxNormalAgeMale.setSelected(true);
        this.chckbxNormalAgeMale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelNormalAgeMale.setVisible(RandomCorpusMASInputWindow.this.chckbxNormalAgeMale.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxNormalAgeMale, "4, 8");
        this.panelNormalAgeMale = new JPanel();
        panelWeightFactors.add((Component)this.panelNormalAgeMale, "6, 8, fill, fill");
        this.panelNormalAgeMale.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_6 = new JLabel("Mean:");
        this.panelNormalAgeMale.add((Component)label_6, "1, 1");
        this.spnrNormalAgeMaleMean = new JSpinner();
        this.spnrNormalAgeMaleMean.setModel(new SpinnerNumberModel(new Double(25.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeMaleMean.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeMale.add((Component)this.spnrNormalAgeMaleMean, "3, 1");
        JLabel label_7 = new JLabel("Stdev:");
        this.panelNormalAgeMale.add((Component)label_7, "5, 1");
        this.spnrNormalAgeMaleStdev = new JSpinner();
        this.spnrNormalAgeMaleStdev.setModel(new SpinnerNumberModel(new Double(5.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeMaleStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeMale.add((Component)this.spnrNormalAgeMaleStdev, "7, 1");
        JLabel lblNormalAgeUnknown = new JLabel("Normal age unknown");
        panelWeightFactors.add((Component)lblNormalAgeUnknown, "2, 10");
        this.chckbxNormalAgeUnknown = new JCheckBox("");
        this.chckbxNormalAgeUnknown.setSelected(true);
        this.chckbxNormalAgeUnknown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelNormalAgeUnknown.setVisible(RandomCorpusMASInputWindow.this.chckbxNormalAgeUnknown.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxNormalAgeUnknown, "4, 10");
        this.panelNormalAgeUnknown = new JPanel();
        panelWeightFactors.add((Component)this.panelNormalAgeUnknown, "6, 10, fill, fill");
        this.panelNormalAgeUnknown.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_8 = new JLabel("Mean:");
        this.panelNormalAgeUnknown.add((Component)label_8, "1, 1");
        this.spnrNormalAgeUnknownMean = new JSpinner();
        this.spnrNormalAgeUnknownMean.setModel(new SpinnerNumberModel(new Double(25.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeUnknownMean.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeUnknown.add((Component)this.spnrNormalAgeUnknownMean, "3, 1");
        JLabel label_9 = new JLabel("Stdev:");
        this.panelNormalAgeUnknown.add((Component)label_9, "5, 1");
        this.spnrNormalAgeUnknownStdev = new JSpinner();
        this.spnrNormalAgeUnknownStdev.setModel(new SpinnerNumberModel(new Double(5.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeUnknownStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeUnknown.add((Component)this.spnrNormalAgeUnknownStdev, "7, 1");
        JLabel lblNormalAgeDifference = new JLabel("Normal age difference");
        panelWeightFactors.add((Component)lblNormalAgeDifference, "2, 12");
        this.chckbxNormalAgeDifference = new JCheckBox("");
        this.chckbxNormalAgeDifference.setSelected(true);
        this.chckbxNormalAgeDifference.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelNormalAgeDifference.setVisible(RandomCorpusMASInputWindow.this.chckbxNormalAgeDifference.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxNormalAgeDifference, "4, 12");
        this.panelNormalAgeDifference = new JPanel();
        panelWeightFactors.add((Component)this.panelNormalAgeDifference, "6, 12, fill, fill");
        this.panelNormalAgeDifference.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel label_10 = new JLabel("Mean:");
        this.panelNormalAgeDifference.add((Component)label_10, "1, 1");
        this.spnrNormalAgeDifferenceMean = new JSpinner();
        this.spnrNormalAgeDifferenceMean.setModel(new SpinnerNumberModel(new Double(0.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeDifferenceMean.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeDifference.add((Component)this.spnrNormalAgeDifferenceMean, "3, 1");
        JLabel label_11 = new JLabel("Stdev:");
        this.panelNormalAgeDifference.add((Component)label_11, "5, 1");
        this.spnrNormalAgeDifferenceStdev = new JSpinner();
        this.spnrNormalAgeDifferenceStdev.setModel(new SpinnerNumberModel(new Double(5.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrNormalAgeDifferenceStdev.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelNormalAgeDifference.add((Component)this.spnrNormalAgeDifferenceStdev, "7, 1");
        JLabel lblAgnaticCousins = new JLabel("Agnatic Cousins");
        panelWeightFactors.add((Component)lblAgnaticCousins, "2, 14");
        this.panelCousins = new JPanel();
        panelWeightFactors.add((Component)this.panelCousins, "6, 14, fill, fill");
        this.panelCousins.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblFirst = new JLabel("First:");
        this.panelCousins.add((Component)lblFirst, "1, 1");
        this.spnrAgnaticCousinsAlpha = new JSpinner();
        this.spnrAgnaticCousinsAlpha.setModel(new SpinnerNumberModel(new Double(1.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrAgnaticCousinsAlpha.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelCousins.add((Component)this.spnrAgnaticCousinsAlpha, "3, 1");
        JLabel lblBravo = new JLabel("Second:");
        this.panelCousins.add((Component)lblBravo, "5, 1");
        this.spnrAgnaticCousinsBravo = new JSpinner();
        this.spnrAgnaticCousinsBravo.setModel(new SpinnerNumberModel(new Double(1.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrAgnaticCousinsBravo.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelCousins.add((Component)this.spnrAgnaticCousinsBravo, "7, 1");
        JLabel lblCharlie = new JLabel("Third:");
        this.panelCousins.add((Component)lblCharlie, "9, 1");
        this.spnrAgnaticCousinsCharlie = new JSpinner();
        this.spnrAgnaticCousinsCharlie.setModel(new SpinnerNumberModel(new Double(1.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrAgnaticCousinsCharlie.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelCousins.add((Component)this.spnrAgnaticCousinsCharlie, "11, 1");
        JLabel lblPregnancy = new JLabel("Pregnancy");
        panelWeightFactors.add((Component)lblPregnancy, "2, 16");
        this.chckbxAgnaticCousins = new JCheckBox("");
        this.chckbxAgnaticCousins.setSelected(true);
        this.chckbxAgnaticCousins.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelCousins.setVisible(RandomCorpusMASInputWindow.this.chckbxAgnaticCousins.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxAgnaticCousins, "4, 14");
        this.panelPregnancy = new JPanel();
        panelWeightFactors.add((Component)this.panelPregnancy, "6, 16, fill, fill");
        this.panelPregnancy.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblAlpha_1 = new JLabel("Alpha:");
        this.panelPregnancy.add((Component)lblAlpha_1, "1, 1");
        this.spnrPregnancyAlpha = new JSpinner();
        this.spnrPregnancyAlpha.setModel(new SpinnerNumberModel(new Double(0.0), new Double(0.0), null, new Double(1.0)));
        ((JSpinner.NumberEditor)this.spnrPregnancyAlpha.getEditor()).getFormat().setMinimumFractionDigits(3);
        this.panelPregnancy.add((Component)this.spnrPregnancyAlpha, "3, 1");
        this.chckbxPregnancy = new JCheckBox("");
        this.chckbxPregnancy.setSelected(true);
        this.chckbxPregnancy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RandomCorpusMASInputWindow.this.panelPregnancy.setVisible(RandomCorpusMASInputWindow.this.chckbxPregnancy.isSelected());
            }
        });
        panelWeightFactors.add((Component)this.chckbxPregnancy, "4, 16");
        this.lblChildren = new JLabel("Children");
        panelWeightFactors.add((Component)this.lblChildren, "2, 18");
        this.chckbxChildren = new JCheckBox("");
        this.chckbxChildren.setSelected(true);
        panelWeightFactors.add((Component)this.chckbxChildren, "4, 18");
        this.panelChildren = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panelChildren.getLayout();
        flowLayout.setAlignment(0);
        panelWeightFactors.add((Component)this.panelChildren, "6, 18, fill, fill");
        this.label_12 = new JLabel("0:");
        this.panelChildren.add(this.label_12);
        this.spinner = new JSpinner();
        this.panelChildren.add(this.spinner);
        this.setDefaultCriteria();
        this.setCriteria(PuckGUI.instance().getPreferences().getRandomCorpusMASCriteria());
    }

    public RandomCorpusCriteria getCriteria() throws PuckException {
        WeightFactor factor;
        RandomCorpusCriteria result = new RandomCorpusCriteria();
        result.setYear((Integer)this.spnrYear.getValue());
        result.setInitialPopulation((Integer)this.spnrInitialPopulation.getValue());
        result.setFertilityRate((Double)this.spnrFertilityRate.getValue());
        result.setMaxAge((Integer)this.spnrMaxAge.getValue());
        result.weightFactors().clear();
        if (this.chckbxDivorce.isSelected()) {
            factor = new DivorceWeightFactor();
            ((DivorceWeightFactor)factor).setProbability((Double)this.spnrDivorceProbability.getValue());
            result.weightFactors().add(factor);
        }
        if (this.chckbxDivorce2.isSelected()) {
            factor = new Divorce2WeightFactor();
            ((Divorce2WeightFactor)factor).setFemaleProbability((Double)this.spnrFemaleDivorceWeight.getValue());
            ((Divorce2WeightFactor)factor).setMaleProbability((Double)this.spnrMaleDivorceWeight.getValue());
            ((Divorce2WeightFactor)factor).setBothProbability((Double)this.spnrBothDivorceWeight.getValue());
            result.weightFactors().add(factor);
        }
        if (this.chckbxNormalAgeFemale.isSelected()) {
            factor = new NormalAgeWeightFactor();
            ((NormalAgeWeightFactor)factor).setGender(Gender.FEMALE);
            ((NormalAgeWeightFactor)factor).setMean((Double)this.spnrNormalAgeFemaleMean.getValue());
            ((NormalAgeWeightFactor)factor).setStdev((Double)this.spnrNormalAgeFemaleStdev.getValue());
            result.weightFactors().add(factor);
        }
        if (this.chckbxNormalAgeMale.isSelected()) {
            factor = new NormalAgeWeightFactor();
            ((NormalAgeWeightFactor)factor).setGender(Gender.MALE);
            ((NormalAgeWeightFactor)factor).setMean((Double)this.spnrNormalAgeMaleMean.getValue());
            ((NormalAgeWeightFactor)factor).setStdev((Double)this.spnrNormalAgeMaleStdev.getValue());
            result.weightFactors().add(factor);
        }
        if (this.chckbxNormalAgeUnknown.isSelected()) {
            factor = new NormalAgeWeightFactor();
            ((NormalAgeWeightFactor)factor).setGender(Gender.UNKNOWN);
            ((NormalAgeWeightFactor)factor).setMean((Double)this.spnrNormalAgeUnknownMean.getValue());
            ((NormalAgeWeightFactor)factor).setStdev((Double)this.spnrNormalAgeUnknownStdev.getValue());
            result.weightFactors().add(factor);
        }
        if (this.chckbxNormalAgeDifference.isSelected()) {
            factor = new NormalAgeDifferenceWeightFactor();
            ((NormalAgeDifferenceWeightFactor)factor).setMean((Double)this.spnrNormalAgeDifferenceMean.getValue());
            ((NormalAgeDifferenceWeightFactor)factor).setStdev((Double)this.spnrNormalAgeDifferenceStdev.getValue());
            result.weightFactors().add(factor);
        }
        if (this.chckbxAgnaticCousins.isSelected()) {
            factor = new CousinsWeightFactor();
            ((CousinsWeightFactor)factor).setFirst((Double)this.spnrAgnaticCousinsAlpha.getValue());
            ((CousinsWeightFactor)factor).setSecond((Double)this.spnrAgnaticCousinsBravo.getValue());
            ((CousinsWeightFactor)factor).setThird((Double)this.spnrAgnaticCousinsCharlie.getValue());
            result.weightFactors().add(factor);
        }
        if (this.chckbxPregnancy.isSelected()) {
            factor = new PregnancyWeightFactor();
            ((PregnancyWeightFactor)factor).setFirst((Double)this.spnrPregnancyAlpha.getValue());
            result.weightFactors().add(factor);
        }
        return result;
    }

    public void setCriteria(RandomCorpusCriteria source) {
        if (source == null) {
            this.setDefaultCriteria();
        } else {
            this.spnrYear.setValue(source.getYear());
            this.spnrInitialPopulation.setValue(source.getInitialPopulation());
            this.spnrFertilityRate.setValue(source.getFertilityRate());
            this.spnrMaxAge.setValue(source.getMaxAge());
            this.chckbxDivorce.setSelected(false);
            this.chckbxDivorce2.setSelected(false);
            this.chckbxNormalAgeFemale.setSelected(false);
            this.chckbxNormalAgeMale.setSelected(false);
            this.chckbxNormalAgeUnknown.setSelected(false);
            this.chckbxNormalAgeDifference.setSelected(false);
            this.chckbxAgnaticCousins.setSelected(false);
            this.chckbxPregnancy.setSelected(false);
            block13: for (WeightFactor factor : source.weightFactors()) {
                switch (factor.getType()) {
                    case DIVORCE: {
                        this.chckbxDivorce.setSelected(true);
                        this.spnrDivorceProbability.setValue(((DivorceWeightFactor)factor).getProbability());
                        break;
                    }
                    case DIVORCE2: {
                        this.chckbxDivorce2.setSelected(true);
                        this.spnrFemaleDivorceWeight.setValue(((Divorce2WeightFactor)factor).getFemaleProbability());
                        this.spnrMaleDivorceWeight.setValue(((Divorce2WeightFactor)factor).getMaleProbability());
                        this.spnrBothDivorceWeight.setValue(((Divorce2WeightFactor)factor).getBothProbability());
                        break;
                    }
                    case NORMAL_AGE: {
                        NormalAgeWeightFactor normalAgeFactor = (NormalAgeWeightFactor)factor;
                        switch (normalAgeFactor.getGender()) {
                            case FEMALE: {
                                this.chckbxNormalAgeFemale.setSelected(true);
                                this.spnrNormalAgeFemaleMean.setValue(normalAgeFactor.getMean());
                                this.spnrNormalAgeFemaleStdev.setValue(normalAgeFactor.getStdev());
                                break;
                            }
                            case MALE: {
                                this.chckbxNormalAgeMale.setSelected(true);
                                this.spnrNormalAgeMaleMean.setValue(normalAgeFactor.getMean());
                                this.spnrNormalAgeMaleStdev.setValue(normalAgeFactor.getStdev());
                                break;
                            }
                            case UNKNOWN: {
                                this.chckbxNormalAgeUnknown.setSelected(true);
                                this.spnrNormalAgeUnknownMean.setValue(normalAgeFactor.getMean());
                                this.spnrNormalAgeUnknownStdev.setValue(normalAgeFactor.getStdev());
                            }
                        }
                        continue block13;
                    }
                    case NORMAL_AGE_DIFFERENCE: {
                        this.chckbxNormalAgeDifference.setSelected(true);
                        this.spnrNormalAgeDifferenceMean.setValue(((NormalAgeDifferenceWeightFactor)factor).getMean());
                        this.spnrNormalAgeDifferenceStdev.setValue(((NormalAgeDifferenceWeightFactor)factor).getStdev());
                        break;
                    }
                    case AGNATICCOUSINS: {
                        this.chckbxAgnaticCousins.setSelected(true);
                        this.spnrAgnaticCousinsAlpha.setValue(((AgnaticCousinsWeightFactor)factor).getFirst());
                        this.spnrAgnaticCousinsBravo.setValue(((AgnaticCousinsWeightFactor)factor).getSecond());
                        this.spnrAgnaticCousinsCharlie.setValue(((AgnaticCousinsWeightFactor)factor).getThird());
                        break;
                    }
                    case PREGNANCY: {
                        this.chckbxPregnancy.setSelected(true);
                        this.spnrPregnancyAlpha.setValue(((PregnancyWeightFactor)factor).getFirst());
                    }
                }
            }
        }
    }

    public void setDefaultCriteria() {
        RandomCorpusCriteria defaultCriteria = new RandomCorpusCriteria();
        defaultCriteria.weightFactors().add(new DivorceWeightFactor());
        defaultCriteria.weightFactors().add(new Divorce2WeightFactor());
        NormalAgeWeightFactor factor = new NormalAgeWeightFactor();
        factor.setGender(Gender.MALE);
        defaultCriteria.weightFactors().add(factor);
        factor = new NormalAgeWeightFactor();
        factor.setGender(Gender.FEMALE);
        defaultCriteria.weightFactors().add(factor);
        factor = new NormalAgeWeightFactor();
        factor.setGender(Gender.UNKNOWN);
        defaultCriteria.weightFactors().add(factor);
        defaultCriteria.weightFactors().add(new NormalAgeDifferenceWeightFactor());
        defaultCriteria.weightFactors().add(new CousinsWeightFactor());
        defaultCriteria.weightFactors().add(new AgnaticCousinsWeightFactor());
        defaultCriteria.weightFactors().add(new UterineCousinsWeightFactor());
        defaultCriteria.weightFactors().add(new PregnancyWeightFactor());
        this.setCriteria(defaultCriteria);
        defaultCriteria.weightFactors().clear();
        this.setCriteria(defaultCriteria);
    }
}

