/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.census.chains.ChainMaker;
import org.tip.puck.census.chains.Notation;
import org.tip.puck.census.workers.ChainValuator;
import org.tip.puck.census.workers.SiblingMode;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.net.FiliationType;
import org.tip.puck.report.Report;
import org.tip.puckgui.NetGUI;

public class CalculatorWindow {
    private static final Logger logger = LoggerFactory.getLogger(CalculatorWindow.class);
    private JFrame frmCalculator;
    private JTextField txtfld1;
    private JTextField txtfld2;
    private JTextField txtfld3;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton rdbtn1;
    private JRadioButton rdbtn2;
    private JRadioButton rdbtn3;
    private NetGUI netGUI;

    public CalculatorWindow(NetGUI netGUI) {
        this.netGUI = netGUI;
        this.initialize();
    }

    private String calculate(String str1, String str2, Calculation calculation) {
        Notation notation = Chain.notation(str1);
        Chain chain1 = ChainMaker.fromString(str1);
        Chain chain2 = ChainMaker.fromString(str2);
        Chain chain = null;
        switch (calculation) {
            case SWITCHNOTATION: {
                chain = chain1;
                if (notation == Notation.CLASSIC_GENDERED) {
                    notation = Notation.POSITIONAL;
                    break;
                }
                if (notation != Notation.POSITIONAL) break;
                notation = Notation.CLASSIC_GENDERED;
                break;
            }
            case STANDARD: {
                if (chain1.isHetero()) {
                    chain1.setSymmetry(SymmetryType.PERMUTABLE);
                } else {
                    chain1.setSymmetry(SymmetryType.INVERTIBLE);
                }
                chain = chain1.standard();
                break;
            }
            case CLOSE: {
                break;
            }
            case REFLECT: {
                chain = chain1.reflect();
                break;
            }
            case ROTATE: {
                chain = chain1.rotate();
                break;
            }
            case COMPOSE: {
                chain = ChainMaker.compose(chain1, chain2);
                break;
            }
            case INSERT: {
                chain = ChainMaker.insert(chain1, chain2);
            }
        }
        String result = chain != null ? chain.signature(notation) : "";
        return result;
    }

    public JFrame getJFrame() {
        JFrame result = this.frmCalculator;
        return result;
    }

    public String getSelectedInput() {
        String result = this.rdbtn1.isSelected() ? this.txtfld1.getText() : (this.rdbtn2.isSelected() ? this.txtfld2.getText() : this.txtfld3.getText());
        return result;
    }

    private void initialize() {
        this.frmCalculator = new JFrame();
        this.frmCalculator.setTitle("Calculator");
        this.frmCalculator.setBounds(100, 100, 347, 274);
        this.frmCalculator.setDefaultCloseOperation(3);
        JPanel panel_1 = new JPanel();
        this.frmCalculator.getContentPane().add((Component)panel_1, "Center");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JPanel panel = new JPanel();
        panel_1.add(panel);
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.rdbtn1 = new JRadioButton("");
        this.buttonGroup.add(this.rdbtn1);
        this.rdbtn1.setSelected(true);
        panel.add((Component)this.rdbtn1, "2, 4");
        JLabel label = new JLabel("1");
        panel.add((Component)label, "4, 4, right, default");
        this.txtfld1 = new JTextField();
        panel.add((Component)this.txtfld1, "6, 4, fill, default");
        this.txtfld1.setColumns(10);
        this.rdbtn2 = new JRadioButton("");
        this.buttonGroup.add(this.rdbtn2);
        panel.add((Component)this.rdbtn2, "2, 6");
        JLabel label_1 = new JLabel("2");
        panel.add((Component)label_1, "4, 6, right, default");
        this.txtfld2 = new JTextField();
        panel.add((Component)this.txtfld2, "6, 6, fill, default");
        this.txtfld2.setColumns(10);
        this.rdbtn3 = new JRadioButton("");
        this.buttonGroup.add(this.rdbtn3);
        panel.add((Component)this.rdbtn3, "2, 8");
        JLabel label_2 = new JLabel("3");
        panel.add((Component)label_2, "4, 8, right, default");
        this.txtfld3 = new JTextField();
        panel.add((Component)this.txtfld3, "6, 8, fill, default");
        this.txtfld3.setColumns(10);
        JPanel panel_2 = new JPanel();
        panel_1.add(panel_2);
        panel_2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu"), FormFactory.GLUE_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JButton btnCanonic = new JButton("Standard");
        btnCanonic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String str = CalculatorWindow.this.getSelectedInput();
                    CalculatorWindow.this.setSelectedInput(CalculatorWindow.this.calculate(str, null, Calculation.STANDARD));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        panel_2.add((Component)btnCanonic, "2, 2");
        JButton btnReflect = new JButton("Reflect");
        btnReflect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String str = CalculatorWindow.this.getSelectedInput();
                    CalculatorWindow.this.setSelectedInput(CalculatorWindow.this.calculate(str, null, Calculation.REFLECT));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        panel_2.add((Component)btnReflect, "4, 2");
        JButton btnRotate = new JButton("Rotate");
        btnRotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String str = CalculatorWindow.this.getSelectedInput();
                    CalculatorWindow.this.setSelectedInput(CalculatorWindow.this.calculate(str, null, Calculation.ROTATE));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        panel_2.add((Component)btnRotate, "6, 2");
        JButton btnCompose = new JButton("Compose");
        btnCompose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String str1 = CalculatorWindow.this.txtfld1.getText();
                    String str2 = CalculatorWindow.this.txtfld2.getText();
                    CalculatorWindow.this.txtfld3.setText(CalculatorWindow.this.calculate(str1, str2, Calculation.COMPOSE));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        panel_2.add((Component)btnCompose, "4, 4");
        JButton btnInsert = new JButton("Insert");
        btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String str1 = CalculatorWindow.this.txtfld1.getText();
                    String str2 = CalculatorWindow.this.txtfld2.getText();
                    CalculatorWindow.this.txtfld3.setText(CalculatorWindow.this.calculate(str1, str2, Calculation.INSERT));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        panel_2.add((Component)btnInsert, "6, 4");
        JButton btnCombine = new JButton("Closure");
        btnCombine.setEnabled(false);
        btnCombine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String str = CalculatorWindow.this.getSelectedInput();
                    CalculatorWindow.this.setSelectedInput(CalculatorWindow.this.calculate(str, null, Calculation.CLOSE));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        panel_2.add((Component)btnCombine, "2, 4");
        JButton btnVary = new JButton("Develop");
        btnVary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Report report = new Report();
                    report.inputs().add("Chain Development", CalculatorWindow.this.getSelectedInput());
                    ArrayList<Chain> chains = new ArrayList<Chain>();
                    ChainMaker.develop(chains, CalculatorWindow.this.getSelectedInput(), SiblingMode.FULL, true, FiliationType.COGNATIC);
                    for (Chain chain : chains) {
                        report.outputs().appendln(String.valueOf(chain.signature(Notation.POSITIONAL)) + "\t" + chain.signature(Notation.CLASSIC_GENDERED));
                    }
                    CalculatorWindow.this.netGUI.addReportTab(report);
                    CalculatorWindow.this.frmCalculator.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        panel_2.add((Component)btnVary, "4, 6");
        JButton btnAnalyze = new JButton("Analyze");
        btnAnalyze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Chain chain = ChainMaker.fromString(CalculatorWindow.this.getSelectedInput());
                    Report report = new Report();
                    report.inputs().add("Chain Analysis", CalculatorWindow.this.getSelectedInput());
                    ChainValuator.ChainProperty[] chainPropertyArray = ChainValuator.ChainProperty.values();
                    int n = chainPropertyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ChainValuator.ChainProperty property = chainPropertyArray[n2];
                        report.outputs().appendln((Object)((Object)property) + "\t" + ChainValuator.get(chain, property.toString()));
                        ++n2;
                    }
                    List<Chain> permutations = ChainMaker.getPermutations(chain);
                    report.outputs().appendln(String.valueOf(permutations.size()) + " permutations:");
                    for (Chain permutation : permutations) {
                        report.outputs().appendln("\t" + permutation.signature(Notation.POSITIONAL) + "\t" + permutation.signature(Notation.CLASSIC_GENDERED));
                    }
                    CalculatorWindow.this.netGUI.addReportTab(report);
                    CalculatorWindow.this.frmCalculator.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    String title = "Error computerum est";
                    String message = "Error occured during working: " + exception.getMessage();
                    JOptionPane.showMessageDialog(CalculatorWindow.this.frmCalculator, message, title, 0);
                }
            }
        });
        JButton btnSwitch = new JButton("Switch");
        btnSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = CalculatorWindow.this.getSelectedInput();
                CalculatorWindow.this.setSelectedInput(CalculatorWindow.this.calculate(str, null, Calculation.SWITCHNOTATION));
            }
        });
        panel_2.add((Component)btnSwitch, "2, 6");
        panel_2.add((Component)btnAnalyze, "6, 6");
    }

    public void setSelectedInput(String value) {
        if (this.rdbtn1.isSelected()) {
            this.txtfld1.setText(value);
        } else if (this.rdbtn2.isSelected()) {
            this.txtfld2.setText(value);
        } else {
            this.txtfld3.setText(value);
        }
    }

    private static enum Calculation {
        SWITCHNOTATION,
        STANDARD,
        CLOSE,
        REFLECT,
        ROTATE,
        COMPOSE,
        INSERT;

    }
}

