/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.partition;

import java.util.LinkedList;
import java.util.List;

public class PartitionItem<E> {
    private PartitionItem<E> parent;
    private PartitionItem<E> child;
    private int rank;
    private final E value;

    protected static <E> PartitionItem<E> singleton(E value) {
        return new PartitionItem<E>(value);
    }

    private PartitionItem(E value) {
        this.value = value;
        this.parent = this;
        this.child = null;
        this.rank = 0;
    }

    public E value() {
        return this.value;
    }

    protected PartitionItem<E> merge(PartitionItem<E> other) {
        PartitionItem<E> root1 = other.find();
        PartitionItem<E> root2 = this.find();
        if (root1.rank < root2.rank) {
            root1.parent = root2;
            PartitionItem.getLastChild(root2).child = root1;
            return root2;
        }
        if (root1.rank > root2.rank) {
            root2.parent = root1;
            PartitionItem.getLastChild(root1).child = root2;
            return root1;
        }
        root2.parent = root1;
        PartitionItem.getLastChild(root1).child = root2;
        ++root1.rank;
        return root1;
    }

    protected PartitionItem<E> append(PartitionItem<E> other) {
        PartitionItem<E> otherRoot = other.find();
        otherRoot.parent = this;
        PartitionItem.getLastChild(this).child = otherRoot;
        return this;
    }

    protected List<E> values() {
        LinkedList<E> result = new LinkedList<E>();
        result.add(this.value);
        PartitionItem<E> tmp = this.child;
        while (tmp != null) {
            result.add(tmp.value());
            System.out.println("parent has been already added? " + result.contains(tmp.parent.value));
            tmp = tmp.child;
        }
        return result;
    }

    protected PartitionItem<E> getParent() {
        return this.parent;
    }

    protected PartitionItem<E> getChild() {
        return this.child;
    }

    protected int getRank() {
        return this.rank;
    }

    public boolean isSingleton() {
        return this.equals(this.parent) && this.child == null && this.rank == 0;
    }

    public PartitionItem<E> find() {
        PartitionItem<E> current = this;
        while (current.parent != current) {
            current = current.parent;
        }
        return current;
    }

    private static <E> PartitionItem<E> getLastChild(PartitionItem<E> partition) {
        PartitionItem<E> tmpPartition = partition;
        while (tmpPartition.child != null) {
            tmpPartition = tmpPartition.child;
        }
        return tmpPartition;
    }

    public static <E> List<E> toValues(PartitionItem<E> partition) {
        PartitionItem<E> rep = partition.find();
        PartitionItem<E> tmp = rep.child;
        LinkedList<E> retSet = new LinkedList<E>();
        retSet.add(rep.value);
        while (tmp != null) {
            retSet.add(tmp.value());
            tmp = tmp.child;
        }
        return retSet;
    }
}

