/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.tip.puck.PuckException;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CircuitFinder;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.KinType;
import org.tip.puck.net.Net;
import org.tip.puck.net.workers.FamilyValuator;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Clusters;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportAttributes;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.statistics.BIASCount;
import org.tip.puck.statistics.BIASCounts;
import org.tip.puck.statistics.FiliationCount;
import org.tip.puck.statistics.FiliationCounts;
import org.tip.puck.statistics.GenderedDouble;
import org.tip.puck.statistics.GenderedInt;
import org.tip.puck.statistics.NumberedFiliationCountLists;
import org.tip.puck.util.IntWithMax;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedIntegers;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class StatisticsWorker {
    Individuals individuals;
    Families families;
    GenderedInt genderDistribution;
    int partnershipCount;
    int marriageCount;
    int fertileCount;
    int filiationCount;
    IntWithMax components;
    Partition<Individual> agnaticPartition;
    Partition<Individual> uterinePartition;

    public void addItem(ReportAttributes items, Indicator indicator) {
        items.add(indicator.toString(), this.getValue(indicator));
    }

    StatisticsWorker(Individuals individuals, Families families) throws PuckException {
        this.individuals = individuals;
        this.families = families;
        this.genderDistribution = StatisticsWorker.genderDistribution(individuals);
        this.partnershipCount = StatisticsWorker.numberOfPartnerships(families);
        this.marriageCount = StatisticsWorker.numberOfMarriages(families);
        this.fertileCount = StatisticsWorker.numberOfFertileMarriages(families);
        this.filiationCount = StatisticsWorker.numberOfFiliationTies(families);
        this.components = StatisticsWorker.numberOfComponents(individuals);
        this.agnaticPartition = PartitionMaker.createRaw("PATRIC partition", individuals, "PATRIC");
        this.uterinePartition = PartitionMaker.createRaw("MATRIC partition", individuals, "MATRIC");
    }

    StatisticsWorker(Net net) throws PuckException {
        this(net.individuals(), net.families());
    }

    StatisticsWorker(Segmentation segmentation) throws PuckException {
        this(segmentation.getCurrentIndividuals(), segmentation.getCurrentFamilies());
    }

    public Value getValue(Indicator indicator) {
        Value result;
        switch (indicator) {
            case NR_INDIVIDUALS: {
                result = new Value(this.individuals.size());
                break;
            }
            case NR_MEN: {
                result = new Value(this.genderDistribution.getMenValue());
                break;
            }
            case NR_WOMEN: {
                result = new Value(this.genderDistribution.getWomenValue());
                break;
            }
            case NR_UNKNOWN: {
                result = new Value(this.genderDistribution.getUnknownValue());
                break;
            }
            case NR_MARRIAGES: {
                result = new Value(this.marriageCount);
                break;
            }
            case NR_UNIONS: {
                result = new Value(this.partnershipCount);
                break;
            }
            case NR_NONSINGLE_MEN: {
                result = new Value(StatisticsWorker.numberOfNotSingles(this.individuals, Gender.MALE));
                break;
            }
            case NR_NONSINGLE_WOMEN: {
                result = new Value(StatisticsWorker.numberOfNotSingles(this.individuals, Gender.FEMALE));
                break;
            }
            case NR_FILIATION_TIES: {
                result = new Value(this.filiationCount);
                break;
            }
            case NR_FERTILE_UNIONS: {
                result = new Value(String.format("%d (%.2f%%)", this.fertileCount, MathUtils.percent(this.fertileCount, this.marriageCount)));
                break;
            }
            case NR_COWIFE_RELIATIONS: {
                result = new Value(StatisticsWorker.numberOfCoSpouseRelations(this.individuals, Gender.FEMALE));
                break;
            }
            case NR_COHUSBAND_RELIATIONS: {
                result = new Value(StatisticsWorker.numberOfCoSpouseRelations(this.individuals, Gender.MALE));
                break;
            }
            case NR_COMPONENTS: {
                result = new Value(String.format("%d (max. %d)", this.components.value(), this.components.max()));
                break;
            }
            case MEAN_COMPONENT_SHARE_AGNATIC: {
                result = new Value(String.format("%.2f%% (without singletons: %.2g%%)", this.agnaticPartition.meanShare(), this.agnaticPartition.meanShare(2)));
                break;
            }
            case MEAN_COMPONENT_SHARE_UTERINE: {
                result = new Value(String.format("%.2f%% (without singletons: %.2g%%)", this.uterinePartition.meanShare(), this.uterinePartition.meanShare(2)));
                break;
            }
            case MAX_COMPONENT_SHARE_AGNATIC: {
                result = new Value(String.format("%.2f%%", this.agnaticPartition.maxShare()));
                break;
            }
            case MAX_COMPONENT_SHARE_UTERINE: {
                result = new Value(String.format("%.2f%%", this.uterinePartition.maxShare()));
                break;
            }
            case CYCLOMATIC_NR: {
                result = new Value(this.marriageCount + this.filiationCount - this.individuals.size() + this.components.value());
                break;
            }
            case MARRIAGE_DENSITY: {
                result = new Value(String.format("%.2f%%", StatisticsWorker.densityOfMarriages(this.marriageCount, this.individuals.size())));
                break;
            }
            case FILIATION_DENSITY: {
                result = new Value(String.format("%.2f%%", StatisticsWorker.densityOfFiliations(this.filiationCount, this.individuals.size())));
                break;
            }
            case DEPTH: {
                result = new Value(StatisticsWorker.depth(this.individuals));
                break;
            }
            case MEAN_DEPTH: {
                result = new Value(StatisticsWorker.meanDepth(this.individuals));
                break;
            }
            case MEAN_NR_SPOUSES_MEN: {
                result = new Value(StatisticsWorker.meanNumberOfSpouses(this.individuals, Gender.MALE));
                break;
            }
            case MEAN_NR_SPOUSES_WOMEN: {
                result = new Value(StatisticsWorker.meanNumberOfSpouses(this.individuals, Gender.FEMALE));
                break;
            }
            case MEAN_AGNATIC_SIBSET_SIZE: {
                result = new Value(StatisticsWorker.meanSibsetSize(this.individuals, Gender.MALE));
                break;
            }
            case MEAN_UTERINE_SIBSET_SIZE: {
                result = new Value(StatisticsWorker.meanSibsetSize(this.individuals, Gender.FEMALE));
                break;
            }
            case MEAN_FULL_SIBSET_SIZE: {
                result = new Value(StatisticsWorker.meanSibsetSize(this.families));
                break;
            }
            case MEAN_SPOUSE_DISTANCE_GEN: {
                result = new Value(MathUtils.round(StatisticsWorker.meanSpouseDistance(this.individuals, this.families, "GEN"), 2));
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static String getValueString(Net net) throws PuckException {
        String result = net.getLabel();
        StatisticsWorker worker = new StatisticsWorker(net);
        Indicator[] indicatorArray = Indicator.values();
        int n = indicatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Indicator indicator = indicatorArray[n2];
            result = String.valueOf(result) + "\t";
            Value value = worker.getValue(indicator);
            if (value != null) {
                result = String.valueOf(result) + value.toString();
            }
            ++n2;
        }
        return result;
    }

    public static void getDistances(Individual ego, int maxDistance, FiliationType filiationType, Report report) {
        Map<Individual, Integer> distances = StatisticsWorker.distances(ego, maxDistance, filiationType);
        for (Individual individual : distances.keySet()) {
            individual.setAttribute("DIST " + ego.getId(), "" + distances.get(individual));
        }
        TreeSet<Map.Entry<Individual, Integer>> sortedEntries = new TreeSet<Map.Entry<Individual, Integer>>(new Comparator<Map.Entry<Individual, Integer>>(){

            @Override
            public int compare(Map.Entry<Individual, Integer> e1, Map.Entry<Individual, Integer> e2) {
                int res = e1.getValue().compareTo(e2.getValue());
                return res != 0 ? res : 1;
            }
        });
        sortedEntries.addAll(distances.entrySet());
        report.outputs().appendln("Relatives " + (Object)((Object)filiationType) + " of " + ego);
        report.outputs().appendln();
        for (Map.Entry entry : sortedEntries) {
            report.outputs().appendln(entry.getValue() + "\t" + entry.getKey());
        }
    }

    public static Map<Individual, Set<Individual>> neighborSets(Individuals individuals, int maxDistance, FiliationType filiationType) {
        HashMap<Individual, Set<Individual>> result = new HashMap<Individual, Set<Individual>>();
        for (Individual ego : individuals) {
            result.put(ego, new HashSet());
        }
        for (Individual ego : individuals) {
            Map<Individual, Integer> distances = StatisticsWorker.distances(ego, maxDistance, filiationType);
            Set egosNeighbors = (Set)result.get(ego);
            for (Individual alter : individuals) {
                if (alter.getId() <= ego.getId() || distances.get(alter) == null || distances.get(alter) <= 0) continue;
                egosNeighbors.add(alter);
                ((Set)result.get(alter)).add(ego);
            }
        }
        System.out.println("neighborSet finished");
        return result;
    }

    public static Map<Individual, Map<Individual, Double>> neighborWeights(Individuals individuals, int maxDistance, FiliationType filiationType, double weight) {
        HashMap<Individual, Map<Individual, Double>> result = new HashMap<Individual, Map<Individual, Double>>();
        for (Individual ego : individuals) {
            result.put(ego, new HashMap());
        }
        for (Individual ego : individuals) {
            Map<Individual, Integer> distances = StatisticsWorker.distances(ego, maxDistance, filiationType);
            Map weights = (Map)result.get(ego);
            for (Individual alter : individuals) {
                if (alter.getId() <= ego.getId()) continue;
                Map alterWeights = (Map)result.get(alter);
                if (distances.get(alter) != null && distances.get(alter) > 0 && filiationType.hasLinkingGender(alter.getGender())) {
                    weights.put(alter, weight);
                    alterWeights.put(ego, weight);
                    continue;
                }
                weights.put(alter, 1.0);
                alterWeights.put(ego, 1.0);
            }
        }
        System.out.println("weightMap finished");
        return result;
    }

    public static Map<Individual, Integer> distances(Individual ego, int maxDistance, FiliationType filiationType) {
        HashMap<Individual, Integer> result = new HashMap<Individual, Integer>();
        result.put(ego, 0);
        if (!filiationType.residential() || filiationType.hasLinkingGender(ego.getGender())) {
            StatisticsWorker.addUpDistances(result, ego, 0, maxDistance, filiationType);
            StatisticsWorker.addDownDistances(result, ego, 0, maxDistance, filiationType);
        } else {
            for (Individual spouse : ego.spouses()) {
                result.put(spouse, 1);
                StatisticsWorker.addUpDistances(result, spouse, 1, maxDistance, filiationType);
                StatisticsWorker.addDownDistances(result, spouse, 1, maxDistance, filiationType);
            }
        }
        return result;
    }

    private static void addUpDistances(Map<Individual, Integer> distances, Individual ego, int distance, int maxDistance, FiliationType filiationType) {
        Individual father = ego.getFather();
        if (filiationType.hasLinkingGender(Gender.MALE) && father != null && (distances.get(father) == null || distances.get(father) > ++distance)) {
            distances.put(father, distance);
            if (distance < maxDistance) {
                StatisticsWorker.addUpDistances(distances, father, distance, maxDistance, filiationType);
                StatisticsWorker.addDownDistances(distances, father, distance, maxDistance, filiationType);
            }
        }
        Individual mother = ego.getMother();
        if (filiationType.hasLinkingGender(Gender.FEMALE) && mother != null && (distances.get(mother) == null || distances.get(mother) > distance)) {
            distances.put(mother, distance);
            if (distance < maxDistance) {
                StatisticsWorker.addUpDistances(distances, mother, distance, maxDistance, filiationType);
                StatisticsWorker.addDownDistances(distances, mother, distance, maxDistance, filiationType);
            }
        }
    }

    private static void addDownDistances(Map<Individual, Integer> distances, Individual ego, int distance, int maxDistance, FiliationType filiationType) {
        if (filiationType.hasLinkingGender(ego.getGender())) {
            ++distance;
            for (Individual child : ego.children()) {
                if (distances.get(child) != null && distances.get(child) <= distance || filiationType.residential() && !filiationType.hasLinkingGender(child.getGender())) continue;
                distances.put(child, distance);
                if (distance >= maxDistance) continue;
                StatisticsWorker.addDownDistances(distances, child, distance, maxDistance, filiationType);
            }
            if (filiationType.residential()) {
                for (Individual spouse : ego.spouses()) {
                    if (distances.get(spouse) != null && distances.get(spouse) <= distance) continue;
                    distances.put(spouse, distance);
                }
            }
        }
    }

    public static Individual ancestor(Individual ego, FiliationType type) {
        Individual result = StatisticsWorker.ancestor(ego, type, new HashMap<Individual, Individual>());
        return result;
    }

    public static Individual ancestor(Individual ego, FiliationType type, HashMap<Individual, Individual> stack) {
        Individual result;
        if (type == null || type != FiliationType.AGNATIC && type != FiliationType.UTERINE) {
            result = ego;
        } else {
            result = stack.get(ego);
            if (result == null) {
                Individual parent = ego.getOriginFamily() == null ? null : (type == FiliationType.AGNATIC ? ego.getFather() : (type == FiliationType.UTERINE ? ego.getMother() : null));
                result = parent == null ? ego : StatisticsWorker.ancestor(parent, type, stack);
                stack.put(ego, result);
            }
        }
        return result;
    }

    public static HashMap<Individual, Individual> ancestors(Individuals individuals, FiliationType type) {
        HashMap<Individual, Individual> result = new HashMap<Individual, Individual>(individuals.size());
        for (Individual individual : individuals) {
            if (result.get(individual) != null) continue;
            StatisticsWorker.ancestor(individual, type, result);
        }
        return result;
    }

    public static NumberedFiliationCountLists ascendantsCounts(Individuals source, int maxAscending) {
        NumberedFiliationCountLists result;
        if (source == null) {
            result = null;
        } else {
            Individuals extendedSource = new Individuals(source.size());
            for (Individual individual : source) {
                extendedSource.add(individual);
                for (Individual parent : individual.getParents()) {
                    if (parent == null) continue;
                    extendedSource.add(parent);
                }
            }
            result = new NumberedFiliationCountLists(extendedSource.size());
            for (Individual individual : extendedSource) {
                FiliationCounts counts = new FiliationCounts(maxAscending, maxAscending);
                FiliationCount firstCount = counts.get(0);
                if (individual.getFather() != null) {
                    firstCount.incAgnatic();
                    firstCount.incCognatic();
                }
                if (individual.getMother() != null) {
                    firstCount.incUterine();
                    firstCount.incCognatic();
                }
                result.put(individual.getId(), counts);
            }
            int ascendingIndex = 1;
            while (ascendingIndex < maxAscending) {
                for (Individual individual : source) {
                    FiliationCounts counts = (FiliationCounts)result.get(individual.getId());
                    for (Individual parent : individual.getParents()) {
                        FiliationCounts parentCounts = (FiliationCounts)result.get(parent.getId());
                        counts.get(ascendingIndex).addCognatic(parentCounts.get(ascendingIndex - 1).getCognatic());
                        switch (parent.getGender()) {
                            case FEMALE: {
                                counts.get(ascendingIndex).addUterine(parentCounts.get(ascendingIndex - 1).getUterine());
                                break;
                            }
                            case MALE: {
                                counts.get(ascendingIndex).addAgnatic(parentCounts.get(ascendingIndex - 1).getAgnatic());
                            }
                        }
                    }
                }
                ++ascendingIndex;
            }
        }
        return result;
    }

    public static FiliationCounts biasDegrees(Individuals individuals) throws PuckException {
        Partition<Individual> matridPartition = PartitionMaker.createRaw("MATRID partition", individuals, "MATRID");
        Partition<Individual> patridPartition = PartitionMaker.createRaw("PATRID partition", individuals, "PATRID");
        FiliationCounts result = new FiliationCounts(10, 10);
        for (Individual individual : individuals) {
            Value value = matridPartition.getValue(individual);
            int uterineMin = value == null || value.isNotNumber() ? 0 : Math.min(9, value.intValue());
            value = patridPartition.getValue(individual);
            int agnaticMin = value == null || value.isNotNumber() ? 0 : Math.min(9, value.intValue());
            int cognaticMin = Math.min(uterineMin, agnaticMin);
            int degreeIndex = 0;
            while (degreeIndex < uterineMin) {
                result.get(degreeIndex + 1).incUterine();
                ++degreeIndex;
            }
            degreeIndex = 0;
            while (degreeIndex < agnaticMin) {
                result.get(degreeIndex + 1).incAgnatic();
                ++degreeIndex;
            }
            degreeIndex = 0;
            while (degreeIndex < cognaticMin) {
                result.get(degreeIndex + 1).incCognatic();
                ++degreeIndex;
            }
        }
        return result;
    }

    public static BIASCounts biasNetWeights(Individuals individuals) throws PuckException {
        FiliationCounts counts = StatisticsWorker.biasDegrees(individuals);
        BIASCounts result = new BIASCounts(10, 10);
        int degreeIndex = 1;
        while (degreeIndex < 10) {
            FiliationCount sourceCount = counts.get(degreeIndex);
            BIASCount targetCount = result.get(degreeIndex);
            double coo = sourceCount.getUterine() + sourceCount.getAgnatic() - sourceCount.getCognatic();
            targetCount.setCoo(coo);
            targetCount.setUterine(MathUtils.percent(sourceCount.getUterine() - sourceCount.getCognatic(), coo));
            targetCount.setAgnatic(MathUtils.percent(sourceCount.getAgnatic() - sourceCount.getCognatic(), coo));
            targetCount.setCognatic(MathUtils.percent(0.0, coo));
            ++degreeIndex;
        }
        return result;
    }

    public static String listCircuitFrequencies(Segmentation segmentation, String classificationType, String pattern) throws PuckException {
        String result = segmentation.getLabel();
        CensusCriteria criteria = new CensusCriteria();
        criteria.setChainClassification(classificationType);
        criteria.setPattern(pattern);
        CircuitFinder finder = new CircuitFinder(segmentation, criteria);
        finder.findCircuits();
        finder.count();
        result = String.valueOf(result) + finder.listCircuitFrequencies();
        return result;
    }

    public static boolean hasSameGenderMarriages(Net net) {
        boolean result = false;
        for (Family family : net.families()) {
            if (!family.isSameGender()) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String listBiasWeights(Net net) throws PuckException {
        String result = net.getLabel();
        BIASCounts biasCounts = StatisticsWorker.biasWeights(net.individuals());
        int i = 1;
        while (i < 6) {
            result = String.valueOf(result) + "\t" + biasCounts.get(i).getAgnatic();
            ++i;
        }
        i = 1;
        while (i < 6) {
            result = String.valueOf(result) + "\t" + biasCounts.get(i).getUterine();
            ++i;
        }
        return result;
    }

    public static BIASCounts biasWeights(Individuals individuals) throws PuckException {
        FiliationCounts counts = StatisticsWorker.biasDegrees(individuals);
        BIASCounts result = new BIASCounts(10, 10);
        result.get(0).setUterine(50.0);
        result.get(0).setAgnatic(50.0);
        result.get(0).setCognatic(50.0);
        int degreeIndex = 1;
        while (degreeIndex < 10) {
            FiliationCount sourceCount = counts.get(degreeIndex);
            BIASCount targetCount = result.get(degreeIndex);
            double coo = sourceCount.getUterine() + sourceCount.getAgnatic() - sourceCount.getCognatic();
            targetCount.setCoo(coo);
            targetCount.setUterine(MathUtils.percent(sourceCount.getUterine(), coo));
            targetCount.setAgnatic(MathUtils.percent(sourceCount.getAgnatic(), coo));
            targetCount.setCognatic(MathUtils.percent(sourceCount.getCognatic(), coo));
            ++degreeIndex;
        }
        return result;
    }

    public static <E> NumberedIntegers clusterSizeDistribution(Partition<E> source) {
        NumberedIntegers result;
        if (source == null) {
            result = null;
        } else {
            result = new NumberedIntegers();
            for (Cluster<E> cluster : source.getClusters()) {
                if (cluster.getValue() == null) continue;
                Integer count = (Integer)result.get(cluster.size());
                if (count == null) {
                    count = 0;
                }
                result.put(cluster.size(), count + 1);
            }
        }
        return result;
    }

    public static FiliationCounts completeness(Individuals individuals, int maxAscending) {
        NumberedFiliationCountLists ascendantsCounts = StatisticsWorker.ascendantsCounts(individuals, maxAscending);
        int sterileCount = 0;
        FiliationCounts ascendantSum = new FiliationCounts(maxAscending, maxAscending);
        for (Individual individual : individuals) {
            if (!individual.isSterile()) continue;
            ++sterileCount;
            FiliationCounts ascendantCounts = (FiliationCounts)ascendantsCounts.get(individual.getId());
            int ascendingIndex = 0;
            while (ascendingIndex < maxAscending) {
                ascendantSum.get(ascendingIndex).add(ascendantCounts.get(ascendingIndex));
                ++ascendingIndex;
            }
        }
        FiliationCounts result = new FiliationCounts(maxAscending + 1);
        int ascendingIndex = 1;
        while (ascendingIndex < maxAscending + 1) {
            if (ascendantSum.get(ascendingIndex - 1).getCognatic() != 0.0) {
                FiliationCount previousSum = ascendantSum.get(ascendingIndex - 1);
                FiliationCount count = result.get(ascendingIndex);
                count.setCognatic(MathUtils.percent(previousSum.getCognatic(), (double)sterileCount * Math.pow(2.0, ascendingIndex)));
                count.setAgnatic(MathUtils.percent(previousSum.getAgnatic(), (double)sterileCount));
                count.setUterine(MathUtils.percent(previousSum.getUterine(), (double)sterileCount));
            }
            ++ascendingIndex;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static FiliationCounts components(Individuals individuals, int resolution) throws PuckException {
        FiliationCounts result;
        if (individuals == null) {
            result = null;
        } else {
            void var5_8;
            result = new FiliationCounts(resolution);
            Partition<Individual> agnaticPartition = PartitionMaker.createRaw("PATRIC partition", individuals, "PATRIC");
            for (Cluster<Individual> cluster : agnaticPartition.getClusters()) {
                int share = MathUtils.toIntAmplified(agnaticPartition.share(cluster), resolution);
                result.get(share).incAgnatic();
            }
            Partition<Individual> partition = PartitionMaker.createRaw("MATRIC partition", individuals, "MATRIC");
            for (Cluster<Individual> cluster : partition.getClusters()) {
                int share = MathUtils.toIntAmplified(partition.share(cluster), resolution);
                result.get(share).incUterine();
            }
            boolean bl = false;
            while (var5_8 < resolution) {
                FiliationCount count = result.get((int)var5_8);
                count.setAgnatic(MathUtils.percent(count.getAgnatic(), (double)agnaticPartition.size()));
                count.setUterine(MathUtils.percent(count.getUterine(), (double)partition.size()));
                ++var5_8;
            }
        }
        return result;
    }

    protected static int componentSize(Individual root, Set<Individual> visited) {
        Stack<Individual> stack = new Stack<Individual>();
        int result = 1;
        visited.add(root);
        stack.push(root);
        while (!stack.isEmpty()) {
            Individual individual = (Individual)stack.pop();
            KinType[] kinTypeArray = KinType.values();
            int n = kinTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                KinType kinType = kinTypeArray[n2];
                Individuals kins = individual.getKin(kinType);
                if (!kins.isEmpty()) {
                    for (Individual kin : kins) {
                        if (visited.contains(kin)) continue;
                        visited.add(kin);
                        ++result;
                        stack.push(kin);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static void count(Individual individual, ArrayList<Integer> depthData, int level) {
        Individual mother;
        Individual father;
        if (level > depthData.size()) {
            depthData.add(0);
        }
        if (level > 0) {
            depthData.set(level - 1, depthData.get(level - 1) + 1);
        }
        if ((father = individual.getFather()) != null) {
            StatisticsWorker.count(father, depthData, level + 1);
        }
        if ((mother = individual.getMother()) != null) {
            StatisticsWorker.count(mother, depthData, level + 1);
        }
    }

    public static double[][] countConsanguinePairs(Segmentation segmentation, int maxDegree) throws PuckException {
        double[][] result = new double[maxDegree][4];
        int[][] count = new int[maxDegree][4];
        int hommes = 0;
        int femmes = 0;
        CensusCriteria criteria = new CensusCriteria();
        criteria.setPattern(String.valueOf(maxDegree));
        criteria.setClosingRelation("OPEN");
        CircuitFinder finder = new CircuitFinder(segmentation, criteria);
        finder.setLinkDomain(finder.getSearchDomain());
        Map<Individual, Map<Individual, Integer>> consanguineMap = finder.getConsanguines(maxDegree);
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            if (ego.isMale()) {
                ++hommes;
            } else if (ego.isFemale()) {
                ++femmes;
            }
            Map<Individual, Integer> consanguines = consanguineMap.get(ego);
            for (Individual alter : consanguines.keySet()) {
                if (alter.getId() <= ego.getId()) continue;
                int degree = consanguines.get(alter);
                if (alter.getGender() != ego.getGender()) {
                    int[] nArray = count[degree - 1];
                    nArray[2] = nArray[2] + 1;
                    continue;
                }
                int[] nArray = count[degree - 1];
                int n = alter.getGender().toInt();
                nArray[n] = nArray[n] + 1;
            }
        }
        int i = 0;
        while (i < maxDegree) {
            result[i][0] = MathUtils.percent(2 * count[i][0], 100 * hommes);
            result[i][1] = MathUtils.percent(2 * count[i][1], 100 * femmes);
            result[i][2] = MathUtils.percent(count[i][2], 100 * hommes);
            result[i][3] = MathUtils.percent(count[i][2], 100 * femmes);
            ++i;
        }
        return result;
    }

    public static int depth(Individual individual) {
        int result = StatisticsWorker.depth(individual, new NumberedIntegers(1000), FiliationType.COGNATIC);
        return result;
    }

    public static int depth(Individual individual, FiliationType type) {
        int result = StatisticsWorker.depth(individual, new NumberedIntegers(1000), type);
        return result;
    }

    public static int depth(Individual individual, NumberedIntegers depthData, FiliationType type) {
        int result;
        Integer value = (Integer)depthData.get(individual.getId());
        if (value == null) {
            if (individual.getOriginFamily() == null) {
                result = 0;
            } else {
                switch (type) {
                    case AGNATIC: {
                        Individual father = individual.getFather();
                        if (father == null) {
                            result = 0;
                            break;
                        }
                        result = StatisticsWorker.depth(father, depthData, type) + 1;
                        break;
                    }
                    case UTERINE: {
                        Individual mother = individual.getMother();
                        if (mother == null) {
                            result = 0;
                            break;
                        }
                        result = StatisticsWorker.depth(mother, depthData, type) + 1;
                        break;
                    }
                    case COGNATIC: {
                        Individual father = individual.getFather();
                        Individual mother = individual.getMother();
                        if (father == null && mother == null) {
                            result = 0;
                            break;
                        }
                        if (father == null) {
                            result = StatisticsWorker.depth(mother, depthData, type) + 1;
                            break;
                        }
                        if (mother == null) {
                            result = StatisticsWorker.depth(father, depthData, type) + 1;
                            break;
                        }
                        result = Math.max(StatisticsWorker.depth(mother, depthData, type), StatisticsWorker.depth(father, depthData, type)) + 1;
                        break;
                    }
                    default: {
                        result = 0;
                    }
                }
            }
            depthData.put(individual.getId(), result);
        } else {
            result = value;
        }
        return result;
    }

    public static int depth(Individuals source) {
        int result = StatisticsWorker.depthData(source, FiliationType.COGNATIC).max();
        return result;
    }

    public static int depth(Net source) {
        int result = StatisticsWorker.depth(source.individuals());
        return result;
    }

    public static int depth(Net net, FiliationType type) {
        int result = StatisticsWorker.depthData(net, type).max();
        return result;
    }

    public static NumberedIntegers depthData(Individuals source, FiliationType type) {
        NumberedIntegers result = new NumberedIntegers(source.size());
        NumberedIntegers depthData = new NumberedIntegers(source.size());
        for (Individual individual : source) {
            Integer value = (Integer)depthData.get(individual.getId());
            if (value == null) {
                value = StatisticsWorker.depth(individual, depthData, type);
            }
            result.put(individual.getId(), value);
        }
        return result;
    }

    public static NumberedIntegers depthData(Net source, FiliationType type) {
        NumberedIntegers result = new NumberedIntegers(source.individuals().size());
        for (Individual individual : source.individuals()) {
            if (result.get(individual.getId()) != null) continue;
            StatisticsWorker.depth(individual, result, type);
        }
        return result;
    }

    public static FiliationCounts sibsetDistribution(Individuals individuals) throws PuckException {
        Partition<Individual> mPartition = PartitionMaker.createRaw("SIBSETM partition", individuals, "SIBSETM");
        Partition<Individual> pPartition = PartitionMaker.createRaw("SIBSETP partition", individuals, "SIBSETP");
        NumberedIntegers mDistribution = StatisticsWorker.clusterSizeDistribution(mPartition);
        NumberedIntegers pDistribution = StatisticsWorker.clusterSizeDistribution(pPartition);
        int max = Math.max((Integer)Collections.max(mDistribution.keySet()), (Integer)Collections.max(pDistribution.keySet()));
        FiliationCounts result = new FiliationCounts(max, max);
        int countIndex = 0;
        while (countIndex < result.size()) {
            FiliationCount count = result.get(countIndex);
            Integer value = (Integer)pDistribution.get(countIndex);
            if (value != null) {
                count.setAgnatic(value.intValue());
            }
            if ((value = (Integer)mDistribution.get(countIndex)) != null) {
                count.setUterine(value.intValue());
            }
            ++countIndex;
        }
        return result;
    }

    private static boolean fulfillsDistanceCriteria(KinType k, int egoLevel, int alterLevel) {
        int maximalDistance = 3;
        boolean result = Math.abs(egoLevel - alterLevel) > maximalDistance ? false : k.toInt() * (egoLevel - alterLevel) >= 0;
        return result;
    }

    public static int gen(Individual individual, NumberedIntegers genData, int defaultLevel, int[] minimalLevel) {
        Integer result = (Integer)genData.get(individual.getId());
        if (result == null) {
            Stack<Individual> stack = new Stack<Individual>();
            genData.put(individual.getId(), defaultLevel);
            stack.push(individual);
            while (!stack.isEmpty()) {
                StatisticsWorker.setGeneration((Individual)stack.pop(), genData, minimalLevel, stack);
            }
            result = (Integer)genData.get(individual.getId());
        }
        return result;
    }

    public static NumberedValues getSpouseDistances(Families source, String label) {
        NumberedValues result = new NumberedValues(source.size());
        for (Family family : source) {
            Double distance = FamilyValuator.getSpouseDistance(family, label);
            if (distance == null) continue;
            result.put(family.getId(), new Value(distance));
        }
        return result;
    }

    public static NumberedValues getSpouseDistances(Families source, Individuals individuals, String label) {
        NumberedValues result = new NumberedValues(source.size());
        NumberedValues individualValues = IndividualValuator.get(individuals, label);
        for (Family family : source) {
            Double distance = FamilyValuator.getSpouseDistance(family, individualValues);
            if (distance == null) continue;
            result.put(family.getId(), new Value(distance));
        }
        return result;
    }

    public static double meanSpouseDistance(Individuals individuals, Families families, String label) {
        double result = StatisticsWorker.getSpouseDistances(families, individuals, label).average();
        return result;
    }

    public static NumberedIntegers genData(Individuals source) {
        NumberedIntegers result = new NumberedIntegers(source.size());
        NumberedIntegers genData = new NumberedIntegers(source.size());
        int defaultLevel = source.size() / 2;
        int[] minimalLevel = new int[]{defaultLevel};
        for (Individual individual : source) {
            Integer value = (Integer)genData.get(individual.getId());
            if (value == null) {
                value = StatisticsWorker.gen(individual, genData, defaultLevel, minimalLevel);
            }
            result.put(individual.getId(), value);
        }
        int adjustment = minimalLevel[0] - 1;
        for (Individual individual : source) {
            Integer value = (Integer)genData.get(individual.getId());
            result.put(individual.getId(), value - adjustment);
        }
        return result;
    }

    public static GenderedDouble genderPercentageDistribution(GenderedInt source) {
        GenderedDouble result = new GenderedDouble();
        int total = source.total();
        result.setMenValue(MathUtils.percent(source.getMenValue(), total));
        result.setWomenValue(MathUtils.percent(source.getWomenValue(), total));
        result.setUnknownValue(MathUtils.percent(source.getUnknownValue(), total));
        return result;
    }

    public static GenderedInt genderDistribution(Individuals individuals) {
        GenderedInt result = new GenderedInt();
        for (Individual individual : individuals) {
            switch (individual.getGender()) {
                case FEMALE: {
                    result.incWomen();
                    break;
                }
                case MALE: {
                    result.incMen();
                    break;
                }
                case UNKNOWN: {
                    result.incUnknown();
                }
            }
        }
        return result;
    }

    public static GenderedInt genderDistribution(Net net) {
        GenderedInt result = StatisticsWorker.genderDistribution(net.individuals());
        return result;
    }

    public static Map<Cluster<Individual>, Double> meanClusterValues(Clusters<Individual> source, PartitionCriteria valueCriteria) throws PuckException {
        HashMap<Cluster<Individual>, Double> result = new HashMap<Cluster<Individual>, Double>();
        Individuals individuals = new Individuals();
        for (Cluster<Individual> cluster : source) {
            individuals.put(cluster.getItems());
        }
        Partition<Individual> partition = PartitionMaker.createRaw("values", individuals, valueCriteria.getLabel(), valueCriteria.getLabelParameter());
        for (Cluster<Individual> cluster : source) {
            int count = 0;
            double sum = 0.0;
            for (Individual individual : cluster.getItems()) {
                int value = partition.getValue(individual).intValue();
                if (valueCriteria.getValueFilter() == PartitionCriteria.ValueFilter.ZERO && value == 0) continue;
                sum += (double)partition.getValue(individual).intValue();
                ++count;
            }
            if (count == 0) {
                result.put(cluster, 0.0);
                continue;
            }
            result.put(cluster, sum / (double)count);
        }
        return result;
    }

    @Deprecated
    public static Map<Cluster<Individual>, Double> meanClusterValues(Individuals source, PartitionCriteria partitionCriteria, String label, String labelParameter) throws PuckException {
        HashMap<Cluster<Individual>, Double> result = new HashMap<Cluster<Individual>, Double>();
        Partition<Individual> partition = PartitionMaker.create("partition", source, partitionCriteria);
        Partition<Individual> valuesPartition = PartitionMaker.createRaw("values", source, label, labelParameter);
        for (Cluster<Individual> cluster : partition.getClusters()) {
            double sum = 0.0;
            for (Individual individual : cluster.getItems()) {
                sum += (double)valuesPartition.getValue(individual).intValue();
            }
            result.put(cluster, sum / (double)cluster.count());
        }
        return result;
    }

    public static double meanDepth(Individual individual) {
        ArrayList<Integer> depthData = new ArrayList<Integer>();
        StatisticsWorker.count(individual, depthData, 0);
        double result = 0.0;
        int depth = 0;
        while (depth < depthData.size()) {
            int value = depthData.get(depth);
            result += MathUtils.percent((double)value, 100.0 * Math.pow(2.0, depth + 1));
            ++depth;
        }
        return result;
    }

    public static double meanDepth(Individuals individuals) {
        double count = 0.0;
        int number = 0;
        for (Individual individual : individuals.toSortedList()) {
            if (!individual.isSterile()) continue;
            count += StatisticsWorker.meanDepth(individual);
            ++number;
        }
        double result = MathUtils.percent(count, (double)(100 * number));
        return result;
    }

    public static double meanSibsetSize(Individuals individuals, Gender gender) {
        int count = 0;
        int number = 0;
        for (Individual individual : individuals) {
            if (!individual.getGender().matchs(gender) || individual.isSterile()) continue;
            count += individual.children().size();
            ++number;
        }
        double result = MathUtils.percent(count, 100 * number);
        return result;
    }

    public static double meanSibsetSize(Families families) {
        int count = 0;
        int number = 0;
        for (Family family : families) {
            if (family.getChildren().size() <= 0) continue;
            count += family.getChildren().size();
            ++number;
        }
        double result = MathUtils.percent(count, 100 * number);
        return result;
    }

    public static double meanNumberOfSpouses(Individuals individuals, Gender gender) {
        int count = 0;
        int number = 0;
        for (Individual individual : individuals) {
            int spouses;
            if (individual.getGender() != gender || (spouses = individual.spouses().size()) <= 0) continue;
            count += spouses;
            ++number;
        }
        double result = MathUtils.percent(count, 100 * number);
        return result;
    }

    public static GenderedInt numberOfAttributes(Net net, String label, boolean sym) {
        GenderedInt result = new GenderedInt();
        for (Individual ego : net.individuals()) {
            for (Attribute attribute : ego.attributes()) {
                if (!attribute.getLabel().equals(label)) continue;
                result.inc();
                switch (ego.getGender()) {
                    case FEMALE: {
                        result.incWomen();
                        break;
                    }
                    case MALE: {
                        result.incMen();
                        break;
                    }
                    case UNKNOWN: {
                        result.incUnknown();
                    }
                }
            }
        }
        if (sym) {
            result.set(result.get() / 2);
        }
        return result;
    }

    public static IntWithMax numberOfComponents(Individuals source) {
        IntWithMax result = new IntWithMax();
        HashSet<Individual> visited = new HashSet<Individual>();
        for (Individual individual : source.toSortedList()) {
            if (visited.contains(individual)) continue;
            result.inc();
            result.challengeMax(StatisticsWorker.componentSize(individual, visited));
        }
        return result;
    }

    public static Partition<Individual> components(Individuals source) {
        Partition<Individual> result = new Partition<Individual>();
        for (Individual root : source.toSortedList()) {
            if (result.getItems().contains(root)) continue;
            Value value = new Value(root);
            result.put(root, value);
            Stack<Individual> stack = new Stack<Individual>();
            stack.push(root);
            while (!stack.isEmpty()) {
                Individual individual = (Individual)stack.pop();
                KinType[] kinTypeArray = KinType.values();
                int n = kinTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    KinType kinType = kinTypeArray[n2];
                    Individuals kins = individual.getKin(kinType);
                    if (!kins.isEmpty()) {
                        for (Individual kin : kins) {
                            if (result.getCluster(value).getItems().contains(kin)) continue;
                            result.put(kin, value);
                            stack.push(kin);
                        }
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    public static int numberOfCoSpouseRelations(Individuals source, Gender gender) {
        int result;
        if (gender == null || gender.isUnknown()) {
            result = 0;
        } else {
            result = 0;
            for (Individual commonSpouse : source) {
                if (commonSpouse.getGender() != gender.invert() || !commonSpouse.isNotSingle()) continue;
                int coSpouses = commonSpouse.spouses().size();
                int coSpouseRelations = coSpouses * (coSpouses - 1) / 2;
                result += coSpouseRelations;
            }
        }
        return result;
    }

    public static int numberOfCoSpouses(Net net, Gender gender) {
        int result = StatisticsWorker.numberOfCoSpouseRelations(net.individuals(), gender);
        return result;
    }

    public static int numberOfFertileMarriages(Families families) {
        int result = 0;
        for (Family family : families) {
            if (!family.hasMarried() || !family.isFertile() || family.getHusband() == null || family.getWife() == null) continue;
            ++result;
        }
        return result;
    }

    public static double densityOfMarriages(long marriageCount, long individualCount) {
        double result = MathUtils.percent(100L * marriageCount, individualCount * (individualCount - 1L));
        return result;
    }

    public static double densityOfFiliations(long filiationCount, long individualCount) {
        double result = MathUtils.percent(100L * filiationCount, individualCount * (individualCount - 1L));
        return result;
    }

    public static int numberOfFiliationTies(Families families) {
        int result = 0;
        for (Family family : families) {
            result += family.getChildren().size() * family.numberOfParents();
        }
        return result;
    }

    public static int numberOfFiliationTies(Net net) {
        int result = StatisticsWorker.numberOfFiliationTies(net.families());
        return result;
    }

    public static int numberOfLinearKin(Individual source, int deg) {
        int result;
        if (deg == 1) {
            result = source.getParents().size();
        } else if (deg == -1) {
            result = source.children().size();
        } else if (deg < 1) {
            result = 0;
            for (Individual individual : source.children()) {
                result += StatisticsWorker.numberOfLinearKin(individual, deg + 1);
            }
        } else if (deg > 1) {
            result = 0;
            for (Individual individual : source.getParents()) {
                result += StatisticsWorker.numberOfLinearKin(individual, deg - 1);
            }
        } else {
            result = 0;
        }
        return result;
    }

    public static int numberOfMarriages(Families families) {
        int result = 0;
        for (Family family : families) {
            if (!family.hasMarried() || family.getHusband() == null || family.getWife() == null) continue;
            ++result;
        }
        return result;
    }

    public static int numberOfUnions(Families families) {
        int result = 0;
        for (Family family : families) {
            if (family.getHusband() == null || family.getWife() == null) continue;
            ++result;
        }
        return result;
    }

    public static int numberOfPartnerships(Families families) {
        int result = 0;
        for (Family family : families) {
            if (family.getHusband() == null || family.getWife() == null) continue;
            ++result;
        }
        return result;
    }

    public static int numberOfNotSingles(Individuals source, Gender gender) {
        int result = 0;
        for (Individual individual : source) {
            if (individual.getGender() != gender || !individual.isNotSingle()) continue;
            ++result;
        }
        return result;
    }

    public static int numberOfNotSingles(Net net, Gender gender) {
        int result = StatisticsWorker.numberOfNotSingles(net.individuals(), gender);
        return result;
    }

    private static boolean postponeGenerationAssignment(KinType kinType, int egoLevel, int alterLevel, NumberedIntegers genData, int constraint) {
        boolean result;
        switch (constraint) {
            case 0: {
                result = false;
                break;
            }
            case 1: {
                result = StatisticsWorker.fulfillsDistanceCriteria(kinType, egoLevel, alterLevel);
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    private static void setGeneration(Individual individual, NumberedIntegers genData, int[] minimalLevel, Stack<Individual> stack) {
        int constraint = 0;
        Integer egoLevel = (Integer)genData.get(individual.getId());
        KinType[] kinTypeArray = KinType.values();
        int n = kinTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KinType type = kinTypeArray[n2];
            if (individual.getKin(type) != null) {
                for (Individual relative : individual.getKin(type)) {
                    if (relative == null || genData.get(relative.getId()) != null) continue;
                    int alterLevel = egoLevel - type.toInt();
                    if (StatisticsWorker.postponeGenerationAssignment(type, egoLevel, alterLevel, genData, constraint)) continue;
                    genData.put(relative.getId(), alterLevel);
                    if (minimalLevel[0] > alterLevel) {
                        minimalLevel[0] = alterLevel;
                    }
                    stack.push(relative);
                }
            }
            ++n2;
        }
    }

    public static int size(Individuals individuals, Gender gender) {
        int result = 0;
        for (Individual individual : individuals) {
            if (!individual.getGender().matchs(gender)) continue;
            ++result;
        }
        return result;
    }

    public static int size(Net net, Gender gender) {
        int result = StatisticsWorker.size(net.individuals(), gender);
        return result;
    }

    public static long cyclomatic(int marriageCount, int filiationCount, int individualCount, int componentCount) {
        long result = marriageCount + filiationCount - individualCount + componentCount;
        return result;
    }

    static enum Indicator {
        NR_INDIVIDUALS,
        NR_MEN,
        NR_WOMEN,
        NR_UNKNOWN,
        NR_MARRIAGES,
        NR_UNIONS,
        NR_NONSINGLE_MEN,
        NR_NONSINGLE_WOMEN,
        NR_FILIATION_TIES,
        NR_FERTILE_UNIONS,
        NR_COWIFE_RELIATIONS,
        NR_COHUSBAND_RELIATIONS,
        NR_COMPONENTS,
        MEAN_COMPONENT_SHARE_AGNATIC,
        MEAN_COMPONENT_SHARE_UTERINE,
        MAX_COMPONENT_SHARE_AGNATIC,
        MAX_COMPONENT_SHARE_UTERINE,
        CYCLOMATIC_NR,
        MARRIAGE_DENSITY,
        FILIATION_DENSITY,
        DEPTH,
        MEAN_NR_SPOUSES_MEN,
        MEAN_NR_SPOUSES_WOMEN,
        MEAN_AGNATIC_SIBSET_SIZE,
        MEAN_UTERINE_SIBSET_SIZE,
        MEAN_FULL_SIBSET_SIZE,
        MEAN_DEPTH,
        MEAN_SPOUSE_DISTANCE_GEN;


        public String toString() {
            String result;
            switch (this) {
                case NR_INDIVIDUALS: {
                    result = "individuals";
                    break;
                }
                case NR_MEN: {
                    result = "men";
                    break;
                }
                case NR_WOMEN: {
                    result = "women";
                    break;
                }
                case NR_UNKNOWN: {
                    result = "unknown";
                    break;
                }
                case NR_MARRIAGES: {
                    result = "marriages";
                    break;
                }
                case NR_UNIONS: {
                    result = "unions";
                    break;
                }
                case NR_NONSINGLE_MEN: {
                    result = "non-single men";
                    break;
                }
                case NR_NONSINGLE_WOMEN: {
                    result = "non-single women";
                    break;
                }
                case NR_FILIATION_TIES: {
                    result = "parent-child ties";
                    break;
                }
                case NR_FERTILE_UNIONS: {
                    result = "fertile unions";
                    break;
                }
                case NR_COWIFE_RELIATIONS: {
                    result = "co-wife relations";
                    break;
                }
                case NR_COHUSBAND_RELIATIONS: {
                    result = "co-husband relations";
                    break;
                }
                case NR_COMPONENTS: {
                    result = "components";
                    break;
                }
                case MEAN_COMPONENT_SHARE_AGNATIC: {
                    result = "mean component share (agnatic)";
                    break;
                }
                case MEAN_COMPONENT_SHARE_UTERINE: {
                    result = "mean component share (uterine)";
                    break;
                }
                case MAX_COMPONENT_SHARE_AGNATIC: {
                    result = "max component share (agnatic)";
                    break;
                }
                case MAX_COMPONENT_SHARE_UTERINE: {
                    result = "max component share (uterine)";
                    break;
                }
                case CYCLOMATIC_NR: {
                    result = "elementary cycles";
                    break;
                }
                case MARRIAGE_DENSITY: {
                    result = "density (marriages)";
                    break;
                }
                case FILIATION_DENSITY: {
                    result = "density (filiation)";
                    break;
                }
                case DEPTH: {
                    result = "depth";
                    break;
                }
                case MEAN_DEPTH: {
                    result = "mean depth";
                    break;
                }
                case MEAN_NR_SPOUSES_MEN: {
                    result = "mean spouse number of men";
                    break;
                }
                case MEAN_NR_SPOUSES_WOMEN: {
                    result = "mean spouse number of women";
                    break;
                }
                case MEAN_AGNATIC_SIBSET_SIZE: {
                    result = "mean sibset size agnatic";
                    break;
                }
                case MEAN_UTERINE_SIBSET_SIZE: {
                    result = "mean sibset size uterine";
                    break;
                }
                case MEAN_FULL_SIBSET_SIZE: {
                    result = "mean nr of children per fertile couple";
                    break;
                }
                case MEAN_SPOUSE_DISTANCE_GEN: {
                    result = "mean generational distance of spouses";
                    break;
                }
                default: {
                    result = null;
                }
            }
            return result;
        }
    }
}

