/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.partitions.graphs;

import fr.devinsy.util.StringList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.chains.Chain;
import org.tip.puck.evo.EvoGen;
import org.tip.puck.graphs.ClusterPair;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.random.RandomGraphReporter;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.Individual;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.graphs.ClusterNetworkUtils;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.views.GenerateRulesCriteria;

public class ClusterNetworkReporter {
    private static final Logger logger = LoggerFactory.getLogger(ClusterNetworkReporter.class);
    public static StringList ALLIANCE_NETWORK_PARTITION_LABELS = new StringList().append(new String[]{"DEGREE", "STRENGTH", "ID", "SIZE", "INDEGREE", "OUTDEGREE", "INSTRENGTH", "OUTSTRENGTH", "LOOPSTRENGTH"});

    public static Report reportAllianceNetwork(Segmentation source, File currentCorpus, String label, ClusterNetworkUtils.AllianceType allianceType, ClusterNetworkUtils.LineType lineType, int minimalNumberOfLinks, int minimalNodeStrength, double minimalLinkWeight) throws PuckException {
        Graph<Cluster<Individual>> graph;
        if (source == null || currentCorpus == null || label == null || lineType == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        switch (allianceType) {
            case WIFE_HUSBAND: {
                graph = ClusterNetworkUtils.createAllianceNetwork(source, label, lineType);
                break;
            }
            case SISTER_BROTHER: {
                graph = ClusterNetworkUtils.createSiblingNetwork(source, label, lineType);
                break;
            }
            case PARENT_CHILD: {
                graph = ClusterNetworkUtils.createParentChildNetwork(source, label, lineType);
                break;
            }
            default: {
                graph = null;
            }
        }
        graph = GraphUtils.reduce(graph, minimalNumberOfLinks, minimalNodeStrength, minimalLinkWeight);
        Report result = new Report();
        result.setTitle("Alliance Network Report.");
        result.setOrigin("ClusterNetworkReporter.reportInterMarriages()");
        result.setTarget(source.getLabel());
        result.inputs().add("Label", label);
        result.inputs().add("Alliance type", allianceType.toString());
        result.inputs().add("Line type", lineType.toString());
        result.inputs().add("Minimal number of links (node degree)", minimalNumberOfLinks);
        result.inputs().add("Minimal number of alliances per node (node strenght)", minimalNodeStrength);
        result.inputs().add("Minimal number of alliances per link (link weight)", minimalLinkWeight);
        Report report1 = new Report("Analysis");
        report1.outputs().appendln(GraphReporter.getGraphStats(graph));
        result.outputs().append(report1);
        Report report2 = new Report("Matrix");
        report2.outputs().appendln(GraphReporter.getMatrixStrings(graph));
        result.outputs().append(report2);
        Report report3 = new Report("Couples");
        report3.outputs().appendln(GraphReporter.getCoupleList(graph, allianceType));
        result.outputs().append(report3);
        Report report4 = new Report("Sortable list");
        report4.outputs().appendln(GraphReporter.getSortableList(graph));
        result.outputs().append(report4);
        Report reportSides = new Report("Sides");
        reportSides.outputs().appendln(GraphReporter.getSides(graph));
        result.outputs().append(reportSides);
        ReportRawData rawData = new ReportRawData("Export to Pajek", "Pajek", "paj", new File(String.valueOf(currentCorpus.getParent()) + File.separator + ToolBox.clean(graph.getLabel()) + ".paj"));
        rawData.setData(PuckUtils.writePajekNetwork(graph, (List<String>)ALLIANCE_NETWORK_PARTITION_LABELS).toString());
        result.outputs().append(rawData);
        rawData = new ReportRawData("Export to Pajek (edge version)", "Pajek", "paj", new File(String.valueOf(currentCorpus.getParent()) + File.separator + ToolBox.clean(graph.getLabel()) + ".paj"));
        rawData.setData(PuckUtils.writePajekNetwork(GraphUtils.reduceArcToEdge(graph), (List<String>)ALLIANCE_NETWORK_PARTITION_LABELS).toString());
        result.outputs().append(rawData);
        ReportRawData datData = new ReportRawData("Export Matrix to Dat File", "Dat", "dat", new File(String.valueOf(currentCorpus.getParent()) + File.separator + ToolBox.clean(graph.getLabel()) + ".dat"));
        datData.setData(GraphReporter.getRawMatrixStrings(graph).toString());
        result.outputs().append(datData);
        result.outputs().append(" ");
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportAnalysis(Graph<Cluster<Individual>> source) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Analysis");
        result.setOrigin("ClusterNetworkReporter.reportAnalysis()");
        result.setTarget(source.getLabel());
        result.outputs().appendln(GraphReporter.getGraphStats(source));
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportCircuitIntersectionMatrix(Graph<Cluster<Chain>> source) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Report result = new Report("Matrix");
        result.setOrigin("ClusterNetworkReporter.reportMatrix()");
        result.setTarget(source.getLabel());
        result.outputs().appendln(GraphReporter.getMatrixStrings(source));
        String circuitString = "Circuits\t";
        String netMarriageString = "Net Marriages\t";
        int netMarriageSum = 0;
        int circuitSum = 0;
        for (Integer[] numbers : ClusterNetworkUtils.getCircuitAndNetMarriageNumbers(source).values()) {
            circuitString = String.valueOf(circuitString) + numbers[0] + "\t";
            netMarriageString = String.valueOf(netMarriageString) + numbers[1] + "\t";
            circuitSum += numbers[0].intValue();
            netMarriageSum += numbers[1].intValue();
        }
        result.outputs().appendln(String.valueOf(circuitString) + circuitSum);
        result.outputs().appendln(String.valueOf(netMarriageString) + netMarriageSum);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportCouples(Graph<Cluster<Individual>> source, ClusterNetworkUtils.AllianceType allianceType) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Report result = new Report("Couples");
        result.setOrigin("ClusterNetworkReporter.reportCouples()");
        result.setTarget(source.getLabel());
        result.inputs().add("Type", allianceType.toString());
        result.outputs().appendln(GraphReporter.getCoupleList(source, allianceType));
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportDistributions(Graph<Cluster<Individual>> source) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Report result = new Report("Distribution");
        result.setOrigin("ClusterNetworkReporter.reportDistributions()");
        result.setTarget(source.getLabel());
        Map<Double, Double> weightsDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.WEIGHTS, source);
        result.outputs().appendln("Weights Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Weights Distributions", "Weights", weightsDistribution));
        result.outputs().appendln();
        Map<Double, Double> forcesDistribution = MatrixStatistics.getDistribution(MatrixStatistics.DistributionObject.STRENGTHS, source);
        result.outputs().appendln("Forces Distributions");
        result.outputs().appendln(RandomGraphReporter.createDistributionChart("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln(RandomGraphReporter.createDistributionTable("Forces Distributions", "Forces", forcesDistribution));
        result.outputs().appendln();
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFlowNetwork(Segmentation source, File currentCorpus, String relationLabel, String sourceLabel, String targetLabel, String labelParameter, int minimalNumberOfLinks) throws PuckException {
        if (source == null || currentCorpus == null || sourceLabel == null || targetLabel == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Graph<ClusterPair<Attributable>> graph = StringUtils.isBlank((CharSequence)relationLabel) ? ClusterNetworkUtils.createFlowNetwork(source, sourceLabel, targetLabel, ClusterNetworkUtils.LineType.WEIGHTED_ARC) : ClusterNetworkUtils.createFlowNetwork(source, relationLabel, sourceLabel, targetLabel, labelParameter, ClusterNetworkUtils.LineType.WEIGHTED_ARC);
        logger.debug("FlowNetwork raw: {} nodes", (Object)graph.nodeCount());
        graph = GraphUtils.reduce(graph, minimalNumberOfLinks, 0.0, 0.0);
        logger.debug("FlowNetwork reduced: {} nodes", (Object)graph.nodeCount());
        ReportRawData rawData = new ReportRawData("Export to Pajek", "Pajek", "paj", new File(String.valueOf(currentCorpus.getParent()) + File.separator + ToolBox.clean(graph.getLabel()) + ".paj"));
        StringList partitionLabels = new StringList();
        partitionLabels.append("DEGREE");
        partitionLabels.append("STRENGTH");
        partitionLabels.append("ID");
        partitionLabels.append("SIZE");
        partitionLabels.append("INDEGREE");
        partitionLabels.append("OUTDEGREE");
        partitionLabels.append("INSTRENGTH");
        partitionLabels.append("OUTSTRENGTH");
        rawData.setData(PuckUtils.writePajekNetwork(graph, (List<String>)partitionLabels).toString());
        Report result = new Report();
        result.setTitle("Flow Network Report.");
        result.setOrigin("ClusterNetworkReport.reportFlowNetwork()");
        result.setTarget(source.getLabel());
        result.inputs().add("Source Label", sourceLabel);
        result.inputs().add("Target Label", targetLabel);
        result.inputs().add("Minimal number of links", minimalNumberOfLinks);
        Report report1 = new Report("Analysis");
        report1.outputs().appendln(GraphReporter.getGraphStats(graph));
        result.outputs().append(report1);
        Report report2 = new Report("Matrix");
        report2.outputs().appendln(GraphReporter.getMatrixStrings(graph));
        result.outputs().append(report2);
        Report report3 = new Report("Flows");
        if (StringUtils.isBlank((CharSequence)relationLabel)) {
            report3.outputs().appendln(GraphReporter.getIndividualFlowList(graph));
        } else {
            report3.outputs().appendln(GraphReporter.getRelationFlowList(graph));
        }
        result.outputs().append(report3);
        Report report4 = new Report("Sortable list");
        result.outputs().append(report4);
        result.outputs().append(rawData);
        result.outputs().appendln(" ");
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportGenerateRules(Graph<E> source, GenerateRulesCriteria criteria, EvoGen target) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Report result = new Report("Generate Rules");
        result.setOrigin("ClusterNetworkReporter.reportGenerateRules()");
        result.setTarget(source.getLabel());
        result.inputs().add("Generation count", criteria.getGenerationCount());
        result.outputs().appendln(target.infoString());
        result.outputs().appendln(target.genInfoString());
        result.outputs().appendln(target.getBestGenerator().toString());
        try {
            result.outputs().appendln("Rule:");
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
            OutputStreamWriter out = new OutputStreamWriter(buffer);
            target.getBestGenerator().getProgset().write(out, false);
            out.flush();
            result.outputs().appendln(buffer.toString());
        }
        catch (IOException exception) {
            result.outputs().appendln("ERROR reading the progset.");
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static <E> Report reportMatrix(Graph<Cluster<E>> source) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Report result = new Report("Matrix");
        result.setOrigin("ClusterNetworkReporter.reportMatrix()");
        result.setTarget(source.getLabel());
        result.outputs().appendln(GraphReporter.getMatrixStrings(source));
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSides(Graph<Cluster<Individual>> source) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report();
        Chronometer chrono = new Chronometer();
        result = new Report("Sides");
        result.setOrigin("ClusterNetworkReporter.reportSides()");
        result.setTarget(source.getLabel());
        result.outputs().appendln(GraphReporter.getSides(source));
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSortableList(Graph<Cluster<Individual>> source) throws PuckException {
        if (source == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Chronometer chrono = new Chronometer();
        Report result = new Report("Sortable list");
        result.setOrigin("ClusterNetworkReporter.reportSortableList()");
        result.setTarget(source.getLabel());
        result.outputs().appendln(GraphReporter.getSortableList(source));
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

